/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices.modem;

import com.dsoft.powerpro.internet.mserver.InfoPacket;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceRequestPacket;
import com.dsoft.powerpro.monitorserver.devices.modem.CMDeviceMonitoring;
import com.dsoft.powerpro.monitorserver.devices.modem.CMTSFindMonitor;
import com.dsoft.powerpro.monitorserver.snmp.PoolTaskThread;
import com.dsoft.powerpro.monitorserver.snmp.SnmpPoolManager;
import java.util.Map;
import java.util.logging.Level;

public class CMTSFindIndexByIpThread
extends PoolTaskThread {
    private final Map<String, Integer> modemIndexMap;
    private String ip;
    private DeviceOIDParameterPacket cmtsPacket;
    private SnmpPoolManager snmpPoolManager;

    CMTSFindIndexByIpThread(String ip, DeviceRequestPacket packet, Map<String, Integer> modemIndexMap, SnmpPoolManager snmpPoolManager, DeviceOIDParameterPacket cmtsPacket) {
        super(packet, 0L);
        this.ip = ip;
        this.modemIndexMap = modemIndexMap;
        this.snmpPoolManager = snmpPoolManager;
        this.cmtsPacket = cmtsPacket;
    }

    @Override
    protected String getIdString() {
        return CMTSFindIndexByIpThread.class.getName() + ((DeviceRequestPacket)this.getPacket()).getIpAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DeviceOIDParameterPacket packet = this.snmpPoolManager != null ? this.snmpPoolManager.constructDeviceOIDParameterPacket(((DeviceRequestPacket)this.getPacket()).getDeviceId(), null, ((InfoPacket)this.getPacket()).getMarker()) : new DeviceOIDParameterPacket(this.cmtsPacket);
            if (packet == null) {
                return;
            }
            packet.setIpAddress(((DeviceRequestPacket)this.getPacket()).getIpAddress());
            CMTSFindMonitor monitor = new CMTSFindMonitor(packet);
            Map<String, Integer> map = this.modemIndexMap;
            synchronized (map) {
                this.modemIndexMap.put(packet.getIpAddress(), monitor.findModemIndexByIp(this.ip));
            }
        }
        catch (Exception ex) {
            CMDeviceMonitoring.LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

