/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices.modem;

import com.dsoft.framework.client.exception.InvalidMacAddress;
import com.dsoft.framework.client.util.IPUtils;
import com.dsoft.framework.client.util.InternetUtils;
import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitorserver.snmp.SNMPBaseMonitor;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.snmp4j.Snmp;
import org.snmp4j.smi.OctetString;

public class CMTSFindMonitor
extends SNMPBaseMonitor {
    CMTSFindMonitor(DeviceOIDParameterPacket packet) {
        super(packet);
    }

    Integer findModemIndexByIp(String ipAddress) throws Exception {
        Snmp session = this.getSnmpSession();
        try {
            String tmp;
            Object ipaddr;
            Map<String, OIDParameterVariable> responseMap = this.getOidTableVariables(session, "1.3.6.1.2.1.4.20.1.3");
            HashMap<Long, Long> ipAddressMap = new HashMap<Long, Long>();
            for (OIDParameterVariable var : new ArrayList<OIDParameterVariable>(responseMap.values())) {
                String oid = var.getVariableBinding().getOid().toString();
                if (!oid.startsWith("1.3.6.1.2.1.4.20.1.3")) continue;
                String ip = oid.substring("1.3.6.1.2.1.4.20.1.3".length() + 1);
                ipAddressMap.put(IPUtils.ipStringToLong(ip), IPUtils.ipStringToLong(var.getVariableBinding().getVariable().toString()));
            }
            if (ipAddressMap.isEmpty()) {
                responseMap = this.getOidTableVariables(session, "1.3.6.1.2.1.4.34.1.5");
                for (OIDParameterVariable var : new ArrayList<OIDParameterVariable>(responseMap.values())) {
                    byte[] oid;
                    String strOid = var.getVariableBinding().getOid().toString();
                    if (!strOid.startsWith("1.3.6.1.2.1.4.34.1.5") || (oid = var.getVariableBinding().getOid().toByteArray()).length <= 12 || oid[10] != 1 || oid[11] != 4) continue;
                    ipaddr = Arrays.copyOfRange(oid, 12, 16);
                    InetAddress addr = InetAddress.getByAddress((byte[])ipaddr);
                    String ip = addr.getHostAddress();
                    tmp = var.getVariableBinding().getVariable().toString();
                    String prefixLengthStr = tmp.substring(tmp.lastIndexOf(".") + 1);
                    int prefixLength = Integer.parseInt(prefixLengthStr);
                    int shifts = 32 - prefixLength;
                    long mask = 0xFFFFFFFFL << shifts;
                    ipAddressMap.put(IPUtils.ipStringToLong(ip), mask);
                }
            }
            if (ipAddressMap.isEmpty()) {
                Iterator<OIDParameterVariable> iterator = null;
                return iterator;
            }
            long modemIp = IPUtils.ipStringToLong(ipAddress);
            long cmtsIp = -1L;
            for (Long ip : ipAddressMap.keySet()) {
                long mask = (Long)ipAddressMap.get(ip);
                long ipStart = ip & mask;
                long ipEnd = ip | (mask ^= 0xFFFFFFFFL);
                if (modemIp <= ipStart || modemIp >= ipEnd) continue;
                cmtsIp = ip;
            }
            if (cmtsIp == -1L) {
                ipaddr = null;
                return ipaddr;
            }
            String oid = "1.3.6.1.2.1.4.20.1.2." + IPUtils.ipLongToString(cmtsIp);
            responseMap = this.getOidVariables(session, -96, oid);
            OIDParameterVariable var = responseMap.get(oid);
            if (var.getVariableBinding().getSyntax() != 2) {
                oid = "1.3.6.1.2.1.4.34.1.3.1.4." + IPUtils.ipLongToString(cmtsIp);
                responseMap = this.getOidVariables(session, -96, oid);
                var = responseMap.get(oid);
            }
            if (var.getVariableBinding().getSyntax() != 2) {
                Integer mask = null;
                return mask;
            }
            int ifIndex = var.getVariableBinding().getVariable().toInt();
            oid = "1.3.6.1.2.1.3.1.1.2." + ifIndex + ".1." + ipAddress;
            responseMap = this.getOidVariables(session, -96, oid);
            var = responseMap.get(oid);
            if (var.getVariableBinding().getSyntax() != 4) {
                oid = "1.3.6.1.2.1.4.35.1.4." + ifIndex + ".1.4." + ipAddress;
                responseMap = this.getOidVariables(session, -96, oid);
                var = responseMap.get(oid);
            }
            if (var.getVariableBinding().getSyntax() != 4) {
                tmp = null;
                return tmp;
            }
            String modemMac = ((OctetString)var.getVariableBinding().getVariable()).toHexString();
            Integer n = this.findModemIndexByMac(modemMac);
            return n;
        }
        catch (Exception ex) {
            this.closeSession(session, true);
            throw ex;
        }
        finally {
            this.closeSession(session);
        }
    }

    Integer findModemIndexByMac(String mac) throws Exception {
        Snmp session = this.getSnmpSession();
        try {
            OIDParameterVariable var;
            String modemIndexOid = this.getMacIndexOid(mac);
            Map<String, OIDParameterVariable> result = this.getOidVariables(session, -96, modemIndexOid);
            if (result.containsKey(modemIndexOid) && (var = result.get(modemIndexOid)).getVariableBinding().getSyntax() != 129) {
                Integer n = var.getVariableBinding().getVariable().toInt();
                return n;
            }
        }
        catch (Exception ex) {
            this.closeSession(session, true);
            throw ex;
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    private String getMacIndexOid(String mac) throws InvalidMacAddress {
        int[] macByte = InternetUtils.macStringToByte(mac);
        StringBuilder modemIndexOid = new StringBuilder("1.3.6.1.2.1.10.127.1.3.7.1.2");
        for (int aMacByte : macByte) {
            modemIndexOid.append(".").append(aMacByte);
        }
        return modemIndexOid.toString();
    }
}

