/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices.modem;

import com.dsoft.powerpro.cablemodem.mserver.CMTSModemInfo;
import com.dsoft.powerpro.cablemodem.mserver.CMTSMonitorInfo;
import com.dsoft.powerpro.cablemodem.mserver.ChannelMonitoringInfo;
import com.dsoft.powerpro.cablemodem.mserver.CmStatus;
import com.dsoft.powerpro.cablemodem.mserver.DOCSIS;
import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.devices.modem.CMMonitoringThread;
import com.dsoft.powerpro.monitorserver.devices.modem.ModemStatus;
import com.dsoft.powerpro.monitorserver.dto.DeviceDTO;
import com.dsoft.powerpro.monitorserver.snmp.SNMPBaseMonitor;
import com.dsoft.powerpro.monitorserver.snmp.SnmpPoolManager;
import com.dsoft.powerpro.monitorserver.snmp.SnmpResponseException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.snmp4j.Snmp;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class CMTSMonitor
extends SNMPBaseMonitor {
    private static final Logger LOGGER = Logger.getLogger(CMTSMonitor.class.getName());
    private static final String activeModemsOid = "1.3.6.1.2.1.10.127.1.3.3.1.0";
    private static final String[] statusIndexes = new String[]{"2", "3", "4", "5", "6", "9", "11", "12", "13", "14", "16", "17"};
    private static final String[] docsis3StatusIndexes = new String[]{"3", "4", "5", "7", "8", "9"};
    private static final int[] supportedIntfTypes = new int[]{6, 117, 127, 128, 129, 160, 205};
    private int monitorIteration;
    private SnmpPoolManager snmpPoolManager;

    public CMTSMonitor() {
    }

    public int getMonitorIteration() {
        return this.monitorIteration;
    }

    public CMTSMonitor(DeviceOIDParameterPacket packet, int monitorIteration, SnmpPoolManager snmpPoolManager) {
        super(packet);
        this.monitorIteration = monitorIteration;
        this.snmpPoolManager = snmpPoolManager;
    }

    public CMTSMonitor(int timeout, int retry) {
        super(timeout, retry);
    }

    public CMTSMonitorInfo readMonitoringValues() {
        LOGGER.fine(String.format("Reading SNMP values for CMTS IP %1$s", this.address.toString()));
        try {
            MonitoringManager.getInstance().incrementMonitorIteration(this.packet.getDeviceId(), this.monitorIteration);
            return this.getOidValues();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    public CMTSMonitorInfo getOidValues() throws Exception {
        LOGGER.fine(String.format("Reading SNMP values for CMTS IP %1$s", this.address.toString()));
        CMTSMonitorInfo monitorInfo = new CMTSMonitorInfo((String)null);
        Snmp snmpSession = this.getSnmpSession();
        try {
            this.monitPdu.clear();
            Map<String, VariableBinding> upstreamSnrMap = this.readCMTSUpstreamSNR(snmpSession, monitorInfo);
            Map<Integer, ModemStatus> modemStatusMap = this.readModemsDataFromCMTS(snmpSession, upstreamSnrMap);
            if (modemStatusMap == null) {
                CMTSMonitorInfo cMTSMonitorInfo = monitorInfo;
                return cMTSMonitorInfo;
            }
            Map<Integer, Integer> activeModemsMap = this.postProcessData(modemStatusMap);
            monitorInfo.getModemInfoList().addAll(modemStatusMap.values().stream().map(ms -> CMTSModemInfo.builder().mac(ms.getMac()).ip(ms.getIp()).upstreamIndex(ms.getPrimaryUpstreamIndex()).downstreamIndex(ms.getPrimaryDownstreamIndex()).status(ms.getStatus()).build()).collect(Collectors.toList()));
            List modemsToProcess = modemStatusMap.values().stream().filter(modemStatus -> modemStatus.getMac() != null).filter(modemStatus -> modemStatus.getIp() != null && !modemStatus.getIp().equals("0.0.0.0")).filter(modemStatus -> modemStatus.status == CmStatus.registrationComplete).collect(Collectors.toList());
            int activeModems = modemsToProcess.size();
            if (activeModemsMap != null) {
                for (Integer intfIndex : activeModemsMap.keySet()) {
                    int interfaceModems = activeModemsMap.get(intfIndex);
                    if (intfIndex > 0) {
                        monitorInfo.getUpstreamActivityMap().put(intfIndex, interfaceModems);
                        continue;
                    }
                    intfIndex = intfIndex * -1;
                    monitorInfo.getDownstreamActivityMap().put(intfIndex, interfaceModems);
                }
                LOGGER.fine(String.format("Read interface IO data for CMTS IP %1$s", this.address.toString()));
                ArrayList<OIDParameterVariable> oidList = new ArrayList<OIDParameterVariable>();
                Map<Integer, Integer> interfaceTypes = this.readInterfaceIOStats(snmpSession, oidList, supportedIntfTypes);
                monitorInfo.getOidParameters().putAll(oidList.stream().collect(Collectors.toMap(v -> v.getVariableBinding().getOid().toString(), v -> v)));
                for (Integer index : interfaceTypes.keySet()) {
                    switch (interfaceTypes.get(index)) {
                        case 128: {
                            index = index * -1;
                        }
                        case 129: 
                        case 205: {
                            if (activeModemsMap.containsKey(index)) break;
                            if (index < 0) {
                                index = index * -1;
                                monitorInfo.getDownstreamActivityMap().put(index, 0);
                                break;
                            }
                            monitorInfo.getUpstreamActivityMap().put(index, 0);
                            break;
                        }
                    }
                }
            }
            monitorInfo.setActiveModems(activeModems);
        }
        catch (Exception ex) {
            this.closeSession(snmpSession, true);
            throw ex;
        }
        finally {
            this.closeSession(snmpSession);
        }
        return monitorInfo;
    }

    private void docsis2ModemInfoFunction(Map<String, VariableBinding> upstreamSnrMap, Map<Integer, ModemStatus> modemStatusMap, String currentOid, VariableBinding variable, int index, Map<Integer, ChannelMonitoringInfo> downstreamMap, Map<Integer, ChannelMonitoringInfo> upstreamMap) {
        Integer modemIndex = Integer.parseInt(currentOid.substring(currentOid.lastIndexOf(".") + 1, currentOid.length()));
        ModemStatus modemStatus = modemStatusMap.computeIfAbsent(modemIndex, k -> index == 0 ? new ModemStatus() : null);
        if (modemStatus == null) {
            return;
        }
        Variable v = variable.getVariable();
        block1 : switch (index) {
            case 0: {
                modemStatus.setMac(((OctetString)v).toHexString());
                break;
            }
            case 1: {
                modemStatus.setIp(v.toString());
                break;
            }
            case 2: {
                modemStatus.downstreamIfIndex.add(v.toInt());
                modemStatus.primaryDownstreamIndex = v.toInt();
                modemStatus.cmtsDownstreamInfoMap.computeIfAbsent(modemStatus.getPrimaryDownstreamIndex(), k -> new ChannelMonitoringInfo((ChannelMonitoringInfo)downstreamMap.get(modemStatus.getPrimaryDownstreamIndex())));
                break;
            }
            case 3: {
                modemStatus.primaryUpstreamIndex = v.toInt();
                modemStatus.upstreamIfIndex.add(v.toInt());
                break;
            }
            case 5: {
                Integer modemId;
                modemStatus.status = CmStatus.values()[v.toInt()];
                if (modemStatus.status != CmStatus.registrationComplete || modemStatus.getMac() == null || modemStatus.getIp() == null || modemStatus.getIp().equals("0.0.0.0") || this.snmpPoolManager == null) break;
                DeviceDTO devDto = null;
                try {
                    devDto = MonitoringManager.getInstance().getDeviceByMacAddress(modemStatus.getMac().toUpperCase());
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
                Integer n = modemId = devDto != null ? devDto.getId() : null;
                if (modemId == null) break;
                this.changeCMMonitorThreadState(modemId, modemStatus.getIp(), this.monitorIteration, modemStatus);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (modemStatus.getPrimaryUpstreamIndex() == -1) break;
                ChannelMonitoringInfo monInfo = modemStatus.cmtsUpstreamInfoMap.computeIfAbsent(modemStatus.getPrimaryUpstreamIndex(), k -> new ChannelMonitoringInfo((ChannelMonitoringInfo)upstreamMap.get(modemStatus.getPrimaryUpstreamIndex())));
                switch (index) {
                    case 4: {
                        monInfo.setPowerLevel(v.toInt());
                        break block1;
                    }
                    case 6: {
                        monInfo.setCorrect(v.toLong());
                        break block1;
                    }
                    case 7: 
                    case 10: {
                        monInfo.setCorrected(v.toLong());
                        break block1;
                    }
                    case 8: {
                        if (v.toInt() == 0) {
                            VariableBinding var = upstreamSnrMap.get("" + modemStatus.getPrimaryUpstreamIndex());
                            monInfo.setSnr(var.getVariable().toInt());
                            break block1;
                        }
                        monInfo.setSnr(v.toInt());
                        break block1;
                    }
                    case 9: {
                        monInfo.setMicroReflections(v.toLong());
                        break block1;
                    }
                    case 11: {
                        monInfo.setUncorrected(v.toLong());
                    }
                }
            }
        }
    }

    private Map<String, VariableBinding> readCMTSUpstreamSNR(Snmp snmpSession, CMTSMonitorInfo monitorInfo) throws Exception {
        HashMap<String, VariableBinding> upstreamSnrMap = new HashMap<String, VariableBinding>();
        Map<String, OIDParameterVariable> response = this.getOidTableVariables(snmpSession, "1.3.6.1.2.1.10.127.1.1.4.1.5");
        for (OIDParameterVariable var : response.values()) {
            VariableBinding variable = var.getVariableBinding();
            String oid = variable.getOid().toString();
            String upstreamIfIndex = oid.substring(oid.lastIndexOf(".") + 1);
            upstreamSnrMap.put(upstreamIfIndex, variable);
        }
        monitorInfo.setOidParameters(response);
        return upstreamSnrMap;
    }

    private Map<Integer, Integer> postProcessData(Map<Integer, ModemStatus> modemStatusMap) throws Exception {
        LOGGER.fine(String.format("Post process data from CMTS IP %1$s", this.address.toString()));
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        List modemsToProcess = modemStatusMap.values().stream().filter(modemStatus -> modemStatus.getMac() != null).filter(modemStatus -> modemStatus.getIp() != null && !modemStatus.getIp().equals("0.0.0.0")).filter(modemStatus -> modemStatus.status == CmStatus.registrationComplete).collect(Collectors.toList());
        for (ModemStatus modemStatus2 : modemsToProcess) {
            for (int index : modemStatus2.upstreamIfIndex) {
                this.countActiveModem(result, index);
            }
            for (int index : modemStatus2.downstreamIfIndex) {
                this.countActiveModem(result, index * -1);
            }
            modemStatus2.complete();
        }
        return result;
    }

    public void changeCMMonitorThreadState(Integer deviceId, String ipAddress, Integer monitorIteration, ModemStatus modemStatus) {
        try {
            DeviceOIDParameterPacket packet = this.snmpPoolManager.constructDeviceOIDParameterPacket(deviceId, null, null);
            if (packet == null) {
                return;
            }
            LOGGER.fine(String.format("Starting Modem monitoring thread for IP %1$s", ipAddress));
            packet.setIpAddress(ipAddress);
            CMMonitoringThread thread = new CMMonitoringThread(packet, monitorIteration, modemStatus);
            this.snmpPoolManager.registerThread(thread, false);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void countActiveModem(Map<Integer, Integer> result, Integer index) {
        result.merge(index, 1, (a, b) -> a + b);
    }

    private boolean readOidData(Snmp snmpSession, String rootOid, String[] statusIndexes, ProcessValue processValue) throws Exception {
        int index = 0;
        while (index < statusIndexes.length) {
            String currentOid = rootOid + "." + statusIndexes[index];
            int finalIndex = index++;
            if (!this.getOidTableVariables(snmpSession, (OIDParameterVariable oid) -> processValue.processValue(oid.getVariableBinding().getOid().toString(), oid.getVariableBinding(), finalIndex), currentOid)) break;
        }
        return false;
    }

    private Map<Integer, ChannelMonitoringInfo> extractChannelInformation(Map<String, OIDParameterVariable> channelResponse, String frequencyOid, String widthOid) {
        Map<Integer, ChannelMonitoringInfo> responseMap = channelResponse.keySet().stream().filter(o -> o.startsWith(frequencyOid)).map(channelResponse::get).map(OIDParameterVariable::getVariableBinding).collect(Collectors.toMap(o -> o.getOid().last(), o -> new ChannelMonitoringInfo(o.getOid().last(), o.getVariable().toInt())));
        channelResponse.keySet().stream().filter(o -> o.startsWith(widthOid)).map(channelResponse::get).map(OIDParameterVariable::getVariableBinding).forEach(o -> ((ChannelMonitoringInfo)responseMap.get(o.getOid().last())).setWidth(o.getVariable().toInt()));
        return responseMap;
    }

    private Map<Integer, ModemStatus> readModemsDataFromCMTS(Snmp snmpSession, Map<String, VariableBinding> upstreamSnrMap) throws Exception {
        LOGGER.fine(String.format("Reading DOCSIS 2 data from CMTS IP %1$s", this.address.toString()));
        Map<String, OIDParameterVariable> channelResponse = this.getOidTableVariables(snmpSession, "1.3.6.1.2.1.10.127.1.1.1.1.2", "1.3.6.1.2.1.10.127.1.1.1.1.3", "1.3.6.1.2.1.10.127.1.1.2.1.2", "1.3.6.1.2.1.10.127.1.1.2.1.3");
        Map<Integer, ChannelMonitoringInfo> downstreamMap = this.extractChannelInformation(channelResponse, "1.3.6.1.2.1.10.127.1.1.1.1.2", "1.3.6.1.2.1.10.127.1.1.1.1.3");
        Map<Integer, ChannelMonitoringInfo> upstreamMap = this.extractChannelInformation(channelResponse, "1.3.6.1.2.1.10.127.1.1.2.1.2", "1.3.6.1.2.1.10.127.1.1.2.1.3");
        HashMap<Integer, ModemStatus> modemMap = new HashMap<Integer, ModemStatus>();
        boolean exit = this.readOidData(snmpSession, "1.3.6.1.2.1.10.127.1.3.3.1", statusIndexes, (oid, variable, index) -> this.docsis2ModemInfoFunction(upstreamSnrMap, modemMap, oid, variable, index, downstreamMap, upstreamMap));
        if (exit) {
            return null;
        }
        Map<String, OIDParameterVariable> response = this.getOidVariables(snmpSession, -95, "1.3.6.1.4.1.4491.2.1.20.1.3.1.2");
        if (response.isEmpty()) {
            return modemMap;
        }
        LOGGER.fine(String.format("Reading DOCSIS 3 data from CMTS IP %1$s", this.address.toString()));
        HashMap downstreamInterfaceMap = new HashMap();
        this.getOidTableVariables(snmpSession, (OIDParameterVariable oid) -> this.processDocsis3Oid((OIDParameterVariable)oid, downstreamInterfaceMap, (Map<Integer, ModemStatus>)modemMap, downstreamMap), "1.3.6.1.4.1.4491.2.1.20.1.3.1.11", "1.3.6.1.4.1.4491.2.1.20.1.3.1.12", "1.3.6.1.4.1.4491.2.1.20.1.3.1.7", "1.3.6.1.4.1.4491.2.1.20.1.5.1.3");
        response = this.getOidTableVariables(snmpSession, "1.3.6.1.4.1.4491.2.1.20.1.23.1.2");
        for (Integer modemIndex : modemMap.keySet()) {
            List idxList;
            String key;
            ModemStatus modemStatus = (ModemStatus)modemMap.get(modemIndex);
            if (modemStatus == null || modemStatus.rcsId < 256 && modemStatus.tcsId < 256) continue;
            modemStatus.setDocsis(DOCSIS.DOCSIS3_0);
            if (modemStatus.rcsId < 256 || !response.containsKey(key = "1.3.6.1.4.1.4491.2.1.20.1.23.1.2." + modemStatus.macDomain + "." + modemStatus.rcsId) || response.get(key).getVariableBinding().getVariable().getSyntax() != 4) continue;
            byte[] downstreamIndexes = ((OctetString)response.get(key).getVariableBinding().getVariable()).getValue();
            Map intfMap = (Map)downstreamInterfaceMap.get(modemStatus.macDomain);
            try {
                idxList = IntStream.range(0, downstreamIndexes.length).map(i -> downstreamIndexes[i] & 0xFF).filter(intfMap::containsKey).map(intfMap::get).boxed().collect(Collectors.toList());
            }
            catch (Exception e) {
                System.out.println(modemIndex + "-" + response.get(key).getVariableBinding().getVariable().toString());
                throw e;
            }
            modemStatus.downstreamIfIndex.addAll(idxList);
            for (Integer idx : idxList) {
                if (modemStatus.cmtsDownstreamInfoMap.containsKey(idx)) continue;
                modemStatus.cmtsDownstreamInfoMap.put(idx, new ChannelMonitoringInfo(downstreamMap.get(idx)));
            }
        }
        exit = this.readOidData(snmpSession, "1.3.6.1.4.1.4491.2.1.20.1.4.1", docsis3StatusIndexes, (oid, variable, index) -> this.docsis3UpstreamFunction(modemMap, oid, variable, index, upstreamMap));
        if (exit) {
            return null;
        }
        return modemMap;
    }

    private ModemStatus getModemStatus(Map<Integer, ModemStatus> modemMap, String oid) {
        Integer modemIndex = Integer.parseInt(oid.substring(oid.lastIndexOf(".") + 1));
        return modemMap.computeIfAbsent(modemIndex, k -> new ModemStatus());
    }

    private void processDocsis3Oid(OIDParameterVariable oid, Map<Integer, Map<Integer, Integer>> downstreamInterfaceMap, Map<Integer, ModemStatus> modemMap, Map<Integer, ChannelMonitoringInfo> downstreamMap) {
        OID oid1;
        int intfIndex;
        ModemStatus modemStatus;
        String oidStr = oid.getVariableBinding().getOid().toString();
        if (oidStr.startsWith("1.3.6.1.4.1.4491.2.1.20.1.3.1.7")) {
            modemStatus = this.getModemStatus(modemMap, oidStr);
            modemStatus.macDomain = oid.getVariableBinding().getVariable().toInt();
        }
        if (oidStr.startsWith("1.3.6.1.4.1.4491.2.1.20.1.3.1.11")) {
            modemStatus = this.getModemStatus(modemMap, oidStr);
            modemStatus.rcsId = oid.getVariableBinding().getVariable().toInt();
        }
        if (oidStr.startsWith("1.3.6.1.4.1.4491.2.1.20.1.3.1.12")) {
            modemStatus = this.getModemStatus(modemMap, oidStr);
            modemStatus.tcsId = oid.getVariableBinding().getVariable().toInt();
        }
        if (oidStr.startsWith("1.3.6.1.4.1.4491.2.1.20.1.5.1.3") && downstreamMap.containsKey(intfIndex = (oid1 = oid.getVariableBinding().getOid()).last())) {
            int macDomain = oid1.get(oid1.size() - 2);
            Map macDomainMap = downstreamInterfaceMap.computeIfAbsent(macDomain, k -> new HashMap());
            macDomainMap.put(oid.getVariableBinding().getVariable().toInt(), intfIndex);
        }
    }

    private void docsis3UpstreamFunction(Map<Integer, ModemStatus> modemMap, String oid, VariableBinding variable, int index, Map<Integer, ChannelMonitoringInfo> upstreamMap) {
        String upstreamIf = oid.substring(oid.lastIndexOf(".") + 1);
        Integer modemIndex = Integer.parseInt((oid = oid.substring(0, oid.lastIndexOf("."))).substring(oid.lastIndexOf(".") + 1));
        ModemStatus modemStatus = modemMap.computeIfAbsent(modemIndex, k -> null);
        if (modemStatus == null || modemStatus.getDocsis() != DOCSIS.DOCSIS3_0) {
            return;
        }
        int upstreamIntfIndex = Integer.parseInt(upstreamIf);
        ChannelMonitoringInfo monInfo = modemStatus.cmtsUpstreamInfoMap.computeIfAbsent(upstreamIntfIndex, k -> new ChannelMonitoringInfo((ChannelMonitoringInfo)upstreamMap.get(upstreamIntfIndex)));
        Variable v = variable.getVariable();
        switch (index) {
            case 0: {
                modemStatus.upstreamIfIndex.add(upstreamIntfIndex);
                monInfo.setIndex(upstreamIntfIndex);
                monInfo.setPowerLevel(v.toInt());
                break;
            }
            case 1: {
                monInfo.setSnr(v.toInt());
                break;
            }
            case 2: {
                monInfo.setMicroReflections(v.toLong());
                break;
            }
            case 3: {
                monInfo.setCorrect(v.toLong());
                break;
            }
            case 4: {
                monInfo.setCorrected(v.toLong());
                break;
            }
            case 5: {
                monInfo.setUncorrected(v.toLong());
            }
        }
    }

    @Override
    public boolean isDeviceLive(String address, Object monitor, Object object) throws SnmpResponseException {
        return true;
    }

    public void monitorDeviceParameters() throws UnknownHostException, InterruptedException {
    }

    public SnmpPoolManager getSnmpPoolManager() {
        return this.snmpPoolManager;
    }

    public void setSnmpPoolManager(SnmpPoolManager snmpPoolManager) {
        this.snmpPoolManager = snmpPoolManager;
    }

    static interface ProcessValue {
        public void processValue(String var1, VariableBinding var2, int var3);
    }
}

