/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices.modem;

import com.dsoft.powerpro.cablemodem.mserver.CMTSMonitorInfo;
import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceRequestPacket;
import com.dsoft.powerpro.monitorserver.devices.modem.CMTSMonitor;
import com.dsoft.powerpro.monitorserver.snmp.BaseMonitoringThread;
import com.dsoft.powerpro.monitorserver.snmp.SnmpPoolManager;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class CMTSMonitoringThread
extends BaseMonitoringThread {
    private static final Logger LOGGER = Logger.getLogger(CMTSMonitoringThread.class.getName());
    private CMTSMonitor cmtsMonitor;

    public CMTSMonitoringThread(DeviceOIDParameterPacket packet, long timeout, int monitorIteration, SnmpPoolManager snmpPoolManager) throws NamingException {
        super(packet, timeout);
        this.cmtsMonitor = new CMTSMonitor((DeviceOIDParameterPacket)this.getPacket(), monitorIteration, snmpPoolManager);
    }

    public static String constructThreadId(DeviceOIDParameterPacket packet) {
        String id = "CMTS:" + packet.getDeviceId() + ":";
        if (packet.getQueueId() != null) {
            id = id + packet.getQueueId();
        }
        return id;
    }

    @Override
    protected String getIdString() {
        return CMTSMonitoringThread.constructThreadId((DeviceOIDParameterPacket)this.getPacket());
    }

    @Override
    public void run() {
        long originalTimeOut = this.getTimeout();
        while (!this.isStopped()) {
            try {
                CMTSMonitorInfo monitorInfo;
                boolean skipThisRound = this.checkMessageQueue(originalTimeOut);
                long startTime = System.currentTimeMillis();
                if (!skipThisRound && (monitorInfo = this.cmtsMonitor.readMonitoringValues()) != null) {
                    this.fillPacketAndSend(((DeviceRequestPacket)this.getPacket()).getDeviceId(), null, new ArrayList<OIDParameterVariable>(), this.cmtsMonitor.getMonitorIteration(), monitorInfo);
                }
                try {
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    if (elapsedTime >= this.getTimeout()) continue;
                    Thread.sleep(this.getTimeout() - elapsedTime);
                }
                catch (InterruptedException ex) {
                    this.stopThread();
                    return;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, ex.getMessage() + "\n" + ((DeviceRequestPacket)this.getPacket()).getIpAddress(), ex);
            }
        }
    }

    public void setSnmpPoolManager(SnmpPoolManager snmpPoolManager) {
        this.cmtsMonitor.setSnmpPoolManager(snmpPoolManager);
    }
}

