/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices.modem;

import com.dsoft.powerpro.internet.mserver.InfoPacket;
import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceRequestPacket;
import com.dsoft.powerpro.monitorserver.devices.modem.CMDeviceMonitoring;
import com.dsoft.powerpro.monitorserver.devices.modem.CMTSFindIndexByMacThread;
import com.dsoft.powerpro.monitorserver.snmp.PoolTaskThread;
import com.dsoft.powerpro.monitorserver.snmp.SNMPBaseMonitor;
import com.dsoft.powerpro.monitorserver.snmp.SnmpPoolManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class CMTSReadOidThread
extends PoolTaskThread<DeviceRequestPacket> {
    private final Map<String, List<OIDParameterVariable>> responseMap;
    private SnmpPoolManager snmpPoolManager;
    private String[] oidToRead;
    private DeviceOIDParameterPacket cmtsPacket;

    CMTSReadOidThread(DeviceRequestPacket packet, Map<String, List<OIDParameterVariable>> responseMap, SnmpPoolManager snmpPoolManager, DeviceOIDParameterPacket cmtsPacket, String ... oidToRead) {
        super(packet, 0L);
        this.oidToRead = oidToRead;
        this.responseMap = responseMap;
        this.snmpPoolManager = snmpPoolManager;
        this.cmtsPacket = cmtsPacket;
    }

    @Override
    protected String getIdString() {
        return CMTSFindIndexByMacThread.class.getName() + ((DeviceRequestPacket)this.getPacket()).getIpAddress();
    }

    @Override
    public void run() {
        try {
            DeviceOIDParameterPacket packet = this.snmpPoolManager != null ? this.snmpPoolManager.constructDeviceOIDParameterPacket(((DeviceRequestPacket)this.getPacket()).getDeviceId(), null, ((InfoPacket)this.getPacket()).getMarker()) : new DeviceOIDParameterPacket(this.cmtsPacket);
            if (packet == null) {
                return;
            }
            packet.setIpAddress(((DeviceRequestPacket)this.getPacket()).getIpAddress());
            SNMPBaseMonitor monitor = new SNMPBaseMonitor(packet);
            Map<String, OIDParameterVariable> result = monitor.readOidValues(this.oidToRead);
            if (result.isEmpty()) {
                this.responseMap.put(packet.getIpAddress(), null);
                return;
            }
            ArrayList<OIDParameterVariable> response = new ArrayList<OIDParameterVariable>();
            for (String key : result.keySet()) {
                response.add(result.get(key));
            }
            this.responseMap.put(packet.getIpAddress(), response);
        }
        catch (Exception ex) {
            CMDeviceMonitoring.LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

