/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices.modem;

import com.dsoft.framework.client.exception.InvalidMacAddress;
import com.dsoft.framework.client.util.IPUtils;
import com.dsoft.framework.util.client.StringUtil;
import com.dsoft.powerpro.cablemodem.mserver.ChannelInfo;
import com.dsoft.powerpro.cablemodem.mserver.CmStatus;
import com.dsoft.powerpro.cablemodem.mserver.DOCSIS;
import com.dsoft.powerpro.cablemodem.mserver.FindModemRequest;
import com.dsoft.powerpro.cablemodem.mserver.FindModemResponse;
import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceRequestPacket;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.devices.BaseDeviceMonitoring;
import com.dsoft.powerpro.monitorserver.devices.modem.CMTSFindIndexByIpThread;
import com.dsoft.powerpro.monitorserver.devices.modem.CMTSFindIndexByMacThread;
import com.dsoft.powerpro.monitorserver.devices.modem.CMTSInfo;
import com.dsoft.powerpro.monitorserver.devices.modem.CMTSReadOidThread;
import com.dsoft.powerpro.monitorserver.dto.DeviceDTO;
import com.dsoft.powerpro.monitorserver.snmp.SNMPBaseMonitor;
import com.dsoft.powerpro.monitorserver.snmp.SnmpPoolManager;
import com.dsoft.powerpro.monitorserver.snmp.devices.InterfaceStatusMonitor;
import com.dsoft.powerpro.monitorserver.syslog.ProcessPacketThread;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class FindModemMonitor {
    private static final Logger LOGGER = Logger.getLogger(FindModemMonitor.class.getName());
    private SnmpPoolManager snmpPoolManager;
    private ProcessPacketThread sysLogPacketProcessor;
    private MonitoringManager monitoringManager;
    private DeviceOIDParameterPacket cmtsPacket;
    private DeviceOIDParameterPacket cmPacket;

    public void setCmPacket(DeviceOIDParameterPacket cmPacket) {
        this.cmPacket = cmPacket;
    }

    public void setCmtsPacket(DeviceOIDParameterPacket cmtsPacket) {
        this.cmtsPacket = cmtsPacket;
    }

    public FindModemMonitor(SnmpPoolManager snmpPoolManager, ProcessPacketThread sysLogPacketProcessor, MonitoringManager monitoringManager) {
        this.snmpPoolManager = snmpPoolManager;
        this.sysLogPacketProcessor = sysLogPacketProcessor;
        this.monitoringManager = monitoringManager;
    }

    public FindModemResponse findModemOnAllCmts(FindModemRequest processPacket) {
        try {
            List<DeviceDTO> devices = this.monitoringManager.getDevicesByType("CmtsDto");
            return this.findModem(devices, processPacket.getIp(), processPacket.getMac(), processPacket.getMarker());
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FindModemResponse findModem(List<DeviceDTO> devices, String ip, String mac, String marker) throws Exception {
        Map<String, Integer> modemIndexMap;
        if (!StringUtil.isEmpty(mac)) {
            modemIndexMap = this.findDeviceByMac(mac, devices);
        } else {
            if (StringUtil.isEmpty(ip)) return new FindModemResponse(marker);
            modemIndexMap = this.findDeviceByIP(ip, devices);
        }
        FindModemResponse response = new FindModemResponse(marker);
        if (modemIndexMap == null || modemIndexMap.isEmpty()) {
            return response;
        }
        Map<String, Integer> ipMap = devices.stream().collect(Collectors.toMap(device -> IPUtils.ipLongToString(device.getIpAddress()), DeviceDTO::getId));
        if (modemIndexMap.size() > 1) {
            Serializable requestPacket;
            String cmtsSysUpTime = "1.3.6.1.2.1.1.3.0";
            String modemStatusValue = "1.3.6.1.2.1.10.127.1.3.3.1.9";
            String modemLastUpdateValue = "1.3.6.1.2.1.10.127.1.3.3.1.22";
            ConcurrentHashMap<String, List<OIDParameterVariable>> responseMap = new ConcurrentHashMap<String, List<OIDParameterVariable>>();
            for (String cmtsIp : modemIndexMap.keySet()) {
                Integer modemIndexInt = modemIndexMap.get(cmtsIp);
                requestPacket = new DeviceRequestPacket();
                ((DeviceRequestPacket)requestPacket).setDeviceId(ipMap.get(cmtsIp));
                ((DeviceRequestPacket)requestPacket).setIpAddress(cmtsIp);
                String[] oidToRead = new String[]{cmtsSysUpTime, modemStatusValue + "." + modemIndexInt, modemLastUpdateValue + "." + modemIndexInt};
                if (this.snmpPoolManager != null) {
                    this.snmpPoolManager.registerThread(new CMTSReadOidThread((DeviceRequestPacket)requestPacket, responseMap, this.snmpPoolManager, this.cmtsPacket, oidToRead), true);
                    continue;
                }
                new Thread(new CMTSReadOidThread((DeviceRequestPacket)requestPacket, responseMap, this.snmpPoolManager, this.cmtsPacket, oidToRead)).start();
            }
            HashMap<String, CMTSInfo> cmtsInfoMap = new HashMap<String, CMTSInfo>();
            long timeout = System.currentTimeMillis() + 30000L;
            requestPacket = responseMap;
            synchronized (requestPacket) {
                while (responseMap.size() < modemIndexMap.size() && System.currentTimeMillis() <= timeout) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ex) {
                        return new FindModemResponse(marker);
                    }
                }
                if (!responseMap.isEmpty()) {
                    for (String cmtsIp : responseMap.keySet()) {
                        for (OIDParameterVariable var : (List)responseMap.get(cmtsIp)) {
                            CMTSInfo cmtsInfo = cmtsInfoMap.computeIfAbsent(var.getResponderIp(), CMTSInfo::new);
                            VariableBinding varBind = var.getVariableBinding();
                            String oidStr = varBind.getOid().toString();
                            if (oidStr.equals(cmtsSysUpTime)) {
                                cmtsInfo.sysUpTime = varBind.getVariable().toLong();
                            }
                            if (oidStr.startsWith(modemStatusValue + ".") && varBind.getSyntax() < 128) {
                                cmtsInfo.modemStatus = varBind.getVariable().toInt();
                            }
                            if (!oidStr.startsWith(modemLastUpdateValue + ".") || varBind.getSyntax() >= 128) continue;
                            cmtsInfo.lastUpdate = varBind.getVariable().toLong();
                        }
                    }
                }
            }
            if (cmtsInfoMap.isEmpty()) {
                return new FindModemResponse(marker);
            }
            CMTSInfo currentCmtsInfo = null;
            for (CMTSInfo cmtsInfo : cmtsInfoMap.values()) {
                if (cmtsInfo.lastUpdate == null || cmtsInfo.sysUpTime == null) continue;
                if (cmtsInfo.modemStatus != null && cmtsInfo.modemStatus > 1) {
                    currentCmtsInfo = cmtsInfo;
                    break;
                }
                if (cmtsInfo.lastUpdate <= 0L) continue;
                if (currentCmtsInfo != null) {
                    long updateInterval = cmtsInfo.sysUpTime - cmtsInfo.lastUpdate;
                    long currentUpdateInterval = currentCmtsInfo.sysUpTime - currentCmtsInfo.lastUpdate;
                    if (currentUpdateInterval <= updateInterval) continue;
                    currentCmtsInfo = cmtsInfo;
                    continue;
                }
                currentCmtsInfo = cmtsInfo;
            }
            if (currentCmtsInfo == null) return new FindModemResponse(marker);
            response.setCmtsIp(currentCmtsInfo.ip);
            response.setModemIndex(modemIndexMap.get(currentCmtsInfo.ip));
            response.setCmtsDeviceId(ipMap.get(currentCmtsInfo.ip));
        } else {
            String cmtsIp = modemIndexMap.keySet().iterator().next();
            response.setCmtsIp(cmtsIp);
            response.setModemIndex(modemIndexMap.get(cmtsIp));
            response.setCmtsDeviceId(ipMap.get(cmtsIp));
        }
        response.setOidParameters(new HashMap<String, OIDParameterVariable>());
        try {
            this.readModemDataFromCMTS(response);
            if (!response.getModemIp().equals("0.0.0.0") && response.getModemStatus() == CmStatus.registrationComplete) {
                this.readModemDataFromModem(response);
            }
            this.postProcessResponse(response);
            return response;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, String.format("Error while reading data for cable mode %1$s(%2$s)", response.getModemIp(), ex.getMessage()), ex);
        }
        return response;
    }

    private Set<Integer> getInterfaceIndexSet(Map<String, OIDParameterVariable> parametersMap, String oidPrefix, String ip) {
        List oidList = parametersMap.keySet().stream().filter(k -> k.startsWith(oidPrefix)).map(parametersMap::get).filter(oid -> oid.getResponderIp().equals(ip)).collect(Collectors.toList());
        return oidList.stream().map(v -> v.getVariableBinding().getOid().toIntArray()).map(oid -> oid[((int[])oid).length - 1]).collect(Collectors.toSet());
    }

    private List<ChannelInfo> constructChannelInfo(byte[] indexes, Map<Integer, Integer> intfMap, FindModemResponse response, String freqPrefix, String widthPrefix) {
        ArrayList<ChannelInfo> result = new ArrayList<ChannelInfo>();
        List idxList = IntStream.range(0, indexes.length).map(i -> indexes[i] & 0xFF).filter(intfMap::containsKey).map(intfMap::get).boxed().collect(Collectors.toList());
        Map<String, OIDParameterVariable> oidMap = response.getOidParameters();
        for (Integer idx : idxList) {
            String name = BaseDeviceMonitoring.getString(oidMap, "1.3.6.1.2.1.2.2.1.2", idx);
            int frequency = BaseDeviceMonitoring.getInt(oidMap, freqPrefix, idx);
            int width = BaseDeviceMonitoring.getInt(oidMap, widthPrefix, idx);
            ChannelInfo channelInfo = ChannelInfo.builder().cmtsIndex(idx).name(name).frequency(frequency).width(width).build();
            result.add(channelInfo);
        }
        return result;
    }

    private void cleanupResponse(FindModemResponse response, String prefix, String ip) {
        Map<String, OIDParameterVariable> oidMap = response.getOidParameters();
        new ArrayList<String>(oidMap.keySet()).stream().filter(k -> k.startsWith(prefix)).filter(k -> ((OIDParameterVariable)oidMap.get(k)).getResponderIp().equals(ip)).forEach(oidMap::remove);
    }

    private void postProcessResponse(FindModemResponse response) {
        Map<String, OIDParameterVariable> oidMap = response.getOidParameters();
        int modemIndex = response.getModemIndex();
        String qosVersions = DocsisQosVersion.values()[BaseDeviceMonitoring.getInt(oidMap, (String)"1.3.6.1.2.1.10.127.1.3.3.1.18", (int[])new int[]{modemIndex})].text;
        response.setQosVersion(qosVersions);
        if (response.getDocsis().version >= DOCSIS.DOCSIS3_0.version) {
            long macDomain = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.4.1.4491.2.1.20.1.3.1.7", modemIndex);
            List macDomainIntfIndexList = oidMap.keySet().stream().filter(k -> k.startsWith("1.3.6.1.4.1.4491.2.1.20.1.5.1.3." + macDomain)).map(oidMap::get).collect(Collectors.toList());
            HashMap<Integer, Integer> upstreamMap = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> downstreamMap = new HashMap<Integer, Integer>();
            Set<Integer> downStreamIndexSet = this.getInterfaceIndexSet(oidMap, "1.3.6.1.2.1.10.127.1.1.1.1.2", response.getCmtsIp());
            for (OIDParameterVariable var : macDomainIntfIndexList) {
                int idx = var.getVariableBinding().getVariable().toInt();
                int intfIndex = var.getVariableBinding().getOid().last();
                if (downStreamIndexSet.contains(intfIndex)) {
                    downstreamMap.put(idx, intfIndex);
                    continue;
                }
                upstreamMap.put(idx, intfIndex);
            }
            int tcsId = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.4.1.4491.2.1.20.1.3.1.12", modemIndex);
            Variable upstreamChSetList = oidMap.get("1.3.6.1.4.1.4491.2.1.20.1.22.1.2." + macDomain + "." + tcsId).getVariableBinding().getVariable();
            byte[] upstreamIndexes = null;
            if (upstreamChSetList.getSyntax() == 4) {
                upstreamIndexes = ((OctetString)upstreamChSetList).getValue();
            }
            response.getUpstreamInterfaceInfo().addAll(this.constructChannelInfo(upstreamIndexes, upstreamMap, response, "1.3.6.1.2.1.10.127.1.1.2.1.2", "1.3.6.1.2.1.10.127.1.1.2.1.3"));
            int rcsId = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.4.1.4491.2.1.20.1.3.1.11", modemIndex);
            Variable downstreamChSetList = oidMap.get("1.3.6.1.4.1.4491.2.1.20.1.23.1.2." + macDomain + "." + rcsId).getVariableBinding().getVariable();
            byte[] downstreamIndexes = null;
            if (downstreamChSetList.getSyntax() == 4) {
                downstreamIndexes = ((OctetString)downstreamChSetList).getValue();
            }
            response.getDownstreamInterfaceInfo().addAll(this.constructChannelInfo(downstreamIndexes, downstreamMap, response, "1.3.6.1.2.1.10.127.1.1.1.1.2", "1.3.6.1.2.1.10.127.1.1.1.1.3"));
            for (ChannelInfo ci : response.getUpstreamInterfaceInfo()) {
                int power = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.4.1.4491.2.1.20.1.4.1.3", modemIndex, ci.getCmtsIndex());
                int snr = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.4.1.4491.2.1.20.1.4.1.4", modemIndex, ci.getCmtsIndex());
                long correct = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.4.1.4491.2.1.20.1.4.1.7", modemIndex, ci.getCmtsIndex());
                long corrected = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.4.1.4491.2.1.20.1.4.1.8", modemIndex, ci.getCmtsIndex());
                long uncirrected = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.4.1.4491.2.1.20.1.4.1.9", modemIndex, ci.getCmtsIndex());
                String modulation = UpstreamModulation.values()[BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.4.1.4491.2.1.20.1.4.1.2", modemIndex, ci.getCmtsIndex())].name();
                ci.setPowerLevel(power);
                ci.setCorrect(correct);
                ci.setCorrected(corrected);
                ci.setUncorrected(uncirrected);
                ci.setSnr(snr);
                ci.setModulation(modulation);
            }
            for (ChannelInfo ci : response.getDownstreamInterfaceInfo()) {
                int index = ci.getCmtsIndex();
                int txPower = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.1.1.1.6", index);
                String modulation = DownstreamModulation.values()[BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.1.1.1.4." + index)].name();
                ci.setTransmitLevel(txPower);
                ci.setModulation(modulation);
            }
            this.modemInterfaceIndex(oidMap, "1.3.6.1.2.1.10.127.1.1.1.1.2", response.getModemIp(), downstreamIndex -> {
                long freq = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.1.1.1.2", downstreamIndex);
                for (ChannelInfo downstream : response.getDownstreamInterfaceInfo()) {
                    if (freq != downstream.getFrequency()) continue;
                    downstream.setCmIndex((int)downstreamIndex);
                    int power1 = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.1.1.1.6", downstreamIndex);
                    downstream.setPowerLevel(power1);
                    int snr1 = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.1.4.1.5." + downstreamIndex);
                    downstream.setSnr(snr1);
                    long correct1 = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.1.4.1.2", downstreamIndex);
                    if (oidMap.containsKey("1.3.6.1.2.1.10.127.1.1.4.1.8." + downstreamIndex)) {
                        correct1 = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.1.4.1.8", downstreamIndex);
                    }
                    downstream.setCorrect(correct1);
                    long corrected1 = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.1.4.1.3", downstreamIndex);
                    if (oidMap.containsKey("1.3.6.1.2.1.10.127.1.1.4.1.9." + downstreamIndex)) {
                        corrected1 = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.1.4.1.9", downstreamIndex);
                    }
                    downstream.setCorrected(corrected1);
                    long uncorrected1 = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.1.4.1.4", downstreamIndex);
                    if (oidMap.containsKey("1.3.6.1.2.1.10.127.1.1.4.1.10." + downstreamIndex)) {
                        uncorrected1 = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.1.4.1.10", downstreamIndex);
                    }
                    downstream.setUncorrected(uncorrected1);
                }
            });
            this.modemInterfaceIndex(oidMap, "1.3.6.1.2.1.10.127.1.1.2.1.2", response.getModemIp(), upstreamIndex -> {
                long freq = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.1.2.1.2", upstreamIndex);
                for (ChannelInfo upstream : response.getUpstreamInterfaceInfo()) {
                    if (freq != upstream.getFrequency()) continue;
                    upstream.setCmIndex((int)upstreamIndex);
                    upstream.setTransmitLevel(BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.4.1.4491.2.1.20.1.2.1.1", upstreamIndex));
                }
            });
            this.cleanupResponse(response, "1.3.6.1.4.1.4491.2.1.20.1.23.1.2", response.getCmtsIp());
            this.cleanupResponse(response, "1.3.6.1.4.1.4491.2.1.20.1.22.1.2", response.getCmtsIp());
            this.cleanupResponse(response, "1.3.6.1.4.1.4491.2.1.20.1.5.1.3", response.getCmtsIp());
            this.cleanupResponse(response, "1.3.6.1.4.1.4491.2.1.20.1.2.1.1", response.getModemIp());
        } else {
            int index = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.3.3.1.4." + modemIndex);
            String name = BaseDeviceMonitoring.getString(oidMap, "1.3.6.1.2.1.2.2.1.2", index);
            String modulation = DownstreamModulation.values()[BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.1.1.1.4." + index)].name();
            int frequency = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.1.1.1.2." + index);
            int width = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.1.1.1.3." + index);
            int txPower = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.1.1.1.6." + index);
            ChannelInfo downstream = ChannelInfo.builder().cmtsIndex(index).name(name).frequency(frequency).width(width).transmitLevel(txPower).modulation(modulation).build();
            response.getDownstreamInterfaceInfo().add(downstream);
            index = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.3.3.1.5", modemIndex);
            name = BaseDeviceMonitoring.getString(oidMap, "1.3.6.1.2.1.2.2.1.2", index);
            frequency = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.1.2.1.2", index);
            width = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.1.2.1.3", index);
            int power = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.3.3.1.6", modemIndex);
            int snr = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.3.3.1.13", modemIndex);
            modulation = UpstreamModulation.values()[BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.1.2.1.15", index)].name();
            long correct = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.3.3.1.10", modemIndex);
            if (oidMap.containsKey("1.3.6.1.2.1.10.127.1.3.3.1.15." + modemIndex)) {
                correct = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.3.3.1.15", modemIndex);
            }
            long corrected = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.3.3.1.11", modemIndex);
            if (oidMap.containsKey("1.3.6.1.2.1.10.127.1.3.3.1.16." + modemIndex)) {
                corrected = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.3.3.1.16", modemIndex);
            }
            long uncorrected = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.3.3.1.12", modemIndex);
            if (oidMap.containsKey("1.3.6.1.2.1.10.127.1.3.3.1.17." + modemIndex)) {
                uncorrected = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.3.3.1.17", modemIndex);
            }
            ChannelInfo upstream = ChannelInfo.builder().cmtsIndex(index).name(name).frequency(frequency).width(width).powerLevel(power).snr(snr).correct(correct).corrected(corrected).uncorrected(uncorrected).modulation(modulation).build();
            response.getUpstreamInterfaceInfo().add(upstream);
            this.modemInterfaceIndex(oidMap, "1.3.6.1.2.1.10.127.1.1.1.1.2", response.getModemIp(), downstreamIndex -> {
                downstream.setCmIndex((int)downstreamIndex);
                long freq = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.1.1.1.2", downstreamIndex);
                if (freq == downstream.getFrequency()) {
                    int power1 = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.1.1.1.6", downstreamIndex);
                    downstream.setPowerLevel(power1);
                    int snr1 = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.2.1.10.127.1.1.4.1.5", downstreamIndex);
                    downstream.setSnr(snr1);
                    long correct1 = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.1.4.1.2", downstreamIndex);
                    if (oidMap.containsKey("1.3.6.1.2.1.10.127.1.1.4.1.8." + downstreamIndex)) {
                        correct1 = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.1.4.1.8", downstreamIndex);
                    }
                    downstream.setCorrect(correct1);
                    long corrected1 = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.1.4.1.3", downstreamIndex);
                    if (oidMap.containsKey("1.3.6.1.2.1.10.127.1.1.4.1.9." + downstreamIndex)) {
                        corrected1 = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.1.4.1.9", downstreamIndex);
                    }
                    downstream.setCorrected(corrected1);
                    long uncorrected1 = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.1.4.1.4", downstreamIndex);
                    if (oidMap.containsKey("1.3.6.1.2.1.10.127.1.1.4.1.10." + downstreamIndex)) {
                        uncorrected1 = BaseDeviceMonitoring.getLong(oidMap, "1.3.6.1.2.1.10.127.1.1.4.1.10", downstreamIndex);
                    }
                    downstream.setUncorrected(uncorrected1);
                }
            });
            this.modemInterfaceIndex(oidMap, "1.3.6.1.2.1.10.127.1.1.2.1.2", response.getModemIp(), upstream::setCmIndex);
            for (String key : oidMap.keySet()) {
                if (!key.startsWith("1.3.6.1.2.1.10.127.1.2.2.1.3")) continue;
                power = BaseDeviceMonitoring.getInt(oidMap, key);
                upstream.setTransmitLevel(power);
                break;
            }
        }
        for (String key : oidMap.keySet()) {
            if (!key.startsWith("1.3.6.1.2.1.17.4.3.1.1")) continue;
            int[] oid = oidMap.get(key).getVariableBinding().getOid().getValue();
            oid[10] = 3;
            OID statusOid = new OID(oid);
            int status = BaseDeviceMonitoring.getInt(oidMap, statusOid.toString());
            if (status != 3 && status != 5) continue;
            String mac = BaseDeviceMonitoring.getString(oidMap, key);
            response.getCpeMacList().add(mac);
        }
        this.cleanupResponse(response, "1.3.6.1.2.1.2.2.1.2", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.3.3.1.5", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.1.2.1.2", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.1.2.1.3", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.1.2.1.15", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.3.3.1.6", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.3.3.1.13", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.3.3.1.18", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.3.3.1.19", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.1.4.1.5", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.3.3.1.4", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.1.1.1.3", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.1.1.1.6", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.1.1.1.2", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.1.1.1.4", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.4.1.4491.2.1.20.1", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.3.3.1.10", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.3.3.1.11", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.3.3.1.12", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.3.3.1.15", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.3.3.1.16", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.3.3.1.17", response.getCmtsIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.1.1.1.2", response.getModemIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.1.1.1.6", response.getModemIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.1.1.1.3", response.getModemIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.1.1.1.4", response.getModemIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.1.2.1.2", response.getModemIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.1.4", response.getModemIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.10.127.1.2.2.1.3", response.getModemIp());
        this.cleanupResponse(response, "1.3.6.1.2.1.17.4.3.1", response.getModemIp());
    }

    private void modemInterfaceIndex(Map<String, OIDParameterVariable> oidMap, String keyPrefix, String ip, Consumer<Integer> interfaceConsumer) {
        for (String key : oidMap.keySet()) {
            if (!key.startsWith(keyPrefix) || !oidMap.get(key).getResponderIp().equals(ip)) continue;
            interfaceConsumer.accept(oidMap.get(key).getVariableBinding().getOid().last());
        }
    }

    private void readModemDataFromModem(FindModemResponse response) throws Exception {
        DeviceOIDParameterPacket packet;
        if (this.snmpPoolManager != null) {
            DeviceDTO modemDeviceDto = this.monitoringManager.getDeviceByMacAddress(response.getModemMac());
            if (modemDeviceDto == null) {
                return;
            }
            response.setDeviceId(modemDeviceDto.getId());
            packet = this.snmpPoolManager.constructDeviceOIDParameterPacket(modemDeviceDto.getId(), null, null);
        } else {
            packet = new DeviceOIDParameterPacket(this.cmPacket);
        }
        packet.setIpAddress(response.getModemIp());
        InterfaceStatusMonitor snmpMonitor = new InterfaceStatusMonitor(packet);
        response.setInterfaceStatusPacket(snmpMonitor.getInterfaceStatus());
        SNMPBaseMonitor monitor = new SNMPBaseMonitor(packet);
        Map<String, OIDParameterVariable> responseMap = monitor.readNextOidValues("1.3.6.1.2.1.1.1", "1.3.6.1.2.1.1.3");
        response.getOidParameters().putAll(responseMap);
        responseMap = monitor.getOidTables("1.3.6.1.2.1.10.127.1.1.1.1.2", "1.3.6.1.2.1.10.127.1.1.1.1.3", "1.3.6.1.2.1.10.127.1.1.1.1.4", "1.3.6.1.2.1.10.127.1.1.1.1.6", "1.3.6.1.2.1.10.127.1.2.2.1.3", "1.3.6.1.2.1.10.127.1.1.2.1.2", "1.3.6.1.2.1.10.127.1.1.4.1.2", "1.3.6.1.2.1.10.127.1.1.4.1.3", "1.3.6.1.2.1.10.127.1.1.4.1.4", "1.3.6.1.2.1.10.127.1.1.4.1.5", "1.3.6.1.2.1.10.127.1.1.4.1.8", "1.3.6.1.2.1.10.127.1.1.4.1.9", "1.3.6.1.2.1.10.127.1.1.4.1.10", "1.3.6.1.2.1.17.4.3.1");
        response.getOidParameters().putAll(responseMap);
        if (response.getDocsis().version >= DOCSIS.DOCSIS3_0.version) {
            responseMap = monitor.getOidTables("1.3.6.1.4.1.4491.2.1.20.1.2.1.1");
            response.getOidParameters().putAll(responseMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readModemDataFromCMTS(FindModemResponse response) throws Exception {
        String macDomainOid;
        HashSet<String> oidGetData = new HashSet<String>();
        HashSet<String> oidGetNextData = new HashSet<String>();
        HashSet<String> oidGetTable = new HashSet<String>();
        int modemIndexAtCMTS = response.getModemIndex();
        oidGetData.add("1.3.6.1.2.1.10.127.1.3.3.1.2." + modemIndexAtCMTS);
        oidGetData.add("1.3.6.1.2.1.10.127.1.3.3.1.3." + modemIndexAtCMTS);
        oidGetData.add("1.3.6.1.2.1.10.127.1.3.3.1.4." + modemIndexAtCMTS);
        oidGetData.add("1.3.6.1.2.1.10.127.1.3.3.1.5." + modemIndexAtCMTS);
        oidGetData.add("1.3.6.1.2.1.10.127.1.3.3.1.6." + modemIndexAtCMTS);
        oidGetData.add("1.3.6.1.2.1.10.127.1.3.3.1.9." + modemIndexAtCMTS);
        oidGetData.add("1.3.6.1.2.1.10.127.1.3.3.1.10." + modemIndexAtCMTS);
        oidGetData.add("1.3.6.1.2.1.10.127.1.3.3.1.11." + modemIndexAtCMTS);
        oidGetData.add("1.3.6.1.2.1.10.127.1.3.3.1.12." + modemIndexAtCMTS);
        oidGetData.add("1.3.6.1.2.1.10.127.1.3.3.1.13." + modemIndexAtCMTS);
        oidGetData.add("1.3.6.1.2.1.10.127.1.3.3.1.15." + modemIndexAtCMTS);
        oidGetData.add("1.3.6.1.2.1.10.127.1.3.3.1.16." + modemIndexAtCMTS);
        oidGetData.add("1.3.6.1.2.1.10.127.1.3.3.1.17." + modemIndexAtCMTS);
        oidGetData.add("1.3.6.1.2.1.10.127.1.3.3.1.18." + modemIndexAtCMTS);
        oidGetData.add("1.3.6.1.2.1.10.127.1.3.3.1.19." + modemIndexAtCMTS);
        oidGetData.add("1.3.6.1.4.1.4491.2.1.20.1.3.1.2." + modemIndexAtCMTS);
        DeviceRequestPacket requestPacket = new DeviceRequestPacket();
        requestPacket.setDeviceId(response.getDeviceId());
        requestPacket.setIpAddress(response.getCmtsIp());
        DeviceOIDParameterPacket packet = this.snmpPoolManager != null ? this.snmpPoolManager.constructDeviceOIDParameterPacket(response.getCmtsDeviceId(), null, null) : new DeviceOIDParameterPacket(this.cmtsPacket);
        packet.setIpAddress(response.getCmtsIp());
        SNMPBaseMonitor monitor = new SNMPBaseMonitor(packet);
        Map<String, OIDParameterVariable> responseMap = monitor.readOidValues(oidGetData.toArray(new String[0]));
        Map<String, OIDParameterVariable> oidMap = response.getOidParameters();
        FindModemResponse findModemResponse = response;
        synchronized (findModemResponse) {
            if (!responseMap.isEmpty()) {
                oidGetData.clear();
                for (OIDParameterVariable cmtsOid : responseMap.values()) {
                    VariableBinding varBind = cmtsOid.getVariableBinding();
                    if (varBind.getSyntax() >= 128) continue;
                    String oidStr = varBind.getOid().toString();
                    if (oidStr.startsWith("1.3.6.1.2.1.10.127.1.3.3.1.2.")) {
                        String modemMac = ((OctetString)varBind.getVariable()).toHexString();
                        response.setModemMac(modemMac);
                        continue;
                    }
                    if (oidStr.startsWith("1.3.6.1.2.1.10.127.1.3.3.1.3.")) {
                        response.setModemIp(varBind.getVariable().toString());
                        continue;
                    }
                    if (oidStr.startsWith("1.3.6.1.2.1.10.127.1.3.3.1.4.")) {
                        oidGetData.addAll(this.buildRequestOid(varBind, "1.3.6.1.2.1.2.2.1.2", "1.3.6.1.2.1.10.127.1.1.1.1.2", "1.3.6.1.2.1.10.127.1.1.1.1.4", "1.3.6.1.2.1.10.127.1.1.1.1.3", "1.3.6.1.2.1.10.127.1.1.1.1.6"));
                    }
                    if (oidStr.startsWith("1.3.6.1.2.1.10.127.1.3.3.1.5.")) {
                        oidGetData.addAll(this.buildRequestOid(varBind, "1.3.6.1.2.1.2.2.1.2", "1.3.6.1.2.1.10.127.1.1.2.1.2", "1.3.6.1.2.1.10.127.1.1.2.1.3", "1.3.6.1.2.1.10.127.1.1.2.1.15", "1.3.6.1.2.1.10.127.1.1.4.1.5"));
                    }
                    if (oidStr.startsWith("1.3.6.1.4.1.4491.2.1.20.1.3.1.2") && !varBind.isException()) {
                        response.setDocsis(DOCSIS.DOCSIS3_0);
                        oidGetTable.add("1.3.6.1.4.1.4491.2.1.20.1.4.1.2." + modemIndexAtCMTS);
                        oidGetTable.add("1.3.6.1.4.1.4491.2.1.20.1.4.1.3." + modemIndexAtCMTS);
                        oidGetTable.add("1.3.6.1.4.1.4491.2.1.20.1.4.1.4." + modemIndexAtCMTS);
                        oidGetTable.add("1.3.6.1.4.1.4491.2.1.20.1.4.1.7." + modemIndexAtCMTS);
                        oidGetTable.add("1.3.6.1.4.1.4491.2.1.20.1.4.1.8." + modemIndexAtCMTS);
                        oidGetTable.add("1.3.6.1.4.1.4491.2.1.20.1.4.1.9." + modemIndexAtCMTS);
                        oidGetData.add("1.3.6.1.4.1.4491.2.1.20.1.3.1.7." + modemIndexAtCMTS);
                        oidGetData.add("1.3.6.1.4.1.4491.2.1.20.1.3.1.11." + modemIndexAtCMTS);
                        oidGetData.add("1.3.6.1.4.1.4491.2.1.20.1.3.1.12." + modemIndexAtCMTS);
                        oidGetTable.add("1.3.6.1.2.1.10.127.1.1.2.1.2");
                        oidGetTable.add("1.3.6.1.2.1.10.127.1.1.2.1.3");
                        oidGetTable.add("1.3.6.1.2.1.10.127.1.1.1.1.3");
                        continue;
                    }
                    if (oidStr.startsWith("1.3.6.1.2.1.10.127.1.3.3.1.9.")) {
                        response.setModemStatus(CmStatus.values()[varBind.getVariable().toInt()]);
                        continue;
                    }
                    oidMap.put(oidStr, cmtsOid);
                }
            }
        }
        if (!oidGetNextData.isEmpty()) {
            responseMap = monitor.readNextOidValues(oidGetNextData);
            oidMap.putAll(responseMap);
        }
        if (!oidGetTable.isEmpty()) {
            responseMap = monitor.getOidTables(oidGetTable);
            oidMap.putAll(responseMap);
        }
        if (!oidGetData.isEmpty()) {
            responseMap = monitor.readOidValues(oidGetData);
            oidMap.putAll(responseMap);
        }
        if (oidMap.containsKey(macDomainOid = "1.3.6.1.4.1.4491.2.1.20.1.3.1.7." + modemIndexAtCMTS)) {
            int rcsId = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.4.1.4491.2.1.20.1.3.1.11." + modemIndexAtCMTS);
            int tcsId = BaseDeviceMonitoring.getInt(oidMap, "1.3.6.1.4.1.4491.2.1.20.1.3.1.12." + modemIndexAtCMTS);
            if (rcsId >= 256 || tcsId >= 256) {
                long macDomain = BaseDeviceMonitoring.getLong(oidMap, macDomainOid);
                responseMap = monitor.getOidTables("1.3.6.1.4.1.4491.2.1.20.1.5.1.3." + macDomain, "1.3.6.1.2.1.2.2.1.2", "1.3.6.1.2.1.10.127.1.1.1.1.2", "1.3.6.1.2.1.10.127.1.1.2.1.2", "1.3.6.1.2.1.10.127.1.1.1.1.6", "1.3.6.1.2.1.10.127.1.1.1.1.4");
                oidMap.putAll(responseMap);
                responseMap = monitor.readOidValues("1.3.6.1.4.1.4491.2.1.20.1.22.1.2." + macDomain + "." + tcsId, "1.3.6.1.4.1.4491.2.1.20.1.23.1.2." + macDomain + "." + rcsId);
                oidMap.putAll(responseMap);
            } else {
                response.setDocsis(DOCSIS.DOCSIS2_0);
            }
        }
    }

    private Set<String> buildRequestOid(VariableBinding varBind, String ... oidArray) {
        HashSet<String> oidGetData = new HashSet<String>();
        int intfIndex = varBind.getVariable().toInt();
        for (String oid : oidArray) {
            oidGetData.add(oid + "." + intfIndex);
        }
        return oidGetData;
    }

    private Map<String, Integer> findDeviceByIP(String ip, List<DeviceDTO> cmtsDevices) {
        HashMap<String, Integer> modemIndexMap = new HashMap<String, Integer>();
        for (DeviceDTO cmtsDto : cmtsDevices) {
            String ipAddress = cmtsDto.getIpAddress() != null ? IPUtils.ipLongToString(cmtsDto.getIpAddress()) : this.sysLogPacketProcessor.getIpByMac(cmtsDto.getMac());
            if (ipAddress == null) continue;
            DeviceRequestPacket requestPacket = new DeviceRequestPacket();
            requestPacket.setDeviceId(cmtsDto.getId());
            requestPacket.setIpAddress(ipAddress);
            CMTSFindIndexByIpThread t = new CMTSFindIndexByIpThread(ip, requestPacket, modemIndexMap, this.snmpPoolManager, this.cmtsPacket);
            if (this.snmpPoolManager != null) {
                this.snmpPoolManager.registerThread(t, true);
                continue;
            }
            new Thread(t).start();
        }
        long timeout = System.currentTimeMillis() + 30000L;
        while (modemIndexMap.size() < cmtsDevices.size() && System.currentTimeMillis() <= timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                return null;
            }
        }
        for (String key : new HashSet(modemIndexMap.keySet())) {
            if (modemIndexMap.get(key) != null) continue;
            modemIndexMap.remove(key);
        }
        return modemIndexMap;
    }

    private Map<String, Integer> findDeviceByMac(String mac, List<DeviceDTO> cmtsDevices) throws InvalidMacAddress {
        HashMap<String, Integer> modemIndexMap = new HashMap<String, Integer>();
        for (DeviceDTO cmtsDto : cmtsDevices) {
            String ipAddress = null;
            if (cmtsDto.getIpAddress() != null) {
                ipAddress = IPUtils.ipLongToString(cmtsDto.getIpAddress());
            } else if (!StringUtil.isEmpty(cmtsDto.getMac())) {
                ipAddress = this.sysLogPacketProcessor.getIpByMac(cmtsDto.getMac());
            }
            if (ipAddress == null) continue;
            DeviceRequestPacket requestPacket = new DeviceRequestPacket();
            requestPacket.setDeviceId(cmtsDto.getId());
            requestPacket.setIpAddress(ipAddress);
            CMTSFindIndexByMacThread t = new CMTSFindIndexByMacThread(mac, requestPacket, modemIndexMap, this.snmpPoolManager, this.cmtsPacket);
            if (this.snmpPoolManager != null) {
                this.snmpPoolManager.registerThread(t, true);
                continue;
            }
            new Thread(t).start();
        }
        long timeout = System.currentTimeMillis() + 30000L;
        while (modemIndexMap.size() < cmtsDevices.size() && System.currentTimeMillis() <= timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                return null;
            }
        }
        for (String key : new HashSet(modemIndexMap.keySet())) {
            if (modemIndexMap.get(key) != null) continue;
            modemIndexMap.remove(key);
        }
        return modemIndexMap;
    }

    static enum DocsisQosVersion {
        unknown(""),
        docsis10("DOCSIS 1.0"),
        docsis11("DOCSIS 1.1");

        String text;

        private DocsisQosVersion(String text) {
            this.text = text;
        }
    }

    static enum UpstreamModulation {
        unknown,
        tdma,
        atdma,
        scdma,
        tdmaAndAtdma;

    }

    static enum DownstreamModulation {
        none,
        unknown,
        other,
        qam64,
        qam256;

    }
}

