/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.icmp;

import com.dsoft.powerpro.monitorserver.snmp.MonitoringMethod;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ICMPMonitor
extends MonitoringMethod {
    private static final int DEFAULT_MAX_HOPS = 3;

    public ICMPMonitor() {
        super(3000, 4);
    }

    public ICMPMonitor(int timeout, int retry) {
        super(timeout, retry);
    }

    @Override
    public boolean isDeviceLive(String address, Object monitor, Object object) throws InterruptedException, UnknownHostException {
        try {
            boolean res = false;
            InetAddress iNetAddress = InetAddress.getByName(address);
            for (int i = 0; i < this.retry && !(res = iNetAddress.isReachable(null, 3, this.timeout)); ++i) {
            }
            return res;
        }
        catch (UnknownHostException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

