/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.powerpro.agent.pool.PoolTask;
import com.dsoft.powerpro.internet.mserver.InfoPacket;
import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceRequestPacket;
import com.dsoft.powerpro.monitoring.mserver.response.OIDResponsePacket;
import com.dsoft.powerpro.monitorserver.MonitoringMessageProcessor;
import java.util.List;
import java.util.stream.Collectors;

public abstract class PoolTaskThread<T extends DeviceRequestPacket>
implements PoolTask {
    private T packet;
    private long timeout;
    private boolean stopped = false;
    private String threadId;
    private long threadExpiring = 0L;

    public PoolTaskThread(T packet, long timeout) {
        this.packet = packet;
        this.timeout = timeout;
        this.threadId = this.getIdString();
        this.threadExpiring = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExpired() {
        PoolTaskThread poolTaskThread = this;
        synchronized (poolTaskThread) {
            return this.threadExpiring > 0L && System.currentTimeMillis() > this.threadExpiring;
        }
    }

    protected abstract String getIdString();

    public T getPacket() {
        return this.packet;
    }

    @Override
    public String getThreadId() {
        return this.threadId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementThreadExpiring(long time) {
        PoolTaskThread poolTaskThread = this;
        synchronized (poolTaskThread) {
            this.threadExpiring = System.currentTimeMillis() + time;
        }
    }

    protected boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void stopThread() {
        this.stopped = true;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected void sendOidVariablePacket(String requestMarker, Integer deviceId, String mac, List<OIDParameterVariable> oidList, Integer monitorIteration) {
        this.fillPacketAndSend(deviceId, mac, oidList, monitorIteration, new OIDResponsePacket(requestMarker));
    }

    protected void fillPacketAndSend(Integer deviceId, String mac, List<OIDParameterVariable> oidList, Integer monitorIteration, OIDResponsePacket monitorPacket) {
        monitorPacket.setDeviceId(deviceId);
        monitorPacket.setMac(mac);
        monitorPacket.setQueueId(((InfoPacket)this.packet).getQueueId());
        if (oidList != null) {
            monitorPacket.getOidParameters().putAll(oidList.stream().collect(Collectors.toMap(v -> v.getVariableBinding().getOid().toString(), v -> v)));
        }
        monitorPacket.setMonitorIteration(monitorIteration);
        MonitoringMessageProcessor.getInstance().sendInfoPacket(monitorPacket, ((InfoPacket)this.packet).getQueueId() != null);
    }
}

