/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitorserver.snmp.MonitoringMethod;
import com.dsoft.powerpro.monitorserver.snmp.SnmpResponseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.PDUFactory;

public class SNMPBaseMonitor
extends MonitoringMethod
implements PDUFactory {
    private static final String DOT = ".";
    private static final Logger LOGGER = Logger.getLogger(SNMPBaseMonitor.class.getName());
    private static final Object snmpSessionLock = new Object();
    private static Map<SNMPSessionKey, Snmp> snmpSessionMap = new HashMap<SNMPSessionKey, Snmp>();
    protected DeviceOIDParameterPacket packet;
    protected Target monitTarget;
    protected PDU monitPdu;
    protected Address address;
    protected int version = 0;
    private int pduType = -95;
    String resultString;
    long pingResponseTime;
    long pingStartTime;
    private OID authProtocol;
    private OID privProtocol;
    private OctetString privPassphrase;
    private OctetString authPassphrase;
    private OctetString community = new OctetString("public");
    private OctetString contextEngineID;
    private OctetString contextName = new OctetString();
    private OctetString securityName = new OctetString();
    protected TimeTicks sysUpTime = new TimeTicks(0L);
    protected OID trapOID = SnmpConstants.coldStart;
    private PDUv1 v1TrapPDU = new PDUv1();
    private List<OIDParameterVariable> ifIndexes = null;

    public SNMPBaseMonitor() {
        this(5000, 4);
    }

    public SNMPBaseMonitor(DeviceOIDParameterPacket packet) {
        this(5000, 4);
        this.packet = packet;
        this.baseInitialization();
    }

    public SNMPBaseMonitor(int timeout, int retry) {
        super(timeout, retry);
    }

    private static OctetString createOctetString(String s) {
        OctetString octetString = s.startsWith("0x") ? OctetString.fromHexString(s.substring(2), ':') : new OctetString(s);
        return octetString;
    }

    private void addUsmUser(Snmp snmp) {
        snmp.getUSM().addUser(this.securityName, new UsmUser(this.securityName, this.authProtocol, this.authPassphrase, this.privProtocol, this.privPassphrase));
    }

    private void baseInitialization() {
        int port = this.packet.getPort() != null && this.packet.getPort() != 0 ? this.packet.getPort() : 161;
        this.address = GenericAddress.parse("udp:" + this.packet.getIpAddress() + "/" + port);
        this.retry = this.packet.getRetries() != null && this.packet.getRetries() > 0 ? this.packet.getRetries() : this.retry;
        this.timeout = this.packet.getTimeout() != null && this.packet.getTimeout() > 0L ? (int)this.packet.getTimeout().longValue() : this.timeout;
        switch (this.packet.getOidRequestType()) {
            case 0: {
                this.pduType = -96;
                break;
            }
            case 1: {
                this.pduType = -95;
                break;
            }
            case 2: {
                this.pduType = -93;
                break;
            }
            case 3: {
                this.pduType = -91;
                break;
            }
            default: {
                this.pduType = -95;
            }
        }
        if (this.packet.getSnmpVersion().equals("SNMP v.1")) {
            this.version = 0;
            this.initialize(this.pduType);
            return;
        }
        if (this.packet.getSnmpVersion().equals("SNMP v.2")) {
            this.version = 1;
            this.initialize(this.pduType);
            return;
        }
        if (!this.packet.getSnmpVersion().equals("SNMP v.3")) {
            throw new IllegalArgumentException("Version " + this.packet.getSnmpVersion() + " not supported");
        }
        this.version = 3;
        if (this.packet.getAuthProtocol() != null) {
            if (this.packet.getAuthProtocol().equals("MD5")) {
                this.authProtocol = AuthMD5.ID;
            } else if (this.packet.getAuthProtocol().equals("SHA")) {
                this.authProtocol = AuthSHA.ID;
            } else {
                throw new IllegalArgumentException("Authentication protocol unsupported: " + this.packet.getAuthProtocol());
            }
        }
        if (this.packet.getPrivProtocol() != null) {
            if (this.packet.getPrivProtocol().equals("DES")) {
                this.privProtocol = PrivDES.ID;
            } else if (this.packet.getPrivProtocol().equals("AES128") || this.packet.getPrivProtocol().equals("AES")) {
                this.privProtocol = PrivAES128.ID;
            } else if (this.packet.getPrivProtocol().equals("AES192")) {
                this.privProtocol = PrivAES192.ID;
            } else if (this.packet.getPrivProtocol().equals("AES256")) {
                this.privProtocol = PrivAES256.ID;
            } else {
                throw new IllegalArgumentException("Privacy protocol " + this.packet.getPrivProtocol() + " not supported");
            }
        }
        this.privPassphrase = SNMPBaseMonitor.createOctetString(this.packet.getPrivPassword());
        this.authPassphrase = SNMPBaseMonitor.createOctetString(this.packet.getAuthPassword());
        this.contextEngineID = SNMPBaseMonitor.createOctetString(this.packet.getContextId());
        this.contextName = SNMPBaseMonitor.createOctetString(this.packet.getContextName());
        this.securityName = new OctetString();
        this.initialize(this.pduType);
    }

    @Override
    public PDU createPDU(Target target) {
        PDU request;
        if (target.getVersion() == 3) {
            request = new ScopedPDU();
            ScopedPDU scopedPDU = request;
            if (this.contextEngineID != null) {
                scopedPDU.setContextEngineID(this.contextEngineID);
            }
            if (this.contextName != null) {
                scopedPDU.setContextName(this.contextName);
            }
        } else {
            request = this.pduType == -92 ? this.v1TrapPDU : new PDU();
        }
        request.setType(this.pduType);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Snmp getSnmpSession(String addressType, int version) throws IOException {
        SNMPSessionKey key = new SNMPSessionKey(addressType, "" + version);
        Object object = snmpSessionLock;
        synchronized (object) {
            if (snmpSessionMap.containsKey(key)) {
                ArrayList<SNMPSessionKey> keyList = new ArrayList<SNMPSessionKey>(snmpSessionMap.keySet());
                key = (SNMPSessionKey)keyList.get(keyList.indexOf(key));
                key.lock();
                return snmpSessionMap.get(key);
            }
            AbstractTransportMapping transport = this.address instanceof TcpAddress ? new DefaultTcpTransportMapping() : new DefaultUdpTransportMapping();
            Snmp snmp = new Snmp(transport);
            if (version == 3) {
                USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
                SecurityModels.getInstance().addSecurityModel(usm);
                this.addUsmUser(snmp);
            }
            snmpSessionMap.put(key, snmp);
            key.lock();
            snmp.listen();
            return snmp;
        }
    }

    protected Snmp getSnmpSession() throws IOException {
        String addressType = "UDP";
        if (this.address instanceof TcpAddress) {
            addressType = "TCP";
        }
        return this.getSnmpSession(addressType, this.version);
    }

    protected void closeSession(Snmp session) throws IOException {
        this.closeSession(session, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSession(Snmp session, boolean releaseSession) throws IOException {
        Object object = snmpSessionLock;
        synchronized (object) {
            for (SNMPSessionKey key : new HashSet<SNMPSessionKey>(snmpSessionMap.keySet())) {
                if (snmpSessionMap.get(key) != session) continue;
                key.unlock(releaseSession);
                if (!releaseSession) break;
                snmpSessionMap.remove(key);
                session.close();
                break;
            }
        }
    }

    private Target createTarget() {
        if (this.version == 3) {
            UserTarget target = new UserTarget();
            if (this.authPassphrase != null) {
                if (this.privPassphrase != null) {
                    target.setSecurityLevel(3);
                } else {
                    target.setSecurityLevel(2);
                }
            } else {
                target.setSecurityLevel(1);
            }
            target.setSecurityName(this.securityName);
            return target;
        }
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(this.community);
        return target;
    }

    protected List<OIDParameterVariable> getIfIndexes(Snmp snmpSession, boolean reset) throws IOException {
        if (this.ifIndexes != null && !reset) {
            return this.ifIndexes;
        }
        this.ifIndexes = new ArrayList<OIDParameterVariable>();
        this.getOidTableVariables(snmpSession, (OIDParameterVariable oidVar) -> this.ifIndexes.add((OIDParameterVariable)oidVar), "1.3.6.1.2.1.2.2.1.1");
        return this.ifIndexes;
    }

    protected boolean getOidTableVariables(Snmp snmpSession, Consumer<OIDParameterVariable> oidConsumer, String ... variablesToGet) throws IOException {
        return this.getOidTableVariables(snmpSession, oidConsumer, Arrays.asList(variablesToGet));
    }

    protected boolean getOidTableVariables(Snmp snmpSession, Consumer<OIDParameterVariable> oidConsumer, Collection<String> variablesToGet) throws IOException {
        if (this.version == 0) {
            this.monitPdu.setType(-95);
        } else {
            this.monitPdu.setType(-91);
        }
        int retries = 0;
        ArrayList<OID> oidToGet = new ArrayList<OID>();
        for (String oid : variablesToGet) {
            oidToGet.add(new OID(oid));
        }
        Collections.sort(oidToGet);
        OID currentOid = new OID();
        OID lastOid = new OID();
        HashSet<OID> foundOid = new HashSet<OID>();
        List<Object> response = new ArrayList();
        block1: while (!oidToGet.isEmpty() && (lastOid.startsWith(currentOid) || foundOid.size() < variablesToGet.size())) {
            this.monitPdu.getVariableBindings().clear();
            if (!lastOid.startsWith(currentOid) || currentOid.size() == 0) {
                lastOid = currentOid = (OID)oidToGet.get(0);
                if (this.monitPdu.getType() == -91) {
                    this.monitPdu.setMaxRepetitions(10);
                }
            } else if (this.monitPdu.getType() == -91 && response.size() == this.monitPdu.getMaxRepetitions()) {
                this.monitPdu.setMaxRepetitions(this.monitPdu.getMaxRepetitions() * 2);
            }
            this.monitPdu.add(new VariableBinding(lastOid));
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            response = this.processResponse(snmpSession);
            if (response.isEmpty()) {
                if (++retries <= 3) continue;
                break;
            }
            lastOid = new OID();
            boolean firstDifferent = true;
            for (OIDParameterVariable oIDParameterVariable : response) {
                lastOid = oIDParameterVariable.getVariableBinding().getOid();
                OID lstOid = oIDParameterVariable.getVariableBinding().getOid();
                int oidChecked = 0;
                for (OID oid : oidToGet) {
                    if (lstOid.startsWith(oid)) {
                        oidConsumer.accept(oIDParameterVariable);
                        currentOid = oid;
                        foundOid.add(oid);
                        firstDifferent = true;
                        break;
                    }
                    ++oidChecked;
                }
                if (oidChecked < oidToGet.size()) {
                    while (oidChecked > 0) {
                        oidToGet.remove(0);
                        --oidChecked;
                    }
                    continue;
                }
                if (!firstDifferent) continue;
                oidToGet.remove(0);
                firstDifferent = false;
                if (!oidToGet.isEmpty()) continue;
                continue block1;
            }
        }
        return true;
    }

    protected Map<String, OIDParameterVariable> getOidTableVariables(Snmp snmpSession, String ... variablesToGet) throws IOException {
        return this.getOidTableVariables(snmpSession, Arrays.asList(variablesToGet));
    }

    protected Map<String, OIDParameterVariable> getOidTableVariables(Snmp snmpSession, Collection<String> variablesToGet) throws IOException {
        HashMap<String, OIDParameterVariable> result = new HashMap<String, OIDParameterVariable>();
        this.getOidTableVariables(snmpSession, (OIDParameterVariable oid) -> result.put(oid.getVariableBinding().getOid().toString(), (OIDParameterVariable)oid), variablesToGet);
        return result;
    }

    protected Map<String, OIDParameterVariable> getOidVariables(Snmp snmpSession, int getType, String ... vars) throws IOException {
        return this.getOidVariables(snmpSession, getType, Arrays.asList(vars));
    }

    protected Map<String, OIDParameterVariable> getOidVariables(Snmp snmpSession, int getType, Collection<String> vars) throws IOException {
        this.monitPdu.setType(getType);
        HashMap<String, OIDParameterVariable> result = new HashMap<String, OIDParameterVariable>();
        int tries = 0;
        HashSet<String> variablesToGet = new HashSet<String>(vars);
        while (!variablesToGet.isEmpty() && tries < 5) {
            this.monitPdu.getVariableBindings().clear();
            HashSet<String> requested = new HashSet<String>();
            for (String variableOid : variablesToGet) {
                this.monitPdu.add(new VariableBinding(new OID(variableOid)));
                requested.add(variableOid);
                if (this.monitPdu.getVariableBindings().size() <= 10) continue;
                break;
            }
            if (Thread.currentThread().isInterrupted()) {
                return result;
            }
            ResponseEvent event = snmpSession.send(this.monitPdu, this.monitTarget, null);
            PDU response = event.getResponse();
            if (response != null) {
                Vector variables = event.getResponse().getVariableBindings();
                if (!variables.isEmpty()) {
                    for (VariableBinding variable : variables) {
                        String paramName = variable.getOid().toString();
                        block0 : switch (getType) {
                            case -96: {
                                variablesToGet.remove(paramName);
                                break;
                            }
                            case -95: {
                                for (String var : new HashSet<String>(variablesToGet)) {
                                    if (!paramName.startsWith(var)) continue;
                                    variablesToGet.remove(var);
                                    break block0;
                                }
                                break;
                            }
                        }
                        for (String var : requested) {
                            if (!paramName.startsWith(var) || variable.isException()) continue;
                            result.put(paramName, new OIDParameterVariable(variable, this.packet.getIpAddress()));
                        }
                    }
                    variablesToGet.removeAll(requested);
                    continue;
                }
                ++tries;
                continue;
            }
            ++tries;
        }
        return result;
    }

    long getPingStartTime() {
        return this.pingStartTime;
    }

    public long getResponseTime() {
        return this.pingResponseTime;
    }

    String getResultString() {
        return this.resultString;
    }

    protected void initialize(int pduType) {
        this.community = pduType == -93 ? SNMPBaseMonitor.createOctetString(this.packet.getWriteCommunity() != null ? this.packet.getWriteCommunity() : "private") : SNMPBaseMonitor.createOctetString(this.packet.getReadCommunity() != null ? this.packet.getReadCommunity() : "public");
        int maxRepetitions = this.packet.getMaxRepetitions() != null && this.packet.getMaxRepetitions() > 0 ? this.packet.getMaxRepetitions() : 1;
        int nonRepeaters = this.packet.getNonRepeaters() != null ? this.packet.getNonRepeaters() : 0;
        this.monitTarget = this.createTarget();
        this.monitTarget.setVersion(this.version);
        this.monitTarget.setAddress(this.address);
        this.monitTarget.setRetries(this.retry);
        this.monitTarget.setTimeout(this.timeout);
        this.monitPdu = this.createPDU(this.monitTarget);
        if (this.packet.getOidParameters() == null || this.packet.getOidParameters().isEmpty()) {
            this.monitPdu.add(new VariableBinding(new OID()));
        } else {
            for (VariableBinding vb : this.packet.getOidParameters()) {
                this.monitPdu.add(vb);
            }
        }
        if (this.monitPdu.getType() == -91) {
            this.monitPdu.setMaxRepetitions(maxRepetitions);
            this.monitPdu.setNonRepeaters(nonRepeaters);
        }
    }

    @Override
    public boolean isDeviceLive(String address, Object monitor, Object object) throws SnmpResponseException {
        return true;
    }

    private List<OIDParameterVariable> processResponse(Snmp snmpSession) throws IOException {
        ResponseEvent event = snmpSession.send(this.monitPdu, this.monitTarget);
        ArrayList<OIDParameterVariable> result = new ArrayList<OIDParameterVariable>();
        if (event == null) {
            return result;
        }
        PDU response = event.getResponse();
        if (response == null) {
            return result;
        }
        Vector variables = event.getResponse().getVariableBindings();
        if (variables == null || variables.isEmpty()) {
            return result;
        }
        for (VariableBinding variableBinding : variables) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, String.format("Received response %1$s from %2$s", variableBinding.toString(), event.getPeerAddress()));
            }
            result.add(new OIDParameterVariable(variableBinding, this.packet.getIpAddress()));
        }
        return result;
    }

    public Map<String, OIDParameterVariable> readOidValues(Collection<String> oidToRead) throws Exception {
        Snmp session = this.getSnmpSession();
        try {
            Map<String, OIDParameterVariable> map = this.getOidVariables(session, -96, oidToRead);
            return map;
        }
        catch (Exception ex) {
            this.closeSession(session, true);
            throw ex;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Map<String, OIDParameterVariable> readOidValues(String ... oidToRead) throws Exception {
        return this.readOidValues(Arrays.asList(oidToRead));
    }

    public Map<String, OIDParameterVariable> readNextOidValues(Collection<String> oidToRead) throws Exception {
        Snmp session = this.getSnmpSession();
        try {
            Map<String, OIDParameterVariable> map = this.getOidVariables(session, -95, oidToRead);
            return map;
        }
        catch (Exception ex) {
            this.closeSession(session, true);
            throw ex;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Map<String, OIDParameterVariable> readNextOidValues(String ... oidToRead) throws Exception {
        return this.readNextOidValues(Arrays.asList(oidToRead));
    }

    public Map<String, OIDParameterVariable> getOidTables(Collection<String> oidToRead) throws Exception {
        Snmp session = this.getSnmpSession();
        try {
            Map<String, OIDParameterVariable> map = this.getOidTableVariables(session, oidToRead);
            return map;
        }
        catch (Exception ex) {
            this.closeSession(session, true);
            throw ex;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Map<String, OIDParameterVariable> getOidTables(String ... oidToRead) throws Exception {
        return this.getOidTables(Arrays.asList(oidToRead));
    }

    protected Map<Integer, Integer> readInterfaceIOStats(Snmp snmpSession, List<OIDParameterVariable> oidList, int[] interfaceTypes) throws IOException {
        ArrayList<String> oidToRead = new ArrayList<String>(Arrays.asList("1.3.6.1.2.1.1.1", "1.3.6.1.2.1.1.3", "1.3.6.1.2.1.2.2.1.6", "1.3.6.1.2.1.2.2.1.10", "1.3.6.1.2.1.2.2.1.16", "1.3.6.1.2.1.31.1.1.1.6", "1.3.6.1.2.1.31.1.1.1.10"));
        if (interfaceTypes != null && interfaceTypes.length > 0) {
            oidToRead.add("1.3.6.1.2.1.2.2.1.3");
        }
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        if (interfaceTypes != null && interfaceTypes.length > 0) {
            HashSet indexToProcess = new HashSet();
            this.getOidTableVariables(snmpSession, (OIDParameterVariable variable) -> {
                int index;
                String oid = variable.getVariableBinding().getOid().toString();
                if (oid.startsWith("1.3.6.1.2.1.1")) {
                    oidList.add((OIDParameterVariable)variable);
                }
                if (oid.startsWith("1.3.6.1.2.1.2.2.1.3")) {
                    index = variable.getVariableBinding().getOid().last();
                    Integer ifType = variable.getVariableBinding().getVariable().toInt();
                    result.put(index, ifType);
                    for (int intfType : interfaceTypes) {
                        if (intfType != ifType) continue;
                        oidList.add((OIDParameterVariable)variable);
                        indexToProcess.add(index);
                    }
                }
                index = variable.getVariableBinding().getOid().last();
                if (oid.startsWith("1.3.6.1.2.1.31.1.1.1.6") && indexToProcess.contains(index)) {
                    oidList.add((OIDParameterVariable)variable);
                }
                if (oid.startsWith("1.3.6.1.2.1.31.1.1.1.10") && indexToProcess.contains(index)) {
                    oidList.add((OIDParameterVariable)variable);
                }
                if (oid.startsWith("1.3.6.1.2.1.2.2.1.10") && indexToProcess.contains(index)) {
                    oidList.add((OIDParameterVariable)variable);
                }
                if (oid.startsWith("1.3.6.1.2.1.2.2.1.16") && indexToProcess.contains(index)) {
                    oidList.add((OIDParameterVariable)variable);
                }
                if (oid.startsWith("1.3.6.1.2.1.2.2.1.6") && indexToProcess.contains(index)) {
                    oidList.add((OIDParameterVariable)variable);
                }
            }, oidToRead);
        } else {
            this.getOidTableVariables(snmpSession, oidList::add, oidToRead);
        }
        return result;
    }

    static class SNMPSessionKey {
        private String addressType;
        private long lastTimeUsed;
        private int lockCount = 0;
        private Thread thread;
        private String version;

        SNMPSessionKey(String addressType, String version) {
            this.addressType = addressType;
            this.version = version;
        }

        int unlock(boolean releaseSession) {
            this.lastTimeUsed = System.currentTimeMillis();
            this.lockCount = releaseSession ? 0 : --this.lockCount;
            return this.lockCount;
        }

        void lock() {
            this.lastTimeUsed = System.currentTimeMillis();
            if (this.lockCount == 0 && this.thread == null) {
                this.thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException ex1) {
                                break;
                            }
                            if (System.currentTimeMillis() - lastTimeUsed <= 10000L || lockCount != 0) continue;
                            Object object = snmpSessionLock;
                            synchronized (object) {
                                try {
                                    Snmp snmp = (Snmp)snmpSessionMap.remove(this);
                                    if (snmp != null) {
                                        snmp.close();
                                    }
                                    break;
                                }
                                catch (Exception ex) {
                                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                                }
                            }
                        }
                    }
                };
                this.thread.start();
            }
            ++this.lockCount;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.addressType == null ? 0 : this.addressType.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SNMPSessionKey other = (SNMPSessionKey)obj;
            if (this.addressType == null ? other.addressType != null : !this.addressType.equals(other.addressType)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }
}

