/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitorserver.dto.SnmpConfigsDTO;
import com.dsoft.powerpro.monitorserver.snmp.SNMPBaseMonitor;
import com.dsoft.powerpro.monitorserver.snmp.SnmpResponseException;
import com.dsoft.powerpro.monitorserver.snmp.SnmpResponseListenerImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;

public class SNMPRequestMonitor
extends SNMPBaseMonitor {
    private static final Logger logger = Logger.getLogger(SNMPRequestMonitor.class.getName());

    public SNMPRequestMonitor() {
    }

    public SNMPRequestMonitor(DeviceOIDParameterPacket packet) {
        super(packet);
    }

    public SNMPRequestMonitor(int timeout, int retry) {
        super(timeout, retry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeviceLive(String address, Object monitor, Object object) throws SnmpResponseException {
        boolean isResponding = false;
        SnmpResponseListenerImpl listener = null;
        SnmpConfigsDTO confDto = (SnmpConfigsDTO)object;
        try {
            int snmpVersion = 0;
            Snmp snmpSession = this.getSnmpSession("UDP", snmpVersion);
            try {
                CommunityTarget target = new CommunityTarget();
                if (confDto != null) {
                    int port = confDto.getPort() != null && confDto.getPort() != 0 ? confDto.getPort() : 161;
                    Address targetAddress = GenericAddress.parse("udp:" + address + "/" + port);
                    target.setCommunity(new OctetString(confDto.getReadcommunity() != null ? confDto.getReadcommunity() : "public"));
                    target.setRetries(confDto.getRetries() == null ? this.retry : confDto.getRetries());
                    target.setTimeout(confDto.getTimeout() > 0L ? confDto.getTimeout() : (long)this.timeout);
                    target.setAddress(targetAddress);
                } else {
                    Address targetAddress = GenericAddress.parse("udp:" + address + "/" + 161);
                    target.setCommunity(new OctetString("public"));
                    target.setAddress(targetAddress);
                    target.setRetries(this.retry);
                    target.setTimeout(this.timeout);
                }
                target.setVersion(snmpVersion);
                PDU pdu = new PDU();
                pdu.add(new VariableBinding(new OID("1.3.6.1.2.1.1.1")));
                pdu.setType(-95);
                SnmpResponseListenerImpl snmpResponseListenerImpl = listener = new SnmpResponseListenerImpl();
                synchronized (snmpResponseListenerImpl) {
                    snmpSession.send(pdu, (Target)target, null, listener);
                    this.pingStartTime = System.currentTimeMillis();
                    try {
                        listener.wait((long)(target.getRetries() + 1) * target.getTimeout());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    this.pingResponseTime = System.currentTimeMillis();
                }
                isResponding = listener.hasResponse();
            }
            catch (Exception ex) {
                this.closeSession(snmpSession, true);
                throw ex;
            }
            finally {
                this.closeSession(snmpSession);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            if (listener != null) {
                Object result = listener.getErrorResult();
                if (result != null && result instanceof Integer) {
                    Integer resultInt = (Integer)result;
                    throw new SnmpResponseException(resultInt);
                }
                if (result != null && result instanceof String) {
                    this.resultString = (String)result;
                }
            }
        }
        return isResponding;
    }

    public void monitorDeviceParameters() {
        new Thread(() -> {
            Snmp snmpSession = null;
            try {
                snmpSession = this.getSnmpSession();
                try {
                    SnmpResponseListenerImpl listener = new SnmpResponseListenerImpl();
                    listener.setQueueId(this.packet.getQueueId());
                    listener.setRequestMarker(this.packet.getMarker());
                    listener.setDeviceId(this.packet.getDeviceId());
                    SnmpResponseListenerImpl snmpResponseListenerImpl = listener;
                    synchronized (snmpResponseListenerImpl) {
                        snmpSession.send(this.monitPdu, this.monitTarget, null, listener);
                        try {
                            listener.wait((long)(this.monitTarget.getRetries() + 1) * this.monitTarget.getTimeout());
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                catch (Exception ex) {
                    this.closeSession(snmpSession, true);
                    throw ex;
                }
                finally {
                    this.closeSession(snmpSession);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }).start();
    }
}

