/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitorserver.snmp.SNMPBaseMonitor;
import com.dsoft.powerpro.monitorserver.snmp.SnmpResponseException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.Snmp;

public class SNMPTrafficMonitor
extends SNMPBaseMonitor {
    private static final Logger logger = Logger.getLogger(SNMPTrafficMonitor.class.getName());

    public SNMPTrafficMonitor() {
    }

    public SNMPTrafficMonitor(DeviceOIDParameterPacket packet) {
        super(packet);
    }

    public SNMPTrafficMonitor(int timeout, int retry) {
        super(timeout, retry);
    }

    List<OIDParameterVariable> getOIDParameters() {
        ArrayList<OIDParameterVariable> arrayList;
        Snmp snmpSession = this.getSnmpSession();
        try {
            this.monitPdu.clear();
            ArrayList<OIDParameterVariable> result = new ArrayList<OIDParameterVariable>();
            this.readInterfaceIOStats(snmpSession, result, new int[]{127, 6, 160, 117});
            arrayList = result;
        }
        catch (Exception ex) {
            try {
                try {
                    this.closeSession(snmpSession, true);
                    throw ex;
                }
                catch (Throwable throwable) {
                    this.closeSession(snmpSession);
                    throw throwable;
                }
            }
            catch (Exception ex2) {
                logger.log(Level.SEVERE, ex2.getMessage(), ex2);
                ex2.printStackTrace();
                return new ArrayList<OIDParameterVariable>();
            }
        }
        this.closeSession(snmpSession);
        return arrayList;
    }

    @Override
    public boolean isDeviceLive(String address, Object monitor, Object object) throws SnmpResponseException {
        return true;
    }

    public void monitorDeviceParameters() throws UnknownHostException, InterruptedException {
    }
}

