/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.snmp.BaseMonitoringThread;
import com.dsoft.powerpro.monitorserver.snmp.SNMPTrafficMonitor;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class SNMPTrafficMonitoringThread
extends BaseMonitoringThread<DeviceOIDParameterPacket> {
    private static final Logger logger = Logger.getLogger(SNMPTrafficMonitoringThread.class.getName());
    long originalTimeOut;
    private int monitorIteration;

    public SNMPTrafficMonitoringThread(DeviceOIDParameterPacket packet, long timeout, int monitorIteration) throws NamingException {
        super(packet, timeout);
        this.monitorIteration = monitorIteration;
    }

    public static String constructThreadId(DeviceOIDParameterPacket packet) {
        String id = "SNMP:" + packet.getDeviceId() + ":";
        if (packet.getQueueId() != null) {
            id = id + packet.getQueueId();
        }
        return id;
    }

    @Override
    protected String getIdString() {
        return SNMPTrafficMonitoringThread.constructThreadId((DeviceOIDParameterPacket)this.getPacket());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.originalTimeOut = this.getTimeout();
        try {
            SNMPTrafficMonitor snmpTrafficMonitor = new SNMPTrafficMonitor((DeviceOIDParameterPacket)this.getPacket());
            while (!this.isStopped()) {
                boolean skipThisRound = this.checkMessageQueue(this.originalTimeOut);
                if (!skipThisRound) {
                    List<OIDParameterVariable> result = snmpTrafficMonitor.getOIDParameters();
                    ++this.monitorIteration;
                    MonitoringManager.getInstance().incrementMonitorIteration(((DeviceOIDParameterPacket)this.getPacket()).getDeviceId(), this.monitorIteration);
                    this.sendOidVariablePacket(((DeviceOIDParameterPacket)this.getPacket()).getMarker(), ((DeviceOIDParameterPacket)this.getPacket()).getDeviceId(), null, result, this.monitorIteration);
                }
                try {
                    Thread.sleep(this.getTimeout());
                }
                catch (InterruptedException ex) {
                    this.stopThread();
                    return;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

