/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.powerpro.internet.mserver.queue.MessageQueue;
import com.dsoft.powerpro.monitorserver.ServerProperties;
import com.dsoft.powerpro.monitorserver.snmp.SnmpCommandResponderImpl;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.snmp4j.Snmp;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SNMPTrapServer
implements Runnable {
    private static final Logger logger = Logger.getLogger(SNMPTrapServer.class.getName());
    private final SnmpCommandResponderImpl trapResponder;
    private Thread trapServerThread;
    private ServerProperties serverProperties;

    public SNMPTrapServer(ThreadGroup threadGroup, MessageQueue messageQueue, ServerProperties serverProperties) {
        this.trapServerThread = new Thread(threadGroup, this, "SNMP Trap Server thread");
        this.trapResponder = new SnmpCommandResponderImpl(messageQueue, serverProperties.getSnmpCommunity());
        this.serverProperties = serverProperties;
    }

    @PostConstruct
    public void start() {
        this.trapServerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Snmp snmpSession = null;
        try {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping(new UdpAddress(this.serverProperties.getSnmpBindAddress(), this.serverProperties.getSnmpTrapPort()));
            snmpSession = new Snmp(transport);
            snmpSession.addCommandResponder(this.trapResponder);
            transport.listen();
            try {
                logger.info("Waiting for Trap ...");
                do {
                    SnmpCommandResponderImpl snmpCommandResponderImpl = this.trapResponder;
                    synchronized (snmpCommandResponderImpl) {
                        this.trapResponder.wait();
                        if (!Thread.currentThread().isInterrupted()) {
                            logger.log(Level.FINE, "Receive Trap");
                        }
                    }
                } while (!Thread.currentThread().isInterrupted());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
        finally {
            if (snmpSession != null) {
                try {
                    snmpSession.close();
                    logger.info("ClosingSession Trap");
                }
                catch (IOException e) {}
            }
        }
    }

    @PreDestroy
    public void stopServer() {
        this.trapServerThread.interrupt();
    }
}

