/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.framework.client.util.IPUtils;
import com.dsoft.powerpro.internet.mserver.queue.MessageQueue;
import com.dsoft.powerpro.monitoring.mserver.response.Trap;
import com.dsoft.powerpro.monitoring.mserver.response.TrapPacket;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.VariableBinding;

class SnmpCommandResponderImpl
implements CommandResponder {
    private static final Logger LOGGER = Logger.getLogger(SnmpCommandResponderImpl.class.getName());
    private MessageQueue messageQueue;
    private String snmpTrapCommunity;

    SnmpCommandResponderImpl(MessageQueue messageQueue, String snmpTrapCommunity) {
        this.messageQueue = messageQueue;
        this.snmpTrapCommunity = snmpTrapCommunity;
    }

    private TrapPacket processV1Trap(String inetAddress, PDUv1 snmpPduTrap) {
        int code = snmpPduTrap.getGenericTrap();
        System.out.print(snmpPduTrap);
        String objectId = snmpPduTrap.getEnterprise().toString();
        Trap trap = code >= 0 && code < 6 ? Trap.values()[code + 1] : Trap.unknown;
        try {
            long ipLong = IPUtils.ipStringToLong(inetAddress);
            Integer deviceId = MonitoringManager.getInstance().getDeviceId(ipLong);
            TrapPacket trapPacket = new TrapPacket();
            trapPacket.setTrap(trap);
            trapPacket.setIpAddress(inetAddress);
            trapPacket.setDeviceId(deviceId);
            if (trap == Trap.unknown) {
                trapPacket.setTrapOid(objectId);
            } else {
                trapPacket.setTrapOid(trap.getOid());
            }
            trapPacket.setOidParameters(new ArrayList<VariableBinding>(snmpPduTrap.getVariableBindings()));
            return trapPacket;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    private TrapPacket processV2Trap(String inetAddress, PDU snmpPduTrap) {
        try {
            long ipLong = IPUtils.ipStringToLong(inetAddress);
            System.out.print(snmpPduTrap);
            TrapPacket trapPacket = new TrapPacket();
            Integer deviceId = MonitoringManager.getInstance().getDeviceId(ipLong);
            Vector bindings = snmpPduTrap.getVariableBindings();
            for (VariableBinding binding : bindings) {
                if (!"1.3.6.1.6.3.1.1.4.1.0".equals(binding.getOid().toString())) continue;
                String oid = binding.getVariable().toString();
                Trap trap = Trap.fromOid(oid);
                trapPacket.setTrap(trap);
                trapPacket.setTrapOid(oid);
                break;
            }
            trapPacket.setIpAddress(inetAddress);
            trapPacket.setDeviceId(deviceId);
            trapPacket.setOidParameters(new ArrayList<VariableBinding>(bindings));
            return trapPacket;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void processPdu(CommandResponderEvent e) {
        SnmpCommandResponderImpl snmpCommandResponderImpl = this;
        synchronized (snmpCommandResponderImpl) {
            this.notifyAll();
        }
        String securityName = new String(e.getSecurityName());
        if (!this.snmpTrapCommunity.equals(securityName)) {
            return;
        }
        LOGGER.info("Peer Address " + e.getPeerAddress().toString());
        if (e.getPDU() != null) {
            PDU pdu = e.getPDU();
            if (pdu.getErrorStatus() == 5) {
                LOGGER.log(Level.SEVERE, pdu.getErrorStatusText());
                return;
            }
            TrapPacket trapPacket = null;
            if (pdu.getType() == -92) {
                PDUv1 pduV1 = (PDUv1)pdu;
                trapPacket = this.processV1Trap(pduV1.getAgentAddress().getInetAddress().getCanonicalHostName(), pduV1);
            } else if (pdu.getType() == -89) {
                if (!(e.getPeerAddress() instanceof IpAddress)) {
                    return;
                }
                IpAddress ipAddress = (IpAddress)e.getPeerAddress();
                trapPacket = this.processV2Trap(ipAddress.getInetAddress().getCanonicalHostName(), pdu);
            } else if (pdu.getType() == -88) {
                System.out.println(pdu);
            }
            if (trapPacket != null) {
                try {
                    this.messageQueue.postMessage(trapPacket, 0, -1L, null, false);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
    }
}

