/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.framework.client.util.IPUtils;
import com.dsoft.powerpro.agent.pool.PoolTask;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.request.IFTableStatusPacket;
import com.dsoft.powerpro.monitoring.mserver.request.RequestInterfaceStatusPacket;
import com.dsoft.powerpro.monitoring.mserver.request.RequestStatusPacket;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.ServerProperties;
import com.dsoft.powerpro.monitorserver.devices.SNMPMonitoringThread;
import com.dsoft.powerpro.monitorserver.dto.DeviceDTO;
import com.dsoft.powerpro.monitorserver.dto.DeviceOidParametersDTO;
import com.dsoft.powerpro.monitorserver.dto.SnmpConfigsDTO;
import com.dsoft.powerpro.monitorserver.snmp.PoolTaskThread;
import com.dsoft.powerpro.monitorserver.snmp.SnmpThreadPool;
import com.dsoft.powerpro.monitorserver.snmp.devices.DevicesMonitoringThread;
import com.dsoft.powerpro.monitorserver.snmp.devices.IFTableMonitoringThread;
import com.dsoft.powerpro.monitorserver.snmp.devices.InterfaceStatusMonitoringThread;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.picocontainer.annotations.Inject;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class SnmpPoolManager {
    private static final Logger logger = Logger.getLogger(SnmpPoolManager.class.getName());
    private SnmpThreadPool pool;
    @Inject
    private MonitoringManager monitoringManager;
    @Inject
    private ServerProperties serverProperties;

    public String registerThread(PoolTaskThread thread, boolean priorityThread) {
        this.removeThread(thread.getThreadId());
        this.pool.runTask(thread, priorityThread);
        return thread.getThreadId();
    }

    public void addDeviceMonitorTask(Integer deviceId) {
        try {
            DeviceOIDParameterPacket packet;
            DeviceDTO dto = this.monitoringManager.getDevice(deviceId);
            if (dto.getPingType() == 1) {
                packet = this.constructDeviceOIDParameterPacket(dto.getId(), null, null);
            } else {
                packet = new DeviceOIDParameterPacket();
                Long ip = dto.getIpAddress();
                if (ip == null) {
                    return;
                }
                packet.setIpAddress(IPUtils.ipLongToString((long)ip));
                packet.setDeviceId(dto.getId());
            }
            DevicesMonitoringThread thread = new DevicesMonitoringThread(packet, dto.getMonitoringTimeout() > 0L ? dto.getMonitoringTimeout() : 300000L, dto.getPingType());
            this.registerThread(thread, false);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void addSNMPMonitorTask(RequestStatusPacket statusPacket) {
        try {
            DeviceOIDParameterPacket packet = this.constructDeviceOIDParameterPacket(statusPacket.getDeviceId(), statusPacket.getQueueId(), statusPacket.getMarker());
            if (packet == null) {
                return;
            }
            if (packet.getIpAddress() == null) {
                packet.setIpAddress(statusPacket.getIpAddress());
            }
            if (packet.getIpAddress() == null) {
                return;
            }
            packet.setMarker(statusPacket.getMarker());
            ArrayList<VariableBinding> list = new ArrayList<VariableBinding>();
            if (statusPacket.getOidParameters() != null) {
                for (String oid : statusPacket.getOidParameters()) {
                    list.add(new VariableBinding(new OID(oid)));
                }
            }
            packet.setOidParameters(list);
            PoolTaskThread thread = statusPacket instanceof IFTableStatusPacket ? new IFTableMonitoringThread(packet, statusPacket.getTimeout()) : (statusPacket instanceof RequestInterfaceStatusPacket ? new InterfaceStatusMonitoringThread(packet, statusPacket.getTimeout()) : new SNMPMonitoringThread(packet, statusPacket.getTimeout()));
            this.removeThread(thread.getThreadId());
            if (statusPacket.isDeviceMonitoringActive()) {
                this.pool.runTask(thread, true);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @PreDestroy
    public void clearPool() {
        this.pool.close();
    }

    public DeviceOIDParameterPacket constructDeviceOIDParameterPacket(Integer deviceId, Integer queueId, String marker) throws Exception {
        DeviceOIDParameterPacket packet = new DeviceOIDParameterPacket();
        SnmpConfigsDTO confDto = this.monitoringManager.getDeviceSNMPConfig(deviceId);
        if (confDto == null) {
            return null;
        }
        Long ip = this.monitoringManager.getDeviceIp(deviceId);
        packet.setReadCommunity(confDto.getReadcommunity());
        packet.setWriteCommunity(confDto.getWritecommunity());
        packet.setRetries(confDto.getRetries() != null ? confDto.getRetries() : 0);
        packet.setTimeout(confDto.getTimeout());
        packet.setIpAddress(ip != null ? IPUtils.ipLongToString((long)ip) : null);
        packet.setPort(confDto.getPort() != null ? confDto.getPort() : 0);
        packet.setDeviceId(deviceId);
        packet.setSnmpVersion(confDto.getSnmpVersion());
        packet.setAuthPassword(confDto.getAuthPassword());
        packet.setAuthProtocol(confDto.getAuthProtocol());
        packet.setPrivPassword(confDto.getPrivPassword());
        packet.setPrivProtocol(confDto.getPrivProtocol());
        packet.setContextId(confDto.getContextId());
        packet.setContextName(confDto.getContextName());
        packet.setSecurityUserName(confDto.getSecurityUserName());
        packet.setQueueId(queueId);
        packet.setMarker(marker);
        return packet;
    }

    public void removeDeviceMonitorTask(Integer deviceId) {
        try {
            DeviceOIDParameterPacket packet = new DeviceOIDParameterPacket();
            packet.setDeviceId(deviceId);
            this.removeThread(DevicesMonitoringThread.constructThreadId(packet));
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void removeThread(String threadId) {
        this.pool.removeTask(threadId);
    }

    @PostConstruct
    public void start() {
        this.pool = new SnmpThreadPool(this.serverProperties.getSnmpPool());
        this.startSNMPMonitorTasks();
        this.startDeviceMonitorTasks();
        logger.info("SnmpPoolManager Initialized");
    }

    private void startDeviceMonitorTasks() {
        try {
            List<DeviceDTO> devices = this.monitoringManager.getDevicesForMonitoring();
            for (DeviceDTO dto : devices) {
                DeviceOIDParameterPacket packet;
                if (dto.getPingType() == 1) {
                    packet = this.constructDeviceOIDParameterPacket(dto.getId(), null, null);
                } else {
                    packet = new DeviceOIDParameterPacket();
                    Long ip = dto.getIpAddress();
                    if (ip == null) continue;
                    packet.setIpAddress(IPUtils.ipLongToString((long)ip));
                    packet.setDeviceId(dto.getId());
                }
                DevicesMonitoringThread thread = new DevicesMonitoringThread(packet, dto.getMonitoringTimeout() > 0L ? dto.getMonitoringTimeout() : 300000L, dto.getPingType());
                this.pool.runTask(thread, false);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void startSNMPMonitorTasks() {
        try {
            List<DeviceOidParametersDTO> oids = this.monitoringManager.getOIDsForMonitoring();
            for (DeviceOidParametersDTO dto : oids) {
                DeviceOIDParameterPacket packet = this.constructDeviceOIDParameterPacket(dto.getDeviceid(), null, null);
                HashSet<VariableBinding> list = new HashSet<VariableBinding>();
                list.add(new VariableBinding(new OID(dto.getOid())));
                packet.setOidParameters(list);
                SNMPMonitoringThread thread = new SNMPMonitoringThread(packet, dto.getTimeout());
                this.pool.runTask(thread, false);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void updateThreadExpiring(RequestStatusPacket statusPacket) {
        try {
            DeviceOIDParameterPacket packet = this.constructDeviceOIDParameterPacket(statusPacket.getDeviceId(), statusPacket.getQueueId(), statusPacket.getMarker());
            PoolTask thread = statusPacket instanceof IFTableStatusPacket ? new IFTableMonitoringThread(packet, statusPacket.getTimeout()) : new SNMPMonitoringThread(packet, statusPacket.getTimeout());
            ArrayList<VariableBinding> list = new ArrayList<VariableBinding>();
            for (String oid : statusPacket.getOidParameters()) {
                list.add(new VariableBinding(new OID(oid)));
            }
            packet.setOidParameters(list);
            thread = this.pool.getTaskById(thread.getThreadId());
            if (thread != null) {
                thread.incrementThreadExpiring(300000L);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

