/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.framework.client.util.IPUtils;
import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.response.OIDResponsePacket;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.MonitoringMessageProcessor;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class SnmpResponseListenerImpl
implements ResponseListener {
    private static final Logger LOGGER = Logger.getLogger(SnmpResponseListenerImpl.class.getName());
    private Object errorResult;
    private Integer queueId;
    private String requestMarker;
    private Integer deviceId;
    private boolean hasResponse = false;

    protected static void printReport(PDU response) {
        if (response.size() < 1) {
            System.out.println("REPORT PDU does not contain a variable binding.");
            return;
        }
        VariableBinding vb = response.get(0);
        OID oid = vb.getOid();
        if (SnmpConstants.usmStatsUnsupportedSecLevels.equals(oid)) {
            System.out.print("REPORT: Unsupported Security Level.");
        } else if (SnmpConstants.usmStatsNotInTimeWindows.equals(oid)) {
            System.out.print("REPORT: Message not within time window.");
        } else if (SnmpConstants.usmStatsUnknownUserNames.equals(oid)) {
            System.out.print("REPORT: Unknown user name.");
        } else if (SnmpConstants.usmStatsUnknownEngineIDs.equals(oid)) {
            System.out.print("REPORT: Unknown engine id.");
        } else if (SnmpConstants.usmStatsWrongDigests.equals(oid)) {
            System.out.print("REPORT: Wrong digest.");
        } else if (SnmpConstants.usmStatsDecryptionErrors.equals(oid)) {
            System.out.print("REPORT: Decryption error.");
        } else if (SnmpConstants.snmpUnknownSecurityModels.equals(oid)) {
            System.out.print("REPORT: Unknown security model.");
        } else if (SnmpConstants.snmpInvalidMsgs.equals(oid)) {
            System.out.print("REPORT: Invalid message.");
        } else if (SnmpConstants.snmpUnknownPDUHandlers.equals(oid)) {
            System.out.print("REPORT: Unknown PDU handler.");
        } else if (SnmpConstants.snmpUnavailableContexts.equals(oid)) {
            System.out.print("REPORT: Unavailable context.");
        } else if (SnmpConstants.snmpUnknownContexts.equals(oid)) {
            System.out.print("REPORT: Unknown context.");
        } else {
            System.out.print("REPORT contains unknown OID (" + oid.toString() + ").");
        }
    }

    public Object getErrorResult() {
        return this.errorResult;
    }

    public boolean hasResponse() {
        return this.hasResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(ResponseEvent responseEvent) {
        block39: {
            try {
                PDU pduResponse = responseEvent.getResponse();
                ((Snmp)responseEvent.getSource()).cancel(responseEvent.getRequest(), this);
                String remoteAddress = null;
                if (responseEvent.getPeerAddress() != null) {
                    remoteAddress = responseEvent.getPeerAddress().toString();
                    if (remoteAddress.indexOf("/") > 0) {
                        remoteAddress = remoteAddress.substring(0, remoteAddress.indexOf("/"));
                    }
                    if (this.queueId != null) {
                        // empty if block
                    }
                }
                if (pduResponse == null) {
                    this.errorResult = "Request timed out";
                    LOGGER.log(Level.FINE, " Request timed out ");
                    break block39;
                }
                if (pduResponse.getType() == -88) {
                    SnmpResponseListenerImpl snmpResponseListenerImpl = this;
                    synchronized (snmpResponseListenerImpl) {
                        this.notifyAll();
                    }
                    SnmpResponseListenerImpl.printReport(pduResponse);
                    return;
                }
                Vector variables = pduResponse.getVariableBindings();
                if (LOGGER.isLoggable(Level.FINER)) {
                    for (Object variable : variables) {
                        LOGGER.log(Level.FINER, String.format("Received response %1$s from: %2$s", variable, responseEvent.getPeerAddress()));
                    }
                }
                this.errorResult = pduResponse.getErrorStatus() == 0 ? ((VariableBinding)pduResponse.getVariableBindings().get(0)).getVariable().toString() : Integer.valueOf(pduResponse.getErrorStatus());
                HashMap<String, OIDParameterVariable> list = new HashMap<String, OIDParameterVariable>();
                for (VariableBinding varBinding : variables) {
                    this.hasResponse = true;
                    list.put(varBinding.getOid().toString(), new OIDParameterVariable(varBinding, remoteAddress));
                }
                if (this.requestMarker == null) {
                    Object variable;
                    variable = this;
                    synchronized (variable) {
                        this.notifyAll();
                    }
                    return;
                }
                OIDResponsePacket packet = new OIDResponsePacket(this.requestMarker);
                packet.setOidParameters(list);
                packet.setQueueId(this.queueId);
                if (this.deviceId == null) {
                    long ipLong = IPUtils.ipWithPortStringToLong(responseEvent.getPeerAddress().toString());
                    this.deviceId = MonitoringManager.getInstance().getDeviceId(ipLong);
                }
                packet.setDeviceId(this.deviceId);
                MonitoringMessageProcessor.getInstance().sendInfoPacket(packet, this.queueId != null);
                if (this.queueId != null) {
                    // empty if block
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
            finally {
                SnmpResponseListenerImpl snmpResponseListenerImpl = this;
                synchronized (snmpResponseListenerImpl) {
                    this.notifyAll();
                }
            }
        }
    }

    public void setDeviceId(Integer deviceId) {
        this.deviceId = deviceId;
    }

    public void setQueueId(Integer queueId) {
        this.queueId = queueId;
    }

    public void setRequestMarker(String requestMarker) {
        this.requestMarker = requestMarker;
    }
}

