/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp.devices;

import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.response.PingStatusPacket;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.MonitoringMessageProcessor;
import com.dsoft.powerpro.monitorserver.dto.DevicePingResponseDTO;
import com.dsoft.powerpro.monitorserver.dto.SnmpConfigsDTO;
import com.dsoft.powerpro.monitorserver.icmp.ICMPMonitor;
import com.dsoft.powerpro.monitorserver.snmp.PoolTaskThread;
import com.dsoft.powerpro.monitorserver.snmp.SNMPRequestMonitor;
import com.dsoft.powerpro.monitorserver.snmp.SnmpResponseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DevicesMonitoringThread
extends PoolTaskThread<DeviceOIDParameterPacket> {
    private static final Logger logger = Logger.getLogger(DevicesMonitoringThread.class.getName());
    private int pingType;
    private ICMPMonitor iCMPMonitor = null;
    private SNMPRequestMonitor sNMPtMonitor = null;

    public DevicesMonitoringThread(DeviceOIDParameterPacket packet, long timeout, int pingType) {
        super(packet, timeout);
        this.pingType = pingType;
    }

    public static String constructThreadId(DeviceOIDParameterPacket packet) {
        String id = "Device:" + packet.getDeviceId() + ":";
        if (packet.getQueueId() != null) {
            id = id + packet.getQueueId();
        }
        return id;
    }

    private void changeDeviceStatus(String status, Integer deviceId, long endTime) throws Exception {
        PingStatusPacket packet = null;
        packet = new PingStatusPacket();
        packet.setDeviceId(deviceId);
        packet.setDeviceStatus(status);
        packet.setTimeStamp(endTime);
        MonitoringMessageProcessor.getInstance().sendInfoPacket(packet, false);
    }

    private void doICMPReport() throws Exception {
        String ipAddress = ((DeviceOIDParameterPacket)this.getPacket()).getIpAddress();
        boolean isAlive = this.iCMPMonitor.isDeviceLive(ipAddress, null, null);
        long endTime = System.currentTimeMillis();
        this.processDevicePing(endTime, isAlive);
    }

    private void doSnmpReport() throws Exception {
        String ipAddress = ((DeviceOIDParameterPacket)this.getPacket()).getIpAddress();
        SnmpConfigsDTO confDto = MonitoringManager.getInstance().getDeviceSNMPConfig(((DeviceOIDParameterPacket)this.getPacket()).getDeviceId());
        boolean isAlive = false;
        try {
            isAlive = this.sNMPtMonitor.isDeviceLive(ipAddress, null, confDto);
        }
        catch (SnmpResponseException ex) {
            this.doICMPReport();
            return;
        }
        long endTime = this.sNMPtMonitor.getResponseTime();
        this.processDevicePing(endTime, isAlive);
    }

    @Override
    protected String getIdString() {
        return DevicesMonitoringThread.constructThreadId((DeviceOIDParameterPacket)this.getPacket());
    }

    private void logReport(Integer devPingRepId, Integer deviceId, long startTime, long endTime) {
        try {
            MonitoringManager.getInstance().addDevicePingResponse(devPingRepId, deviceId, startTime, endTime);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void processDevicePing(long endTime, boolean isAlive) {
        long controlTimeInterval = endTime - (this.getTimeout() + this.getTimeout() / 5L);
        try {
            DevicePingResponseDTO dto = MonitoringManager.getInstance().getDeviceLastPing(((DeviceOIDParameterPacket)this.getPacket()).getDeviceId());
            if (dto != null) {
                if (dto.getEndTime() < controlTimeInterval) {
                    if (dto.getEndTime() > controlTimeInterval - this.getTimeout()) {
                        if (!isAlive) {
                            this.changeDeviceStatus("1.3.6.1.6.3.1.1.5.1003", ((DeviceOIDParameterPacket)this.getPacket()).getDeviceId(), endTime);
                        } else {
                            this.logReport(null, ((DeviceOIDParameterPacket)this.getPacket()).getDeviceId(), endTime, endTime);
                        }
                    } else if (isAlive) {
                        this.logReport(null, ((DeviceOIDParameterPacket)this.getPacket()).getDeviceId(), endTime, endTime);
                        this.changeDeviceStatus("1.3.6.1.6.3.1.1.5.1004", ((DeviceOIDParameterPacket)this.getPacket()).getDeviceId(), endTime);
                    }
                } else if (isAlive) {
                    this.logReport(dto.getId(), ((DeviceOIDParameterPacket)this.getPacket()).getDeviceId(), dto.getStartTime(), endTime);
                } else {
                    this.changeDeviceStatus("1.3.6.1.6.3.1.1.5.1002", ((DeviceOIDParameterPacket)this.getPacket()).getDeviceId(), endTime);
                }
            } else if (isAlive) {
                this.logReport(null, ((DeviceOIDParameterPacket)this.getPacket()).getDeviceId(), endTime, endTime);
                this.changeDeviceStatus("1.3.6.1.6.3.1.1.5.1004", ((DeviceOIDParameterPacket)this.getPacket()).getDeviceId(), endTime);
            } else {
                this.logReport(null, ((DeviceOIDParameterPacket)this.getPacket()).getDeviceId(), endTime - this.getTimeout(), endTime - this.getTimeout());
                this.changeDeviceStatus("1.3.6.1.6.3.1.1.5.1002", ((DeviceOIDParameterPacket)this.getPacket()).getDeviceId(), endTime);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            if (this.pingType == 0) {
                this.iCMPMonitor = new ICMPMonitor(3000, 1);
            } else {
                this.sNMPtMonitor = new SNMPRequestMonitor((DeviceOIDParameterPacket)this.getPacket());
            }
            while (!this.isStopped()) {
                if (this.pingType == 0) {
                    this.doICMPReport();
                } else {
                    this.doSnmpReport();
                }
                try {
                    Thread.sleep(this.getTimeout());
                }
                catch (InterruptedException ex) {
                    this.stopThread();
                    return;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

