/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp.devices;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitorserver.snmp.SNMPBaseMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.Snmp;

public class IFTableMonitor
extends SNMPBaseMonitor {
    private static final Logger logger = Logger.getLogger(IFTableMonitor.class.getName());

    public IFTableMonitor() {
    }

    public IFTableMonitor(DeviceOIDParameterPacket packet) {
        super(packet);
    }

    public IFTableMonitor(int timeout, int retry) {
        super(timeout, retry);
    }

    public List<OIDParameterVariable> getIfTable() {
        ArrayList<OIDParameterVariable> arrayList;
        Snmp snmpSession = this.getSnmpSession();
        try {
            this.monitPdu.clear();
            ArrayList<String> oidsToRead = new ArrayList<String>();
            for (int idx = 7; idx < 23; ++idx) {
                oidsToRead.add("1.3.6.1.2.1.2.2.1." + idx);
            }
            ArrayList<OIDParameterVariable> result = new ArrayList<OIDParameterVariable>();
            this.getOidTableVariables(snmpSession, result::add, oidsToRead);
            arrayList = result;
        }
        catch (Exception ex) {
            try {
                try {
                    this.closeSession(snmpSession, true);
                    throw ex;
                }
                catch (Throwable throwable) {
                    this.closeSession(snmpSession);
                    throw throwable;
                }
            }
            catch (Exception ex2) {
                logger.log(Level.SEVERE, ex2.getMessage(), ex2);
                return new ArrayList<OIDParameterVariable>();
            }
        }
        this.closeSession(snmpSession);
        return arrayList;
    }

    List<OIDParameterVariable> initOIDSubtree() throws IOException {
        ArrayList<OIDParameterVariable> arrayList;
        Snmp snmpSession = this.getSnmpSession();
        try {
            ArrayList<OIDParameterVariable> result = new ArrayList<OIDParameterVariable>();
            this.getOidTableVariables(snmpSession, result::add, "1.3.6.1.2.1.2.2.1.1", "1.3.6.1.2.1.2.2.1.2", "1.3.6.1.2.1.2.2.1.3", "1.3.6.1.2.1.2.2.1.4", "1.3.6.1.2.1.2.2.1.5", "1.3.6.1.2.1.2.2.1.6");
            arrayList = result;
        }
        catch (Exception ex) {
            try {
                try {
                    this.closeSession(snmpSession, true);
                    throw ex;
                }
                catch (Throwable throwable) {
                    this.closeSession(snmpSession);
                    throw throwable;
                }
            }
            catch (Exception ex2) {
                logger.log(Level.SEVERE, ex2.getMessage(), ex2);
                return new ArrayList<OIDParameterVariable>();
            }
        }
        this.closeSession(snmpSession);
        return arrayList;
    }
}

