/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp.devices;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceRequestPacket;
import com.dsoft.powerpro.monitorserver.devices.SNMPMonitoringThread;
import com.dsoft.powerpro.monitorserver.snmp.PoolTaskThread;
import com.dsoft.powerpro.monitorserver.snmp.devices.IFTableMonitor;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IFTableMonitoringThread
extends PoolTaskThread {
    private static final Logger logger = Logger.getLogger(IFTableMonitoringThread.class.getName());

    public IFTableMonitoringThread(DeviceOIDParameterPacket packet, long timeout) {
        super(packet, timeout);
    }

    @Override
    protected String getIdString() {
        return SNMPMonitoringThread.constructThreadId((DeviceOIDParameterPacket)this.getPacket(), "ifTableThread");
    }

    @Override
    public void run() {
        try {
            this.incrementThreadExpiring(420000L);
            IFTableMonitor ifTableMonitor = new IFTableMonitor((DeviceOIDParameterPacket)this.getPacket());
            List<OIDParameterVariable> result = ifTableMonitor.initOIDSubtree();
            this.sendOidVariablePacket("IF_TABLE", ((DeviceRequestPacket)this.getPacket()).getDeviceId(), null, result, null);
            while (!this.isStopped()) {
                this.sendOidVariablePacket("IF_TABLE", ((DeviceRequestPacket)this.getPacket()).getDeviceId(), null, ifTableMonitor.getIfTable(), null);
                if (!this.isExpired()) {
                    try {
                        Thread.sleep(this.getTimeout());
                        continue;
                    }
                    catch (InterruptedException ex) {
                        this.stopThread();
                    }
                }
                break;
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

