/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp.devices;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.response.InterfaceDetails;
import com.dsoft.powerpro.monitoring.mserver.response.InterfaceStatusPacket;
import com.dsoft.powerpro.monitorserver.devices.BaseDeviceMonitoring;
import com.dsoft.powerpro.monitorserver.snmp.SNMPBaseMonitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.Snmp;

public class InterfaceStatusMonitor
extends SNMPBaseMonitor {
    private static final Logger logger = Logger.getLogger(InterfaceStatusMonitor.class.getName());

    public InterfaceStatusMonitor() {
    }

    public InterfaceStatusMonitor(DeviceOIDParameterPacket packet) {
        super(packet);
    }

    public InterfaceStatusMonitor(int timeout, int retry) {
        super(timeout, retry);
    }

    public InterfaceStatusPacket getInterfaceStatus() {
        InterfaceStatusPacket interfaceStatusPacket;
        Snmp snmpSession = this.getSnmpSession();
        try {
            this.monitPdu.clear();
            interfaceStatusPacket = this.readInterfaceIOStats(snmpSession, null);
        }
        catch (Exception ex) {
            try {
                try {
                    this.closeSession(snmpSession, true);
                    throw ex;
                }
                catch (Throwable throwable) {
                    this.closeSession(snmpSession);
                    throw throwable;
                }
            }
            catch (Exception ex2) {
                logger.log(Level.SEVERE, ex2.getMessage(), ex2);
                return null;
            }
        }
        this.closeSession(snmpSession);
        return interfaceStatusPacket;
    }

    protected InterfaceStatusPacket readInterfaceIOStats(Snmp snmpSession, int[] interfaceTypes) throws IOException {
        Map<String, OIDParameterVariable> oid = this.getOidTableVariables(snmpSession, "1.3.6.1.2.1.2.2.1.1", "1.3.6.1.2.1.2.2.1.2", "1.3.6.1.2.1.2.2.1.3", "1.3.6.1.2.1.2.2.1.8", "1.3.6.1.2.1.2.2.1.7", "1.3.6.1.2.1.2.2.1.10", "1.3.6.1.2.1.2.2.1.14", "1.3.6.1.2.1.2.2.1.16", "1.3.6.1.2.1.2.2.1.20", "1.3.6.1.2.1.2.2.1.13", "1.3.6.1.2.1.2.2.1.19", "1.3.6.1.2.1.31.1.1.1.6", "1.3.6.1.2.1.31.1.1.1.10");
        InterfaceStatusPacket monitorPacket = null;
        if (oid != null && !oid.isEmpty()) {
            monitorPacket = new InterfaceStatusPacket(this.packet.getMarker());
            HashSet<Integer> indexToProcess = new HashSet<Integer>();
            for (String paramName : oid.keySet()) {
                if (!paramName.startsWith("1.3.6.1.2.1.2.2.1.1")) continue;
                int index = oid.get(paramName).getVariableBinding().getOid().last();
                indexToProcess.add(index);
            }
            for (Integer index : indexToProcess) {
                InterfaceDetails id = InterfaceDetails.builder().index(index).description(BaseDeviceMonitoring.getString(oid, "1.3.6.1.2.1.2.2.1.2", index)).adminStatus(BaseDeviceMonitoring.getInt(oid, "1.3.6.1.2.1.2.2.1.7", index)).operationalStatus(BaseDeviceMonitoring.getInt(oid, "1.3.6.1.2.1.2.2.1.8", index)).type(BaseDeviceMonitoring.getInt(oid, "1.3.6.1.2.1.2.2.1.3", index)).inDiscards(BaseDeviceMonitoring.getLong(oid, "1.3.6.1.2.1.2.2.1.13", index)).outDiscards(BaseDeviceMonitoring.getLong(oid, "1.3.6.1.2.1.2.2.1.19", index)).inErrors(BaseDeviceMonitoring.getLong(oid, "1.3.6.1.2.1.2.2.1.14", index)).outErrors(BaseDeviceMonitoring.getLong(oid, "1.3.6.1.2.1.2.2.1.20", index)).inOctets(BaseDeviceMonitoring.getLong(oid, "1.3.6.1.2.1.31.1.1.1.6", "1.3.6.1.2.1.2.2.1.10", index)).outOctets(BaseDeviceMonitoring.getLong(oid, "1.3.6.1.2.1.31.1.1.1.10", "1.3.6.1.2.1.2.2.1.16", index)).build();
                if (interfaceTypes != null && Arrays.binarySearch(interfaceTypes, id.getType()) == -1) continue;
                monitorPacket.getInterfaceDetails().add(id);
            }
        }
        return monitorPacket;
    }
}

