/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp.devices;

import com.dsoft.powerpro.internet.mserver.InfoPacket;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.request.DeviceRequestPacket;
import com.dsoft.powerpro.monitoring.mserver.response.InterfaceStatusPacket;
import com.dsoft.powerpro.monitorserver.MonitoringMessageProcessor;
import com.dsoft.powerpro.monitorserver.snmp.PoolTaskThread;
import com.dsoft.powerpro.monitorserver.snmp.devices.InterfaceStatusMonitor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InterfaceStatusMonitoringThread
extends PoolTaskThread {
    private static final Logger logger = Logger.getLogger(InterfaceStatusMonitoringThread.class.getName());

    public InterfaceStatusMonitoringThread(DeviceOIDParameterPacket packet, long timeout) {
        super(packet, timeout);
    }

    public static String constructThreadId(DeviceOIDParameterPacket packet, String explicitThrId) {
        String id = "Monitor:" + packet.getDeviceId() + ":";
        id = id + explicitThrId + ":";
        if (packet.getQueueId() != null) {
            id = id + packet.getQueueId();
        }
        return id;
    }

    @Override
    protected String getIdString() {
        return InterfaceStatusMonitoringThread.constructThreadId((DeviceOIDParameterPacket)this.getPacket(), "InterfaceStatusThread");
    }

    @Override
    public void run() {
        try {
            this.incrementThreadExpiring(420000L);
            InterfaceStatusMonitor snmpMonitor = new InterfaceStatusMonitor((DeviceOIDParameterPacket)this.getPacket());
            InterfaceStatusPacket monitorPacket = snmpMonitor.getInterfaceStatus();
            if (monitorPacket != null) {
                monitorPacket.setDeviceId(((DeviceRequestPacket)this.getPacket()).getDeviceId());
                monitorPacket.setQueueId(((InfoPacket)this.getPacket()).getQueueId());
                MonitoringMessageProcessor.getInstance().sendInfoPacket(monitorPacket, ((InfoPacket)this.getPacket()).getQueueId() != null);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

