/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.syslog;

import com.dsoft.powerpro.internet.mserver.queue.MessageQueue;
import com.dsoft.powerpro.syslog.server.MessagePacket;
import com.dsoft.powerpro.syslog.server.SysLogPacketListener;
import com.dsoft.powerpro.syslog.server.SyslogMessageParser;
import com.dsoft.powerpro.syslog.server.SyslogPacketReceiver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class ProcessPacketThread
implements SysLogPacketListener,
Runnable {
    private static final Logger logger = Logger.getLogger(ProcessPacketThread.class.getName());
    private final List<MessagePacket> messages = new ArrayList<MessagePacket>();
    private Thread processThread;
    private MessageQueue messageQueue;
    private Map<String, String> leaseMap = new HashMap<String, String>();

    public ProcessPacketThread(ThreadGroup threadGroup, SyslogPacketReceiver receiver, MessageQueue messageQueue) {
        this.processThread = new Thread(threadGroup, this, "Syslog message process thread");
        this.messageQueue = messageQueue;
        receiver.addListener(this);
    }

    @PostConstruct
    public void start() {
        this.processThread.start();
    }

    @PreDestroy
    public void stop() {
        this.processThread.interrupt();
    }

    public String getIpByMac(String mac) {
        return mac != null ? this.leaseMap.get(mac.toUpperCase()) : null;
    }

    private void processMessage(MessagePacket message) throws Exception {
        Map<String, Object> propertyMap = SyslogMessageParser.parseMessage(message);
        String mac = (String)propertyMap.get("mac:");
        if (mac != null) {
            mac = mac.toUpperCase();
            this.leaseMap.put(mac, (String)propertyMap.get("ip:"));
        }
        this.messageQueue.postMessage(propertyMap, 0, -1L, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPacket(MessagePacket packet) {
        List<MessagePacket> list = this.messages;
        synchronized (list) {
            this.messages.add(packet);
            this.messages.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (Thread.currentThread().isInterrupted()) {
            logger.info("Exiting from Service");
            return;
        }
        block8: while (true) {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    MessagePacket message = null;
                    List<MessagePacket> list = this.messages;
                    synchronized (list) {
                        if (this.messages.isEmpty()) {
                            this.messages.wait(100L);
                        } else {
                            message = this.messages.remove(0);
                        }
                    }
                    if (message == null) continue;
                    try {
                        this.processMessage(message);
                        continue block8;
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "Error while processing message!", ex);
                        if (ex instanceof IOException) {
                            throw (IOException)ex;
                        }
                        if (!(ex instanceof InterruptedException)) continue;
                        throw (InterruptedException)ex;
                        return;
                    }
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Error while waiting for communication!", ex);
                return;
            }
            catch (InterruptedException e) {
                logger.info("Exiting from process messages thread");
                return;
            }
        }
    }
}

