/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.network.client;

import com.dsoft.framework.client.TimeInterval;
import com.dsoft.powerpro.network.client.NetworkDeviceRowFilter;
import com.dsoft.powerpro.network.client.ServicePriority;
import com.dsoft.powerpro.network.client.dto.NetDeviceRowsDto;
import java.util.Collection;
import javax.ejb.FinderException;

public class NetworkDeviceRowHelper {
    private NetworkDeviceRowFilter filter;
    private ServicePriority servicePriority;
    private NetDeviceRowsDto activeDevRow = null;
    private NetDeviceRowsDto mainDevRow = null;

    public NetworkDeviceRowHelper(NetworkDeviceRowFilter filter, ServicePriority servicePriority) {
        this.filter = filter;
        this.servicePriority = servicePriority;
    }

    public NetDeviceRowsDto getActiveDevRow() {
        return this.activeDevRow;
    }

    public NetDeviceRowsDto getMainDevRow() {
        return this.mainDevRow;
    }

    public NetworkDeviceRowHelper processNetDeviceRows(Collection<NetDeviceRowsDto> deviceRows) throws Exception {
        for (NetDeviceRowsDto devRow : deviceRows) {
            if (this.filter != null && this.filter.ignore(devRow)) continue;
            if (devRow.isValid()) {
                int activePriority;
                if (devRow.isExtension() && devRow.isOverride()) {
                    if (this.activeDevRow != null) continue;
                    this.activeDevRow = devRow;
                    continue;
                }
                if (devRow.isExtension()) continue;
                if (this.mainDevRow == null) {
                    this.mainDevRow = devRow;
                } else {
                    int mainPrio;
                    int newPrio = this.getPriority(devRow);
                    if (newPrio < (mainPrio = this.getPriority(this.mainDevRow))) {
                        this.mainDevRow = devRow;
                    }
                }
                if (this.activeDevRow == null) {
                    this.activeDevRow = devRow;
                    continue;
                }
                int currentPriority = this.getPriority(devRow);
                if (currentPriority >= (activePriority = this.getPriority(this.activeDevRow))) continue;
                this.activeDevRow = devRow;
                continue;
            }
            TimeInterval currentInterval = devRow.getCurrentInterval();
            if (this.mainDevRow == null && currentInterval != null) {
                this.mainDevRow = devRow;
                continue;
            }
            if (currentInterval == null || this.mainDevRow.getCurrentInterval().getBegin() >= currentInterval.getBegin()) continue;
            this.mainDevRow = devRow;
        }
        return this;
    }

    private int getPriority(NetDeviceRowsDto devRow) throws FinderException {
        return this.servicePriority != null ? this.servicePriority.getServicePriority(devRow.getServiceId()) : 0;
    }
}

