/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.network.client.dto;

import com.dsoft.framework.client.TimeInterval;
import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.base.IntegerIdDTO;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.powerpro.network.client.dto.NetworkDeviceDto;
import com.dsoft.powerpro.servicebase.client.dto.BaseServiceDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

@ServerLoader(value="PowerPro/NetDeviceRowsLoader/local")
public class NetDeviceRowsDto
extends IntegerIdDTO {
    private static final long serialVersionUID = -7888203855299839494L;
    private static final String INTERVALS = "intervals";
    private String rowIdentifier;
    private String parentRowIdentifier;
    private final TreeSet<TimeInterval> intervals = new TreeSet();
    private boolean extension = false;
    private Integer overrideLevel = 0;
    private static final String NETWORK_DEVICE = "networkDevice";
    private static final String SERVICE = "service";

    public NetDeviceRowsDto() {
        this.registerProperty(NetworkDeviceDto.class, NETWORK_DEVICE, false);
        this.registerProperty(BaseServiceDTO.class, SERVICE, false);
    }

    public NetDeviceRowsDto(Integer deviceId, String rowIdentifier, Integer serviceId) {
        this.registerProperty(NetworkDeviceDto.class, NETWORK_DEVICE, false);
        this.registerProperty(BaseServiceDTO.class, SERVICE, false);
        this.setDeviceId(deviceId);
        this.setRowIdentifier(rowIdentifier);
        this.setServiceId(serviceId);
    }

    public void addInterval(TimeInterval interval) {
        this.intervals.add(interval);
        this.setModified(INTERVALS);
    }

    public void addIntervals(Collection<TimeInterval> intervals) {
        this.intervals.addAll(intervals);
        this.setModified(INTERVALS);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NetDeviceRowsDto)) {
            return false;
        }
        NetDeviceRowsDto that = (NetDeviceRowsDto)obj;
        if (!(that.getDeviceId() != null ? that.getDeviceId().equals(this.getDeviceId()) : this.getDeviceId() == null)) {
            return false;
        }
        if (!(that.rowIdentifier != null ? that.rowIdentifier.equals(this.rowIdentifier) : this.rowIdentifier == null)) {
            return false;
        }
        return that.getServiceId() == null ? this.getServiceId() == null : that.getServiceId().equals(this.getServiceId());
    }

    public TimeInterval getCurrentInterval() {
        return this.getCurrentInterval(System.currentTimeMillis());
    }

    public TimeInterval getNextInterval(TimeInterval interval) {
        TimeInterval next = null;
        for (TimeInterval ti : this.intervals) {
            if (ti.getBegin() < interval.getEnd()) continue;
            if (next == null) {
                next = ti;
                continue;
            }
            if (next.getBegin() <= ti.getBegin()) continue;
            next = ti;
        }
        return next;
    }

    public TimeInterval getCurrentInterval(long checkTime) {
        TimeInterval lastBefore = null;
        TimeInterval firstAfter = null;
        TimeInterval atEndInterval = null;
        for (TimeInterval interval : this.intervals) {
            if (interval.contains(checkTime)) {
                if (interval.getEnd() == checkTime) {
                    atEndInterval = interval;
                    continue;
                }
                return new TimeInterval(interval);
            }
            if (interval.getEnd() < checkTime) {
                lastBefore = interval;
            }
            if (interval.getBegin() <= checkTime || firstAfter != null) continue;
            firstAfter = interval;
        }
        if (atEndInterval != null) {
            return new TimeInterval(atEndInterval);
        }
        if (firstAfter != null) {
            return new TimeInterval(firstAfter);
        }
        return lastBefore != null ? new TimeInterval(lastBefore) : null;
    }

    public Integer getDeviceId() {
        return (Integer)this.getObjectValue(NETWORK_DEVICE);
    }

    public List<TimeInterval> getIntervals() {
        return new ArrayList<TimeInterval>(this.intervals);
    }

    public <T extends NetworkDeviceDto> T getNetDeviceDto() throws DTOFindException {
        return (T)((NetworkDeviceDto)this.getPropertyValue(NETWORK_DEVICE));
    }

    public String getParentRowIdentifier() {
        return this.parentRowIdentifier;
    }

    public String getRowIdentifier() {
        return this.rowIdentifier;
    }

    public BaseServiceDTO getService() throws DTOFindException {
        return (BaseServiceDTO)this.getPropertyValue(SERVICE);
    }

    public Integer getServiceId() {
        return (Integer)this.getObjectValue(SERVICE);
    }

    @Override
    public int hashCode() {
        int result = 37;
        if (this.rowIdentifier != null) {
            result += this.rowIdentifier.hashCode() * 17;
        }
        if (this.getDeviceId() != null) {
            result += this.getDeviceId().hashCode() * 17;
        }
        if (this.getServiceId() != null) {
            result += this.getServiceId().hashCode() * 17;
        }
        return result;
    }

    public boolean hasIntervalAfter(long checkTime) {
        for (TimeInterval interval : this.intervals) {
            if (interval.getBegin() <= checkTime) continue;
            return true;
        }
        return false;
    }

    public boolean isExtension() {
        return this.extension;
    }

    public Integer getOverrideLevel() {
        return this.overrideLevel;
    }

    public boolean isOverride() {
        return this.overrideLevel != null && this.overrideLevel > 0;
    }

    public boolean isValid() {
        return this.isValid(System.currentTimeMillis());
    }

    public boolean isValid(long checkTime) {
        for (TimeInterval interval : this.intervals) {
            if (!interval.contains(checkTime)) continue;
            return true;
        }
        return false;
    }

    public void removeInterval(TimeInterval devRowInterval) {
        this.intervals.remove(devRowInterval);
        this.setModified(INTERVALS);
    }

    public void setDeviceId(Integer deviceId) {
        this.putObjectValue(NETWORK_DEVICE, deviceId);
    }

    public void setExtension(boolean extension) {
        this.setModified(this.extension, extension, "extension");
        this.extension = extension;
    }

    public void setParentRowIdentifier(String parentRowIdentifier) {
        this.setModified(this.parentRowIdentifier, parentRowIdentifier, "parentRowIdentifier");
        this.parentRowIdentifier = parentRowIdentifier;
    }

    public void setRowIdentifier(String rowIdentifier) {
        this.setModified(this.rowIdentifier, rowIdentifier, "rowIdentifier");
        this.rowIdentifier = rowIdentifier;
    }

    public void setOverrideLevel(Integer overrideLevel) {
        this.setModified(this.overrideLevel, overrideLevel, "overrideLevel");
        this.overrideLevel = overrideLevel;
    }

    public void setServiceId(Integer serviceId) {
        this.putObjectValue(SERVICE, serviceId);
    }

    @Override
    public String toString() {
        String returnString = "";
        returnString = returnString + this.getDeviceId();
        returnString = returnString + ", " + this.rowIdentifier;
        returnString = returnString + ", " + this.getServiceId();
        return returnString;
    }

    public boolean isSerializable() {
        return !this.isOwned();
    }

    public static NetDeviceRowsDto requestActiveDeviceRow(Collection<NetDeviceRowsDto> devRows) {
        NetDeviceRowsDto activeDevRow = null;
        for (NetDeviceRowsDto devRowDto : devRows) {
            if (devRowDto.isExtension()) continue;
            if (devRowDto.isValid()) {
                activeDevRow = devRowDto;
                continue;
            }
            if (activeDevRow == null) {
                activeDevRow = devRowDto;
                continue;
            }
            if (activeDevRow.getCurrentInterval().getEnd() >= devRowDto.getCurrentInterval().getEnd()) continue;
            activeDevRow = devRowDto;
        }
        return activeDevRow;
    }
}

