/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.network.client.dto;

import com.dsoft.framework.client.TimeInterval;
import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.base.BaseDTO;
import com.dsoft.framework.client.base.DTOList;
import com.dsoft.framework.client.base.DTOListImpl;
import com.dsoft.framework.client.base.DTOSet;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.client.history.HistoryDTO;
import com.dsoft.powerpro.address.client.dto.AddressDTO;
import com.dsoft.powerpro.network.client.dto.NetDeviceRowsDto;
import com.dsoft.powerpro.network.client.dto.NetworkDeviceTypeRegisterDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ServerLoader(value="PowerPro/NetworkDeviceLoader/local")
public class NetworkDeviceDto
extends HistoryDTO
implements Comparable<NetworkDeviceDto> {
    private static final long serialVersionUID = 874528347818773421L;
    private static final String DeviceTypeProperty = "DeviceTypeProperty";
    public static final String LOCATION = "location";
    private String selectedRowConfiguration;
    private Integer selectedServiceId;
    private String name;
    private String description;
    private boolean ownAddress;
    private boolean forInternalUse;
    private boolean infrastructureDevice;
    private String serialNumber;
    private final DTOSet<NetworkDeviceDto, Integer> dependantDevices = new DTOSet(NetworkDeviceDto.class, this);
    private final Map<String, DTOList<NetDeviceRowsDto, Integer>> deviceRowsMap = new LinkedHashMap<String, DTOList<NetDeviceRowsDto, Integer>>();
    private Collection<Integer> devRowIds = null;
    private static final Comparator<NetDeviceRowsDto> OVERRIDES_COMPARATOR = new Comparator<NetDeviceRowsDto>(){

        @Override
        public int compare(NetDeviceRowsDto o1, NetDeviceRowsDto o2) {
            return o1.getOverrideLevel().compareTo(o2.getOverrideLevel());
        }
    };

    public NetworkDeviceDto() {
        this.registerProperty(AddressDTO.class, LOCATION);
        this.registerProperty(NetworkDeviceTypeRegisterDTO.class, DeviceTypeProperty, false);
    }

    public void addDeviceRow(NetDeviceRowsDto deviceRowDto) {
        this.loadDataIntoMap();
        DTOList<NetDeviceRowsDto, Integer> deviceRows = this.deviceRowsMap.get(deviceRowDto.getRowIdentifier());
        if (deviceRows == null) {
            deviceRows = new DTOListImpl<NetDeviceRowsDto, Integer>((Class)NetDeviceRowsDto.class, (BaseDTO)this, true);
            this.deviceRowsMap.put(deviceRowDto.getRowIdentifier(), deviceRows);
        } else {
            for (NetDeviceRowsDto devRowDto : deviceRows) {
                if (devRowDto.getId() != null || !devRowDto.getServiceId().equals(deviceRowDto.getServiceId())) continue;
                deviceRows.remove(devRowDto);
                break;
            }
        }
        deviceRows.add(deviceRowDto);
    }

    public void addDeviceRows(Collection<Integer> devRowIds) {
        this.devRowIds = devRowIds;
    }

    @Override
    public int compareTo(NetworkDeviceDto o) {
        return this.name.compareTo(o.name);
    }

    public boolean containsDeviceRowInfo(String rowIdentifier, Integer serviceId) {
        return this.getFirstInterval(rowIdentifier, serviceId, false, System.currentTimeMillis()) != null;
    }

    private List<NetDeviceRowsDto> filterValidDeviceRows(List<NetDeviceRowsDto> collection, long timeStamp, boolean includeFuture) {
        ArrayList<NetDeviceRowsDto> activeDevRows = new ArrayList<NetDeviceRowsDto>();
        for (NetDeviceRowsDto devRowDto : collection) {
            if (!devRowDto.isValid(timeStamp) && (!includeFuture || !devRowDto.hasIntervalAfter(timeStamp))) continue;
            activeDevRows.add(devRowDto);
        }
        return activeDevRows;
    }

    public Integer getAddressId() {
        return (Integer)this.getObjectValue(LOCATION);
    }

    public List<NetDeviceRowsDto> getAllDeviceRowInfo(String rowIdentifier) {
        return this.getAllDeviceRowInfo(rowIdentifier, System.currentTimeMillis(), false);
    }

    public List<NetDeviceRowsDto> getAllDeviceRowInfo(String rowIdentifier, long timeStamp, boolean onlyActive) {
        this.loadDataIntoMap();
        DTOList<NetDeviceRowsDto, Integer> devRowsList = this.deviceRowsMap.get(rowIdentifier);
        return this.filterDeviceRowsList(timeStamp, onlyActive, devRowsList);
    }

    public List<NetDeviceRowsDto> getAllDeviceRowInfo(boolean onlyActive) {
        return this.getAllDeviceRowInfo(System.currentTimeMillis(), onlyActive);
    }

    public List<NetDeviceRowsDto> getAllDeviceRowInfo(long timeStamp, boolean onlyActive) {
        return this.filterDeviceRowsList(timeStamp, onlyActive, this.getAllDeviceRowInfo());
    }

    private List<NetDeviceRowsDto> filterDeviceRowsList(long timeStamp, boolean onlyActive, List<NetDeviceRowsDto> devRowsList) {
        ArrayList<NetDeviceRowsDto> result = new ArrayList<NetDeviceRowsDto>();
        if (devRowsList == null) {
            return result;
        }
        ArrayList<NetDeviceRowsDto> devRows = new ArrayList<NetDeviceRowsDto>(devRowsList);
        ArrayList<NetDeviceRowsDto> extensions = new ArrayList<NetDeviceRowsDto>();
        ArrayList<NetDeviceRowsDto> overrides = new ArrayList<NetDeviceRowsDto>();
        for (NetDeviceRowsDto devRowDto : devRows) {
            if (devRowDto.isExtension()) {
                if (!devRowDto.isValid(timeStamp)) continue;
                if (devRowDto.isOverride()) {
                    overrides.add(devRowDto);
                    continue;
                }
                extensions.add(devRowDto);
                continue;
            }
            if (!onlyActive) {
                if (devRowDto.isValid(timeStamp)) {
                    result.add(0, devRowDto);
                    continue;
                }
                result.add(devRowDto);
                continue;
            }
            if (!devRowDto.isValid(timeStamp)) continue;
            result.add(devRowDto);
        }
        if (!overrides.isEmpty()) {
            Collections.sort(overrides, OVERRIDES_COMPARATOR);
            for (NetDeviceRowsDto devRowDto : overrides) {
                result.add(0, devRowDto);
            }
        }
        result.addAll(extensions);
        return result;
    }

    public List<NetDeviceRowsDto> getAllDeviceRowInfo() {
        this.loadDataIntoMap();
        ArrayList<NetDeviceRowsDto> allDevRowsList = new ArrayList<NetDeviceRowsDto>();
        for (DTOList<NetDeviceRowsDto, Integer> devRows : this.deviceRowsMap.values()) {
            allDevRowsList.addAll(devRows);
        }
        return allDevRowsList;
    }

    public String getDefaultNamePrefix() {
        return "network device";
    }

    public DTOSet<NetworkDeviceDto, Integer> getDependantDevices() {
        return this.dependantDevices;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getDeviceParameters(NetDeviceRowsDto deviceRowDto) {
        return null;
    }

    public NetDeviceRowsDto getDeviceRowInfo(String rowIdentifier, Integer serviceId) {
        this.loadDataIntoMap();
        DTOList<NetDeviceRowsDto, Integer> devRows = this.deviceRowsMap.get(rowIdentifier);
        NetDeviceRowsDto currentDevRowDto = null;
        if (devRows != null) {
            TimeInterval lastInterval = null;
            for (NetDeviceRowsDto devRowDto : devRows) {
                if (serviceId == null) {
                    if (devRowDto.getCurrentInterval(System.currentTimeMillis()) == null || devRowDto.isExtension() || currentDevRowDto != null && (currentDevRowDto.getCurrentInterval() == null || currentDevRowDto.getCurrentInterval().getBegin() < lastInterval.getBegin())) continue;
                    currentDevRowDto = devRowDto;
                    lastInterval = currentDevRowDto.getCurrentInterval();
                    continue;
                }
                if (!devRowDto.getServiceId().equals(serviceId)) continue;
                return devRowDto;
            }
        }
        return currentDevRowDto;
    }

    public Set<String> getRowIdentifiers() {
        return this.deviceRowsMap.keySet();
    }

    public DTOList<NetDeviceRowsDto, Integer> getDeviceRowsList() {
        this.loadDataIntoMap();
        DTOListImpl<NetDeviceRowsDto, Integer> allDevRowsList = new DTOListImpl<NetDeviceRowsDto, Integer>((Class)NetDeviceRowsDto.class);
        for (DTOList<NetDeviceRowsDto, Integer> devRows : this.deviceRowsMap.values()) {
            allDevRowsList.addAllId(devRows.getAllId());
        }
        return allDevRowsList;
    }

    public NetworkDeviceTypeRegisterDTO getDeviceType() throws DTOFindException {
        return (NetworkDeviceTypeRegisterDTO)this.getPropertyValue(DeviceTypeProperty);
    }

    public Integer getDeviceTypeId() {
        return (Integer)this.getObjectValue(DeviceTypeProperty);
    }

    public TimeInterval getFirstInterval(String rowIdentifier, Integer serviceId, boolean onlyActive, long timeStamp) {
        List<NetDeviceRowsDto> devRows = this.getAllDeviceRowInfo(rowIdentifier, timeStamp, onlyActive);
        for (NetDeviceRowsDto devRowDto : devRows) {
            if (!(serviceId != null ? devRowDto.getServiceId().equals(serviceId) : !devRowDto.isExtension())) continue;
            return devRowDto.getCurrentInterval(timeStamp);
        }
        return null;
    }

    public AddressDTO getLocation() throws DTOFindException {
        return (AddressDTO)this.getPropertyValue(LOCATION);
    }

    public String getName() {
        return this.name;
    }

    public NetDeviceRowsDto getSelectedConfiguration() {
        return this.getDeviceRowInfo(this.selectedRowConfiguration, this.selectedServiceId);
    }

    public List<NetDeviceRowsDto> getValidDeviceRows(long timeStamp, boolean includeFuture) {
        return this.filterValidDeviceRows(this.getAllDeviceRowInfo(), timeStamp, includeFuture);
    }

    public List<NetDeviceRowsDto> getValidDeviceRows(String rowIdentifier, long timeStamp, boolean includeFuture) {
        return this.filterValidDeviceRows(this.getAllDeviceRowInfo(rowIdentifier), timeStamp, includeFuture);
    }

    public boolean isForInternalUse() {
        return this.forInternalUse;
    }

    public boolean isInfrastructureDevice() {
        return this.infrastructureDevice;
    }

    public boolean isNewDevice() {
        return this.getId() == null;
    }

    public boolean isOwnAddress() {
        return this.ownAddress;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    private void loadDataIntoMap() {
        if (this.devRowIds != null) {
            DTOListImpl deviceRows = new DTOListImpl(NetDeviceRowsDto.class);
            deviceRows.addAllId(this.devRowIds);
            this.devRowIds = null;
            this.deviceRowsMap.clear();
            for (NetDeviceRowsDto devRowDto : deviceRows) {
                this.addDeviceRow(devRowDto);
            }
        }
    }

    public void setAddressId(Integer addressId) {
        this.putObjectValue(LOCATION, addressId);
    }

    public void setDescription(String description) {
        this.setModified(this.description, description, "description");
        this.description = description;
    }

    public void setDeviceTypeId(Integer deviceTypeId) {
        this.putObjectValue(DeviceTypeProperty, deviceTypeId);
    }

    public void setForInternalUse(boolean internalUse) {
        this.setModified(this.forInternalUse, internalUse, "forInternalUse");
        this.forInternalUse = internalUse;
    }

    public void setInfrastructureDevice(boolean infrastructureDevice) {
        this.setModified(this.infrastructureDevice, infrastructureDevice, "infrastructureDevice");
        this.infrastructureDevice = infrastructureDevice;
    }

    public void setLocation(AddressDTO location) {
        this.setProperty(LOCATION, location);
    }

    public void setName(String name) {
        this.setModified(this.name, name, "name");
        this.name = name;
    }

    public void setOwnAddress(boolean ownAddress) {
        this.setModified(this.ownAddress, ownAddress, "ownAddress");
        this.ownAddress = ownAddress;
    }

    public void setSerialNumber(String serialNumber) {
        this.setModified(this.serialNumber, serialNumber, "serialNumber");
        this.serialNumber = serialNumber;
    }

    public void setSelectedConfiguration(String rowIdentifier) {
        this.selectedRowConfiguration = rowIdentifier;
        this.selectedServiceId = null;
    }

    public void setSelectedConfiguration(String rowIdentifier, Integer serviceId) {
        this.selectedRowConfiguration = rowIdentifier;
        this.selectedServiceId = serviceId;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public <T extends NetworkDeviceDto> boolean isSameDevice(T networkDeviceDto) {
        return networkDeviceDto != null && networkDeviceDto.getClass() == this.getClass() && Objects.equals(this.getId(), networkDeviceDto.getId());
    }
}

