/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.network.client.dto;

import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.base.BaseDTO;
import com.dsoft.framework.client.base.DTOList;
import com.dsoft.framework.client.base.DTOListImpl;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.client.history.HistoryDTO;
import com.dsoft.powerpro.address.client.dto.AddressDTO;

@ServerLoader(value="PowerPro/NetworkSegmentDTOLoader/local")
public class NetworkSegmentDTO
extends HistoryDTO {
    private static final long serialVersionUID = -5861708925592999028L;
    private static final String LOW_LEVEL_PARENT = "lowLevelParent";
    private static final String PARENT_SEGMENT = "parentSegment";
    public static final Integer PHYSICAL_SEGMENT = 1;
    public static final Integer LOGICAL_LINK_SEGMENT_LAYER_2 = 2;
    public static final Integer NETWORK_SEGMENT_LEAYER_3 = 3;
    public static final Integer TRANSPORT_SEGMENT = 4;
    public static final Integer PRESENTATION_SEGMENT = 5;
    public static final Integer SESSION_SEGMENT = 6;
    public static final Integer APPLICATION_SEGMENT = 7;
    private String description;
    private String name;
    private Integer segmentType;
    private Integer subType;
    private DTOList<NetworkSegmentDTO, Integer> subSegments = new DTOListImpl<NetworkSegmentDTO, Integer>((Class)NetworkSegmentDTO.class);
    private Integer parentSegmentId;
    private Integer lowLevelParentId;
    private DTOList<AddressDTO, Integer> controlPoints = new DTOListImpl<AddressDTO, Integer>((Class)AddressDTO.class, (BaseDTO)this, true);

    public NetworkSegmentDTO() {
        this.registerProperty(NetworkSegmentDTO.class, PARENT_SEGMENT, false);
        this.registerProperty(NetworkSegmentDTO.class, LOW_LEVEL_PARENT, false);
    }

    public DTOList<AddressDTO, Integer> getControlPoints() {
        return this.controlPoints;
    }

    public String getDescription() {
        return this.description;
    }

    public NetworkSegmentDTO getLowLevelParent() throws DTOFindException {
        return (NetworkSegmentDTO)this.getPropertyValue(LOW_LEVEL_PARENT, this.lowLevelParentId);
    }

    public Integer getLowLevelParentId() {
        return this.lowLevelParentId;
    }

    public String getName() {
        return this.name;
    }

    public NetworkSegmentDTO getParentSegment() throws DTOFindException {
        return (NetworkSegmentDTO)this.getPropertyValue(PARENT_SEGMENT, this.parentSegmentId);
    }

    public Integer getParentSegmentId() {
        return this.parentSegmentId;
    }

    public Integer getSegmentType() {
        return this.segmentType;
    }

    public DTOList<NetworkSegmentDTO, Integer> getSubSegments() {
        return this.subSegments;
    }

    public Integer getSubType() {
        return this.subType;
    }

    public void setDescription(String description) {
        this.setModified(this.description, description, "description");
        this.description = description;
    }

    public void setLowLevelParentId(Integer lowLevelParentId) {
        if (this.setModified(this.lowLevelParentId, lowLevelParentId, LOW_LEVEL_PARENT)) {
            this.removeProperty(LOW_LEVEL_PARENT, this.lowLevelParentId);
        }
        this.lowLevelParentId = lowLevelParentId;
    }

    public void setName(String name) {
        this.setModified(this.name, name, "name");
        this.name = name;
    }

    public void setParentSegmentId(Integer parentSegmentId) {
        if (this.setModified(this.parentSegmentId, parentSegmentId, PARENT_SEGMENT)) {
            this.removeProperty(PARENT_SEGMENT, this.parentSegmentId);
        }
        this.parentSegmentId = parentSegmentId;
    }

    public void setSegmentType(Integer segmentType) {
        this.setModified(this.segmentType, segmentType, "segmentType");
        this.segmentType = segmentType;
    }

    public void setSubType(Integer subType) {
        this.setModified(this.subType, subType, "subType");
        this.subType = subType;
    }

    @Override
    public String toString() {
        return "[name:" + this.name + "segmentType:" + this.segmentType + "subType:" + this.subType + "]";
    }
}

