/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.servicebase.client;

import com.dsoft.powerpro.servicebase.client.IMessenger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultOperationMessenger
implements IMessenger,
Serializable {
    public static final String MESSAGE_SOURCE_OPERATION = "@@@MESSAGE_SOURCE_OPERATION@@@";
    private Map<Source, List<Message>> messagesMap = new HashMap<Source, List<Message>>();
    private List<Source> sources = new ArrayList<Source>();
    private Source currentSource;
    private int messageIndex = 0;

    @Override
    public void setMessageSource(String sourceType, String sourceName) {
        Source src = new Source();
        src.name = sourceName;
        src.type = sourceType;
        List<Message> messages = this.messagesMap.get(src);
        if (messages == null) {
            messages = new ArrayList<Message>();
            this.messagesMap.put(src, messages);
            this.sources.add(src);
        }
        this.currentSource = src;
    }

    @Override
    public void postMessage(int messageType, String message, Object info) {
        assert (this.currentSource != null);
        Message msg = new Message(messageType, message, info, this.messageIndex++);
        this.messagesMap.get(this.currentSource).add(msg);
    }

    @Override
    public int getMessageSourceCount() {
        return this.messagesMap.size();
    }

    @Override
    public String getSourceType(int sourceIndex) {
        return this.sources.get((int)sourceIndex).type;
    }

    @Override
    public String getSourceName(int sourceIndex) {
        return this.sources.get((int)sourceIndex).name;
    }

    @Override
    public int getSourceMessageCount(int sourceIndex) {
        return this.messagesMap.get(this.sources.get(sourceIndex)).size();
    }

    @Override
    public int getMessageType(int sourceIndex, int messageIndex) {
        Source s = this.sources.get(sourceIndex);
        return this.messagesMap.get((Object)s).get((int)messageIndex).type;
    }

    @Override
    public String getMessage(int sourceIndex, int messageIndex) {
        Source s = this.sources.get(sourceIndex);
        return this.messagesMap.get((Object)s).get((int)messageIndex).message;
    }

    @Override
    public Object getMessageInfo(int sourceIndex, int messageIndex) {
        Source s = this.sources.get(sourceIndex);
        return this.messagesMap.get((Object)s).get((int)messageIndex).info;
    }

    public void clear() {
        this.sources.clear();
        this.messagesMap.clear();
        this.currentSource = null;
        this.messageIndex = 0;
    }

    @Override
    public void append(IMessenger m) {
        for (int i = 0; i < m.getMessageSourceCount(); ++i) {
            this.setMessageSource(m.getSourceType(i), m.getSourceName(i));
            for (int j = 0; j < m.getSourceMessageCount(i); ++j) {
                this.postMessage(m.getMessageType(i, j), m.getMessage(i, j), m.getMessageInfo(i, j));
            }
        }
    }

    static class Message
    implements Serializable,
    Comparable<Message> {
        int type;
        String message;
        Object info;
        private int index;

        Message(int type, String message, Object info, int index) {
            this.type = type;
            this.message = message;
            this.info = info;
            this.index = index;
        }

        @Override
        public int compareTo(Message o) {
            return this.index - o.index;
        }
    }

    static class Source
    implements Serializable {
        String type;
        String name;

        Source() {
        }

        public int hashCode() {
            return this.type.hashCode() * 17 + this.name.hashCode() * 17;
        }
    }
}

