/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.servicebase.client.dto;

import com.dsoft.framework.client.annotation.ServerLoader;
import com.dsoft.framework.client.base.DTOSet;
import com.dsoft.framework.client.exception.DTOFindException;
import com.dsoft.framework.client.history.HistoryDTO;
import com.dsoft.powerpro.core.client.dto.CompanyDTO;
import com.dsoft.powerpro.servicebase.client.dto.ServiceGroupDTO;

@ServerLoader(value="BaseServiceLoaderLocal")
public class BaseServiceDTO
extends HistoryDTO
implements Comparable<BaseServiceDTO> {
    private String name;
    private String description;
    private int serviceType;
    private boolean active;
    private boolean withAddress;
    private String serviceCode;
    private String shortName;
    private boolean formal;
    private boolean visibleInContract;
    private boolean disabledForFutureUse;
    private DTOSet<ServiceGroupDTO, Integer> serviceGroups = new DTOSet(ServiceGroupDTO.class, this, true);
    private String externalCode;
    private String tradeName;
    private static final String ServiceProviderProperty = "ServiceProviderProperty";

    public BaseServiceDTO() {
        this.registerProperty(CompanyDTO.class, ServiceProviderProperty, false);
    }

    public void setFormal(boolean formal) {
        this.setModified(this.formal, formal, "formal");
        this.formal = formal;
    }

    public boolean isFormal() {
        return this.formal;
    }

    public void setName(String name) {
        this.setModified(this.name, name, "name");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.setModified(this.description, description, "description");
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setServiceType(int serviceType) {
        this.setModified(this.serviceType, serviceType, "serviceType");
        this.serviceType = serviceType;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.setModified(this.active, active, "active");
        this.active = active;
    }

    public void setWithAddress(boolean withAddress) {
        this.setModified(this.withAddress, withAddress, "withAddress");
        this.withAddress = withAddress;
    }

    public boolean isWithAddress() {
        return this.withAddress;
    }

    public void setShortName(String shortName) {
        this.setModified(this.shortName, shortName, "shortName");
        this.shortName = shortName;
    }

    public void setServiceCode(String serviceCode) {
        this.setModified(this.serviceCode, serviceCode, "serviceCode");
        this.serviceCode = serviceCode;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getServiceCode() {
        return this.serviceCode != null ? this.serviceCode : "";
    }

    public boolean isSingleService() {
        return this.serviceType == 0;
    }

    public boolean isPeriodicalService() {
        return this.serviceType == 1;
    }

    public boolean isExternalService() {
        return this.serviceType == 2;
    }

    public void setSingleService() {
        this.setServiceType(0);
    }

    public void setPeriodicalService() {
        this.setServiceType(1);
    }

    public void setExternalService() {
        this.setServiceType(2);
    }

    @Override
    public int compareTo(BaseServiceDTO other) {
        int result = this.name.compareTo(other.name);
        if (result == 0) {
            result = this.serviceCode.compareTo(other.serviceCode);
        }
        return result;
    }

    public void setVisibleInContract(boolean visibleInContract) {
        this.setModified(this.visibleInContract, visibleInContract, "visibleInContract");
        this.visibleInContract = visibleInContract;
    }

    public void setServiceProviderId(Integer serviceProviderId) {
        this.putObjectValue(ServiceProviderProperty, serviceProviderId);
    }

    public void setExternalCode(String externalCode) {
        this.setModified(this.externalCode, externalCode, "externalCode");
        this.externalCode = externalCode;
    }

    public void setDisabledForFutureUse(boolean disabledForFutureUse) {
        this.setModified(this.disabledForFutureUse, disabledForFutureUse, "disabledForFutureUse");
        this.disabledForFutureUse = disabledForFutureUse;
    }

    public void setTradeName(String tradeName) {
        this.setModified(this.tradeName, tradeName, "tradeName");
        this.tradeName = tradeName;
    }

    public boolean isVisibleInContract() {
        return this.visibleInContract;
    }

    public DTOSet<ServiceGroupDTO, Integer> getServiceGroups() {
        return this.serviceGroups;
    }

    public Integer getServiceProviderId() {
        return (Integer)this.getObjectValue(ServiceProviderProperty);
    }

    public String getExternalCode() {
        return this.externalCode;
    }

    public boolean isDisabledForFutureUse() {
        return this.disabledForFutureUse;
    }

    public String getTradeName() {
        return this.tradeName;
    }

    public CompanyDTO getServiceProvider() throws DTOFindException {
        return (CompanyDTO)this.getPropertyValue(ServiceProviderProperty);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

