/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.syslog.server;

import com.dsoft.powerpro.syslog.server.MessagePacket;
import java.util.HashMap;
import java.util.Map;

public class SyslogMessageParser {
    static final String MSG_IDENTIFIER = "LEASE: ";
    static final String SHUTDOWN_MESSAGE = "SHUTDOWN SERVER";

    public static Map<String, Object> parseMessage(MessagePacket messagePacket) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        String message = messagePacket.getMessage();
        if (message == null || !message.startsWith(MSG_IDENTIFIER)) {
            return propertyMap;
        }
        propertyMap.put("PACKET_TIMESTAMP", messagePacket.getTimestamp());
        message = message.replaceFirst(MSG_IDENTIFIER, "");
        propertyMap.putAll(SyslogMessageParser.parseMessage(message));
        return propertyMap;
    }

    private static Map<String, Object> parseMessage(String message) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        String[] properties = message.split(" ");
        String lastProperty = null;
        for (int i = 0; i < properties.length - 1; ++i) {
            if (i == 0) {
                propertyMap.put("DEVICE_TYPE", properties[i]);
                continue;
            }
            if (properties[i].endsWith(":")) {
                lastProperty = properties[i];
                propertyMap.put(properties[i], properties[++i].trim());
                continue;
            }
            propertyMap.put(lastProperty, propertyMap.get(lastProperty) + " " + properties[i].trim());
        }
        return propertyMap;
    }
}

