/*
 * Decompiled with CFR 0.152.
 */
package com.mod_snmp.SmiParser.ErrorHandler;

import com.mod_snmp.SmiParser.Grammar.Token;
import com.mod_snmp.SmiParser.SyntaxTree.Node;

public class Message {
    private static final int EMERG = 0;
    private static final int ALERT = 1;
    private static final int CRIT = 2;
    private static final int ERROR = 3;
    private static final int WARNING = 4;
    private static final int NOTICE = 5;
    private static final int INFO = 6;
    private static final int DEBUG = 7;
    protected int level;
    protected int line;
    protected String msg;

    public Message(int linenr, String message) {
        this.level = 3;
        this.line = linenr;
        this.msg = message;
    }

    public Message(int level, int linenr, String message) {
        this.level = level;
        this.line = linenr;
        this.msg = message;
    }

    public static Message emerg(Node item, String message) {
        return Message.emerg(item.line(), "'" + item + "' " + message);
    }

    public static Message emerg(Token t, String item, String message) {
        return Message.emerg(t.beginLine, "'" + item + "' " + message);
    }

    public static Message emerg(int linenr, String message) {
        return new Message(0, linenr, message);
    }

    public static Message alert(Node item, String message) {
        return Message.alert(item.line(), "'" + item + "' " + message);
    }

    public static Message alert(Token t, String item, String message) {
        return Message.alert(t.beginLine, "'" + item + "' " + message);
    }

    public static Message alert(int linenr, String message) {
        return new Message(1, linenr, message);
    }

    public static Message critical(Node item, String message) {
        return Message.critical(item.line(), "'" + item + "' " + message);
    }

    public static Message critical(Token t, String item, String message) {
        return Message.critical(t.beginLine, "'" + item + "' " + message);
    }

    public static Message critical(int linenr, String message) {
        return new Message(2, linenr, message);
    }

    public static Message error(Node item, String message) {
        return Message.error(item.line(), "'" + item + "' " + message);
    }

    public static Message error(Token t, String item, String message) {
        return Message.error(t.beginLine, "'" + item + "' " + message);
    }

    public static Message error(int linenr, String message) {
        return new Message(3, linenr, message);
    }

    public static Message warning(Node item, String message) {
        return Message.warning(item.line(), "'" + item + "' " + message);
    }

    public static Message warning(Token t, String item, String message) {
        return Message.warning(t.beginLine, "'" + item + "' " + message);
    }

    public static Message warning(int linenr, String message) {
        return new Message(4, linenr, message);
    }

    public static Message notice(Node item, String message) {
        return Message.notice(item.line(), "'" + item + "' " + message);
    }

    public static Message notice(Token t, String item, String message) {
        return Message.notice(t.beginLine, "'" + item + "' " + message);
    }

    public static Message notice(int linenr, String message) {
        return new Message(5, linenr, message);
    }

    public static Message debug(Node item, String message) {
        return Message.debug(item.line(), "'" + item + "' " + message);
    }

    public static Message debug(Token t, String item, String message) {
        return Message.debug(t.beginLine, "'" + item + "' " + message);
    }

    public static Message debug(int linenr, String message) {
        return new Message(7, linenr, message);
    }

    public void print() {
        System.err.println(this.level + " : line " + this.line + ": " + this.msg);
    }
}

