/*
 * Decompiled with CFR 0.152.
 */
package com.mod_snmp.SmiParser.ErrorHandler;

import com.mod_snmp.SmiParser.ErrorHandler.RecoveryItem;

public class Recovery {
    private static final int default_stack_size = 70;
    private RecoveryItem[] stack;
    private int top;

    public Recovery(int heapsize) {
        this.stack = new RecoveryItem[heapsize];
        this.top = 0;
    }

    public Recovery() {
        this(70);
    }

    public Recovery(int[] items) {
        this(70);
        for (int i = 0; i < 70 && i < items.length; ++i) {
            this.push(items[i]);
        }
    }

    public boolean empty() {
        return this.top == 0;
    }

    public RecoveryItem pop() {
        if (this.top > 0) {
            return this.stack[--this.top];
        }
        return null;
    }

    public RecoveryItem pop(int nr) {
        while (--nr > 0) {
            this.pop();
        }
        return this.pop();
    }

    public void push(RecoveryItem item) {
        if (this.top < this.stack.length) {
            this.stack[this.top++] = item;
        }
    }

    public void push(int first) {
        if (this.top < this.stack.length) {
            this.stack[this.top++] = new RecoveryItem(first);
        }
    }

    public boolean contains(int first, int second) {
        for (int i = 0; i < this.top; ++i) {
            if (!this.stack[i].has(first, second)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(int first) {
        for (int i = 0; i < this.top; ++i) {
            if (!this.stack[i].has(first)) continue;
            return true;
        }
        return false;
    }
}

