/*
 * Decompiled with CFR 0.152.
 */
package com.mod_snmp.SmiParser.Grammar;

import com.mod_snmp.SmiParser.ErrorHandler.Message;
import com.mod_snmp.SmiParser.ErrorHandler.Recovery;
import com.mod_snmp.SmiParser.ErrorHandler.RecoveryItem;
import com.mod_snmp.SmiParser.Grammar.ParseException;
import com.mod_snmp.SmiParser.Grammar.SimpleCharStream;
import com.mod_snmp.SmiParser.Grammar.SmiGrammarConstants;
import com.mod_snmp.SmiParser.Grammar.SmiGrammarTokenManager;
import com.mod_snmp.SmiParser.Grammar.Token;
import com.mod_snmp.SmiParser.SyntaxTree.AccessPart;
import com.mod_snmp.SmiParser.SyntaxTree.AssignedValue;
import com.mod_snmp.SmiParser.SyntaxTree.Assignment;
import com.mod_snmp.SmiParser.SyntaxTree.AssignmentMacro;
import com.mod_snmp.SmiParser.SyntaxTree.AssignmentObject;
import com.mod_snmp.SmiParser.SyntaxTree.AssignmentType;
import com.mod_snmp.SmiParser.SyntaxTree.BitValueList;
import com.mod_snmp.SmiParser.SyntaxTree.ComplianceGroup;
import com.mod_snmp.SmiParser.SyntaxTree.ComplianceObject;
import com.mod_snmp.SmiParser.SyntaxTree.CompliancePart;
import com.mod_snmp.SmiParser.SyntaxTree.ContactInfoPart;
import com.mod_snmp.SmiParser.SyntaxTree.DefValPart;
import com.mod_snmp.SmiParser.SyntaxTree.DescriptionPart;
import com.mod_snmp.SmiParser.SyntaxTree.DisplayHintPart;
import com.mod_snmp.SmiParser.SyntaxTree.EnterprisePart;
import com.mod_snmp.SmiParser.SyntaxTree.Identifier;
import com.mod_snmp.SmiParser.SyntaxTree.Index;
import com.mod_snmp.SmiParser.SyntaxTree.IndexAugments;
import com.mod_snmp.SmiParser.SyntaxTree.IndexList;
import com.mod_snmp.SmiParser.SyntaxTree.IndexPart;
import com.mod_snmp.SmiParser.SyntaxTree.LastUpdatedPart;
import com.mod_snmp.SmiParser.SyntaxTree.MacroBody;
import com.mod_snmp.SmiParser.SyntaxTree.ModuleCapability;
import com.mod_snmp.SmiParser.SyntaxTree.ModuleCompliance;
import com.mod_snmp.SmiParser.SyntaxTree.ModuleDefinition;
import com.mod_snmp.SmiParser.SyntaxTree.ModuleIdentifier;
import com.mod_snmp.SmiParser.SyntaxTree.ModuleImport;
import com.mod_snmp.SmiParser.SyntaxTree.NamedNumber;
import com.mod_snmp.SmiParser.SyntaxTree.NodeList;
import com.mod_snmp.SmiParser.SyntaxTree.NodeOptional;
import com.mod_snmp.SmiParser.SyntaxTree.NodeToken;
import com.mod_snmp.SmiParser.SyntaxTree.NumericValue;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfo;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoAgentCapabilities;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoModuleCompliance;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoModuleIdentity;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoNotificationGroup;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoNotificationType;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoObjectGroup;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoObjectIdentifier;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoObjectIdentity;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoObjectType;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoTrapType;
import com.mod_snmp.SmiParser.SyntaxTree.OidValue;
import com.mod_snmp.SmiParser.SyntaxTree.OrganizationPart;
import com.mod_snmp.SmiParser.SyntaxTree.ProductReleasePart;
import com.mod_snmp.SmiParser.SyntaxTree.RangeItem;
import com.mod_snmp.SmiParser.SyntaxTree.RangeList;
import com.mod_snmp.SmiParser.SyntaxTree.ReferencePart;
import com.mod_snmp.SmiParser.SyntaxTree.Restriction;
import com.mod_snmp.SmiParser.SyntaxTree.RestrictionNamedNumberList;
import com.mod_snmp.SmiParser.SyntaxTree.RestrictionRange;
import com.mod_snmp.SmiParser.SyntaxTree.RestrictionSize;
import com.mod_snmp.SmiParser.SyntaxTree.Revision;
import com.mod_snmp.SmiParser.SyntaxTree.StatusPart;
import com.mod_snmp.SmiParser.SyntaxTree.SyntaxPart;
import com.mod_snmp.SmiParser.SyntaxTree.Type;
import com.mod_snmp.SmiParser.SyntaxTree.TypeChoice;
import com.mod_snmp.SmiParser.SyntaxTree.TypeIdentifier;
import com.mod_snmp.SmiParser.SyntaxTree.TypeSequence;
import com.mod_snmp.SmiParser.SyntaxTree.TypeSequenceOf;
import com.mod_snmp.SmiParser.SyntaxTree.TypeSmi;
import com.mod_snmp.SmiParser.SyntaxTree.TypeTag;
import com.mod_snmp.SmiParser.SyntaxTree.TypeTextualConvention;
import com.mod_snmp.SmiParser.SyntaxTree.UnitsPart;
import com.mod_snmp.SmiParser.SyntaxTree.ValueType;
import com.mod_snmp.SmiParser.SyntaxTree.VariationPart;
import com.mod_snmp.SmiParser.SyntaxTree.WriteSyntaxPart;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class SmiGrammar
implements SmiGrammarConstants {
    public SmiGrammarTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[72];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[14];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static void main(String[] args) throws ParseException {
        try {
            SmiGrammar parser = new SmiGrammar(System.in);
            NodeList list = parser.ModuleDefinitionList();
            if (list.nodes.isEmpty()) {
                System.out.println("MIB file failed to parse.");
            } else {
                System.out.println("MIB file parsed successfully.");
            }
        }
        catch (ParseException e) {
            System.out.println("MIB file failed to parse.");
            System.out.println(e.toString());
        }
    }

    private NodeToken makeNodeToken(int ofKind, String str) {
        return new NodeToken(str, ofKind, -1, -1, -1, -1);
    }

    private NodeToken makeNodeToken(int ofKind) {
        return new NodeToken("", ofKind, -1, -1, -1, -1);
    }

    private NodeToken makeNodeToken(Token t) {
        NodeToken node = new NodeToken(t.image.intern(), t.kind, t.beginLine, t.beginColumn, t.endLine, t.endColumn);
        if (t.specialToken == null) {
            return node;
        }
        Vector<NodeToken> temp = new Vector<NodeToken>();
        Token orig = t;
        while (t.specialToken != null) {
            t = t.specialToken;
            temp.addElement(new NodeToken(t.image.intern(), t.kind, t.beginLine, t.beginColumn, t.endLine, t.endColumn));
        }
        for (int i = temp.size() - 1; i >= 0; --i) {
            node.addSpecial((NodeToken)temp.elementAt(i));
        }
        node.trimSpecials();
        return node;
    }

    private boolean is_in_set(Token token, int[] set) {
        return this.is_in_set(token.kind, set);
    }

    private boolean is_in_set(int kind, int[] set) {
        for (int i = 0; i < set.length; ++i) {
            if (kind != set[i]) continue;
            return true;
        }
        return false;
    }

    private void recovery(int[] until) {
        while (0 < until.length) {
            Token t = this.getToken(1);
            if (this.is_in_set(t.kind, until)) {
                return;
            }
            Token token = this.getNextToken();
        }
    }

    private void recovery(Recovery until) {
        while (!until.empty()) {
            if (until.contains(this.getToken((int)1).kind, this.getToken((int)2).kind)) {
                return;
            }
            this.getNextToken();
        }
    }

    private void skip(int nr) {
        while (nr-- > 0) {
            this.getNextToken();
        }
    }

    private void makeError(Token tok, String msg) {
        if (tok.kind == 124) {
            Message.error(tok.beginLine, String.format("<quoted string: \"%1$s\"> %2$s", tok.toString().substring(0, 20), msg));
        } else {
            Message.error(tok, tok.toString(), msg);
        }
    }

    private void error(ParseException e) {
        String expected = tokenImage[e.expectedTokenSequences[0][0]];
        for (int i = 1; i < e.expectedTokenSequences.length; ++i) {
            expected = expected + ", " + tokenImage[e.expectedTokenSequences[i][0]];
        }
        this.error(e, expected);
    }

    private void error(ParseException e, String expected) {
        this.makeError(e.currentToken.next, "after " + e.currentToken + " expected " + expected);
    }

    private void handleError(ParseException e, int next, String expected) {
        this.handleError(e.currentToken.next, next, expected);
    }

    private void handleError(Token last, int next, String expected) {
        if (last.next.kind == next) {
            this.makeError(last.next, "missing " + expected);
        } else {
            this.makeError(last.next, "encountered expected " + expected);
            this.getNextToken();
        }
    }

    private void handleError(ParseException e, Recovery next, String clause, String expected) {
        this.handleError(e.currentToken.next, next, clause, expected);
    }

    private void handleError(Token tok, Recovery next, String clause, String expected) {
        if (next.contains(tok.kind)) {
            Message.error(tok.beginLine, clause + "-clause misses " + expected);
        } else {
            Message.error(tok.beginLine, clause + "-clause encountered a " + (tok.kind == 124 ? "<quoted string>" : tok.toString()) + " expected " + expected);
        }
        this.recovery(next);
    }

    private void handleError(ParseException e, Recovery next, int clause, String expected) {
        this.handleError(e.currentToken.next, next, clause, expected);
    }

    private void handleError(Token last, Recovery next, int clause, String expected) {
        this.handleError(last, next, clause == 124 ? "<quoted string>" : tokenImage[clause], expected);
    }

    private void handleError(ParseException e, Recovery next, String expected) {
        this.handleError(e.currentToken.next, next, expected);
    }

    private void handleError(Token tok, Recovery next, String expected) {
        if (next.contains(tok.kind)) {
            this.makeError(tok, "missing " + expected);
        } else {
            this.makeError(tok, "encountered expected " + expected);
        }
        this.recovery(next);
    }

    public final NodeList ModuleDefinitionList() throws ParseException {
        NodeList module_list = new NodeList();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 126: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            ModuleDefinition module = this.ModuleDefinition();
            module_list.addNode(module);
        }
        module_list.nodes.trimToSize();
        return module_list;
    }

    public final ModuleDefinition ModuleDefinition() throws ParseException {
        ModuleIdentifier module_id = null;
        NodeList exp_symbols = new NodeList();
        NodeList imports_mod_list = new NodeList();
        NodeList var22 = new NodeList();
        Recovery next = new Recovery();
        int[] next_type = new int[]{16};
        int[] next_value = new int[]{34, 35, 36, 37, 39, 40, 41, 42, 43, 44};
        int[] next_macro = new int[]{113};
        int[] next_assign = new int[]{16};
        try {
            module_id = this.ModuleIdentifier();
            Token definitions_t = this.jj_consume_token(15);
            next.push(19);
            next.push(new RecoveryItem(126, next_type));
            next.push(new RecoveryItem(107, next_type));
            next.push(new RecoveryItem(108, next_type));
            next.push(new RecoveryItem(109, next_type));
            next.push(new RecoveryItem(110, next_type));
            next.push(new RecoveryItem(125, next_value));
            next.push(new RecoveryItem(35, next_macro));
            next.push(new RecoveryItem(36, next_macro));
            next.push(new RecoveryItem(37, next_macro));
            next.push(new RecoveryItem(38, next_macro));
            next.push(new RecoveryItem(39, next_macro));
            next.push(new RecoveryItem(40, next_macro));
            next.push(new RecoveryItem(41, next_macro));
            next.push(new RecoveryItem(42, next_macro));
            next.push(new RecoveryItem(43, next_macro));
            next.push(new RecoveryItem(44, next_macro));
            next.push(new RecoveryItem(100, next_assign));
            next.push(new RecoveryItem(101, next_assign));
            next.push(new RecoveryItem(95, next_assign));
            next.push(new RecoveryItem(94, next_assign));
            next.push(new RecoveryItem(103, next_assign));
            next.push(new RecoveryItem(97, next_assign));
            next.push(new RecoveryItem(96, next_assign));
            next.push(new RecoveryItem(98, next_assign));
            next.push(new RecoveryItem(99, next_assign));
            next.push(new RecoveryItem(106, next_assign));
            next.push(new RecoveryItem(105, next_assign));
            next.push(new RecoveryItem(104, next_assign));
            next.push(21);
            next.push(20);
            next.push(18);
            this.AssignSymbol(next);
            next.pop();
            Token begin_t = this.jj_consume_token(18);
            next.pop();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    Token var10 = this.jj_consume_token(20);
                    exp_symbols = this.ModuleExport(exp_symbols);
                    Token var13 = this.jj_consume_token(32);
                    exp_symbols.nodes.trimToSize();
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                }
            }
            next.pop();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    Token var17 = this.jj_consume_token(21);
                    next.push(32);
                    block16: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 87: 
                            case 94: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 125: 
                            case 126: {
                                break;
                            }
                            default: {
                                this.jj_la1[2] = this.jj_gen;
                                break block16;
                            }
                        }
                        try {
                            ModuleImport imports_symbols = this.ModuleImport(next);
                            imports_mod_list.addNode(imports_symbols);
                        }
                        catch (ParseException e) {
                            if (e.currentToken.kind == 22) {
                                this.makeError(e.currentToken, "incorrect module name");
                            }
                            if (e.currentToken.kind == 32) continue;
                            this.getNextToken();
                        }
                    }
                    imports_mod_list.nodes.trimToSize();
                    next.pop();
                    Token var21 = this.jj_consume_token(32);
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                }
            }
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 87: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 125: 
                    case 126: {
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        break block17;
                    }
                }
                Assignment var24 = this.Assignment(next);
                var22.addNode(var24);
                this.recovery(next);
            }
            var22.nodes.trimToSize();
            Token var36 = this.jj_consume_token(19);
        }
        catch (ParseException e) {
            this.makeError(e.currentToken, "error in module " + (module_id != null ? module_id.toString() : ""));
            this.recovery(next);
        }
        return new ModuleDefinition(module_id, exp_symbols, imports_mod_list, var22);
    }

    NodeList ModuleExport(NodeList exports) throws ParseException {
        boolean more = true;
        while (more) {
            Token tok = this.getToken(1);
            if (tok.kind == 32 || tok.kind == 21) {
                more = false;
            }
            if (tok.kind != 24) {
                exports.addNode(this.makeNodeToken(tok));
            }
            tok = this.getNextToken();
        }
        return exports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ModuleImport ModuleImport(Recovery next) throws ParseException {
        Identifier symbol;
        NodeList symbol_list = new NodeList();
        next.push(22);
        next.push(24);
        try {
            symbol = this.Symbol();
            symbol_list.addNode(symbol);
        }
        catch (ParseException e) {
            this.makeError(e.currentToken, "expected <symbol>");
            this.recovery(next);
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block12;
                }
            }
            try {
                Token comma_t = this.jj_consume_token(24);
                symbol = this.Symbol();
                symbol_list.addNode(symbol);
            }
            catch (ParseException e) {
                if (e.currentToken.kind == 24) {
                    this.makeError(e.currentToken, "encountered expected <symbol>");
                    this.recovery(next);
                    continue;
                }
                this.handleError(e, next, "<symbol>");
            }
        }
        symbol_list.nodes.trimToSize();
        next.pop();
        next.push(126);
        try {
            Token from_t = this.jj_consume_token(22);
        }
        catch (ParseException e) {
            this.makeError(e.currentToken, "expected 'FROM'");
            this.recovery(next);
            if (this.getToken((int)0).kind == 22) {
                this.getNextToken();
            }
        }
        finally {
            next.pop();
            next.pop();
        }
        ModuleIdentifier module_id = this.ModuleIdentifier();
        return new ModuleImport(symbol_list, module_id);
    }

    public final Identifier Symbol() throws ParseException {
        Identifier identifier;
        if (this.jj_2_1(3)) {
            identifier = this.TypeIdentifier();
        } else if (this.jj_2_2(3)) {
            identifier = this.ValueIdentifier();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 107: 
                case 108: 
                case 109: 
                case 110: {
                    identifier = this.TypeIdentifierException();
                    break;
                }
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    identifier = this.SmiTypes();
                    break;
                }
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    identifier = this.PredefinedMacro();
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return identifier;
    }

    public final Identifier PredefinedMacro() throws ParseException {
        Token var;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                var = this.jj_consume_token(35);
                break;
            }
            case 36: {
                var = this.jj_consume_token(36);
                break;
            }
            case 37: {
                var = this.jj_consume_token(37);
                break;
            }
            case 38: {
                var = this.jj_consume_token(38);
                break;
            }
            case 39: {
                var = this.jj_consume_token(39);
                break;
            }
            case 40: {
                var = this.jj_consume_token(40);
                break;
            }
            case 41: {
                var = this.jj_consume_token(41);
                break;
            }
            case 42: {
                var = this.jj_consume_token(42);
                break;
            }
            case 43: {
                var = this.jj_consume_token(43);
                break;
            }
            case 44: {
                var = this.jj_consume_token(44);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return Identifier.Keyword(this.makeNodeToken(var));
    }

    public final Identifier SmiTypes() throws ParseException {
        Token var;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 100: {
                var = this.jj_consume_token(100);
                break;
            }
            case 101: {
                var = this.jj_consume_token(101);
                break;
            }
            case 102: {
                var = this.jj_consume_token(102);
                break;
            }
            case 95: {
                var = this.jj_consume_token(95);
                break;
            }
            case 94: {
                var = this.jj_consume_token(94);
                break;
            }
            case 103: {
                var = this.jj_consume_token(103);
                break;
            }
            case 97: {
                var = this.jj_consume_token(97);
                break;
            }
            case 96: {
                var = this.jj_consume_token(96);
                break;
            }
            case 98: {
                var = this.jj_consume_token(98);
                break;
            }
            case 99: {
                var = this.jj_consume_token(99);
                break;
            }
            case 106: {
                var = this.jj_consume_token(106);
                break;
            }
            case 105: {
                var = this.jj_consume_token(105);
                break;
            }
            case 104: {
                var = this.jj_consume_token(104);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return Identifier.Keyword(this.makeNodeToken(var));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Assignment Assignment(Recovery next) throws ParseException {
        Assignment assignment = null;
        Identifier identifier = null;
        if (this.jj_2_3(2)) {
            identifier = this.TypeIdentifier();
            this.AssignSymbol(new Recovery());
            Type type = this.TypeDefinition(next);
            assignment = new AssignmentType(identifier, type);
        } else if (this.jj_2_4(2)) {
            ObjectInfo object_info;
            identifier = this.ValueIdentifier();
            next.push(16);
            try {
                object_info = this.ObjectDefinition(next);
            }
            catch (ParseException e) {
                object_info = new ObjectInfoObjectIdentifier();
                this.makeError(e.currentToken, "encountered in assignment '" + identifier + "'");
                this.recovery(next);
            }
            finally {
                next.pop();
                next.push(25);
            }
            this.AssignSymbol(next);
            next.pop();
            AssignedValue assigned_value = this.AssignedValue();
            assignment = new AssignmentObject(identifier, object_info, assigned_value);
        } else if (this.jj_2_5(3)) {
            identifier = this.SmiTypes();
            next.push(88);
            next.push(90);
            next.push(91);
            next.push(34);
            next.push(29);
            this.AssignSymbol(next);
            next.pop();
            TypeTag typeTag = this.TypeTag(next);
            if (!next.contains(this.getToken((int)1).kind)) {
                this.recovery(next);
            }
            next.pop(4);
            TypeSmi type = this.Asn1Types();
            typeTag.setType(type);
            assignment = new AssignmentType(identifier, typeTag);
        } else if (this.jj_2_6(3)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    identifier = this.SmiTypes();
                    break;
                }
                case 107: 
                case 108: 
                case 109: 
                case 110: {
                    identifier = this.TypeIdentifierException();
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            next.push(114);
            this.AssignSymbol(next);
            next.pop();
            Token type_t = this.jj_consume_token(114);
            NodeList vtList = this.BracedValueTypeList();
            assignment = new AssignmentType(identifier, new TypeChoice(vtList));
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    identifier = this.PredefinedMacro();
                    Token type_t = this.jj_consume_token(113);
                    next.push(18);
                    this.AssignSymbol(next);
                    next.pop();
                    Token begin_t = this.jj_consume_token(18);
                    MacroBody macro_body = this.MacroBody();
                    Token end_t = this.jj_consume_token(19);
                    assignment = new AssignmentMacro(identifier, macro_body);
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    if (this.jj_2_7(2)) {
                        identifier = this.ValueIdentifier();
                        Token type_t = this.jj_consume_token(44);
                        next.push(16);
                        next.push(48);
                        next.push(72);
                        EnterprisePart enterprise = this.EnterprisePart(next);
                        next.pop();
                        NodeList variables = this.VariablesPart(next);
                        next.pop();
                        DescriptionPart description = this.DescriptionPart(next);
                        next.pop();
                        next.push(122);
                        next.push(120);
                        next.push(121);
                        next.push(125);
                        next.push(126);
                        this.AssignSymbol(next);
                        next.pop(3);
                        NumericValue number = this.NumericValue();
                        next.pop(2);
                        assignment = new AssignmentObject(identifier, (ObjectInfo)new ObjectInfoTrapType(enterprise, variables, description, number), number);
                        break;
                    }
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return assignment;
    }

    public final Type TypeDefinition(Recovery next) throws ParseException {
        Type type;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 126: {
                type = this.Types();
                break;
            }
            case 38: {
                Token type_t = this.jj_consume_token(38);
                next.push(60);
                next.push(59);
                next.push(48);
                next.push(73);
                DisplayHintPart displayhint = this.DisplayHintPart(next);
                next.pop();
                StatusPart status = this.StatusPart(next);
                next.pop();
                DescriptionPart description = this.DescriptionPart(next);
                next.pop();
                ReferencePart reference = this.ReferencePart(next);
                next.pop();
                SyntaxPart syntax = this.SyntaxPart(next);
                type = new TypeTextualConvention(displayhint, status, description, reference, syntax);
                break;
            }
            case 93: {
                Token type_t = this.jj_consume_token(93);
                NodeList vtList = this.BracedValueTypeList();
                type = new TypeSequence(vtList);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return type;
    }

    public final ObjectInfo ObjectDefinition(Recovery next) throws ParseException {
        ObjectInfo object_info;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                Token sort_t = this.jj_consume_token(34);
                object_info = new ObjectInfoObjectIdentifier();
                break;
            }
            case 35: {
                Token sort_t = this.jj_consume_token(35);
                next.push(66);
                next.push(63);
                next.push(59);
                next.push(48);
                next.push(73);
                next.push(79);
                next.push(62);
                SyntaxPart syntax = this.SyntaxPart(next);
                next.pop();
                UnitsPart units = this.UnitsPart(next);
                next.pop();
                next.contains(-1);
                AccessPart access = this.AccessPart(79, next);
                next.pop();
                StatusPart status = this.StatusPart(next);
                next.pop();
                DescriptionPart description = this.DescriptionPart(next);
                next.pop();
                ReferencePart reference = this.ReferencePart(next);
                next.pop();
                IndexPart index = this.IndexPart(next);
                next.pop();
                DefValPart defval = this.DefValPart(next);
                object_info = new ObjectInfoObjectType(syntax, units, access, status, description, reference, index, defval);
                break;
            }
            case 41: {
                Token sort_t = this.jj_consume_token(41);
                next.push(49);
                next.push(48);
                next.push(47);
                next.push(46);
                LastUpdatedPart lastupdated = this.LastUpdatedPart(next);
                next.pop();
                OrganizationPart organization = this.OrganizationPart(next);
                next.pop();
                ContactInfoPart contactinfo = this.ContactInfoPart(next);
                next.pop();
                DescriptionPart description = this.DescriptionPart(next);
                next.pop();
                NodeList revision = this.RevisionPart(next);
                object_info = new ObjectInfoModuleIdentity(lastupdated, organization, contactinfo, description, revision);
                break;
            }
            case 36: {
                Token sort_t = this.jj_consume_token(36);
                next.push(59);
                next.push(48);
                StatusPart status = this.StatusPart(next);
                next.pop();
                DescriptionPart description = this.DescriptionPart(next);
                next.pop();
                ReferencePart reference = this.ReferencePart(next);
                object_info = new ObjectInfoObjectIdentity(status, description, reference);
                break;
            }
            case 37: {
                Token sort_t = this.jj_consume_token(37);
                next.push(59);
                next.push(48);
                next.push(73);
                NodeList objects = this.ObjectsPart(false, next);
                next.pop();
                StatusPart status = this.StatusPart(next);
                next.pop();
                DescriptionPart description = this.DescriptionPart(next);
                next.pop();
                ReferencePart reference = this.ReferencePart(next);
                object_info = new ObjectInfoObjectGroup(objects, status, description, reference);
                break;
            }
            case 39: {
                Token sort_t = this.jj_consume_token(39);
                next.push(59);
                next.push(48);
                next.push(73);
                NodeList objects = this.ObjectsPart(true, next);
                next.pop();
                StatusPart status = this.StatusPart(next);
                next.pop();
                DescriptionPart description = this.DescriptionPart(next);
                next.pop();
                ReferencePart reference = this.ReferencePart(next);
                object_info = new ObjectInfoNotificationType(objects, status, description, reference);
                break;
            }
            case 40: {
                Token sort_t = this.jj_consume_token(40);
                next.push(59);
                next.push(48);
                next.push(73);
                NodeList notification = this.NotificationPart(next);
                next.pop();
                StatusPart status = this.StatusPart(next);
                next.pop();
                DescriptionPart description = this.DescriptionPart(next);
                next.pop();
                ReferencePart reference = this.ReferencePart(next);
                object_info = new ObjectInfoNotificationGroup(notification, status, description, reference);
                break;
            }
            case 42: {
                Token sort_t = this.jj_consume_token(42);
                next.push(51);
                next.push(59);
                next.push(48);
                StatusPart status = this.StatusPart(next);
                next.pop();
                DescriptionPart description = this.DescriptionPart(next);
                next.pop();
                ReferencePart reference = this.ReferencePart(next);
                next.pop();
                NodeList modulecompliance = this.ModuleCompliancePart();
                object_info = new ObjectInfoModuleCompliance(status, description, reference, modulecompliance);
                break;
            }
            case 43: {
                Token sort_t = this.jj_consume_token(43);
                next.push(54);
                next.push(59);
                next.push(48);
                next.push(73);
                ProductReleasePart productrelease = this.ProductReleasePart(next);
                next.pop();
                StatusPart status = this.StatusPart(next);
                next.pop();
                DescriptionPart description = this.DescriptionPart(next);
                next.pop();
                ReferencePart reference = this.ReferencePart(next);
                next.pop();
                NodeList modulecapabilities = this.ModuleCapabilitiesPart();
                object_info = new ObjectInfoAgentCapabilities(productrelease, status, description, reference, modulecapabilities);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return object_info;
    }

    MacroBody MacroBody() throws ParseException {
        while (true) {
            Token tok = this.getToken(1);
            if (tok.kind == 19) break;
            tok = this.getNextToken();
        }
        return new MacroBody();
    }

    TypeChoice TypeChoice() throws ParseException {
        NodeList items = new NodeList();
        int nesting = 0;
        Token tok = this.getNextToken();
        if (tok.kind == 25) {
            nesting = 1;
        }
        while (nesting > 0) {
            tok = this.getNextToken();
            if (tok.kind == 25) {
                ++nesting;
            }
            if (tok.kind != 26) continue;
            --nesting;
        }
        return new TypeChoice(items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TypeTag TypeTag(Recovery next) throws ParseException {
        TypeTag typeTag = new TypeTag();
        next.push(122);
        next.push(30);
        next.push(118);
        next.push(119);
        block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                Token lsquare = this.jj_consume_token(29);
                try {
                    Token sort;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 115: {
                            sort = this.jj_consume_token(115);
                            break;
                        }
                        case 116: {
                            sort = this.jj_consume_token(116);
                            break;
                        }
                        case 117: {
                            sort = this.jj_consume_token(117);
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    typeTag.setSort(this.makeNodeToken(sort));
                }
                catch (ParseException e) {
                    this.handleError(e, next, "tag sort <APPLICATION/UNIVERSAL/PRIVATE>");
                }
                finally {
                    next.pop();
                }
                try {
                    Token number = this.jj_consume_token(122);
                    typeTag.setNumber(new NumericValue(this.makeNodeToken(number)));
                }
                catch (ParseException e) {
                    this.handleError(e, next, "<decimal tag number>");
                }
                finally {
                    next.pop();
                }
                Token rsquare = this.jj_consume_token(30);
                next.pop(2);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 118: 
                    case 119: {
                        Token kind;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 118: {
                                kind = this.jj_consume_token(118);
                                break;
                            }
                            case 119: {
                                kind = this.jj_consume_token(119);
                                break;
                            }
                            default: {
                                this.jj_la1[14] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        typeTag.setKind(this.makeNodeToken(kind));
                        break block4;
                    }
                }
                this.jj_la1[15] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        return typeTag;
    }

    public final TypeSmi Asn1Types() throws ParseException {
        TypeSmi type;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: {
                Token type_t = this.jj_consume_token(88);
                type = new TypeSmi(this.makeNodeToken(type_t));
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        RestrictionRange restriction = this.RestrictionRange();
                        type.addRestriction(restriction);
                        break block0;
                    }
                }
                this.jj_la1[17] = this.jj_gen;
                break;
            }
            case 90: {
                Token type_t = this.jj_consume_token(90);
                type = new TypeSmi(this.makeNodeToken(type_t));
                break;
            }
            case 91: {
                Token type_t = this.jj_consume_token(91);
                type = new TypeSmi(this.makeNodeToken(type_t));
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        RestrictionSize restriction = this.RestrictionSize(new Recovery(new int[0]));
                        type.addRestriction(restriction);
                        break block0;
                    }
                }
                this.jj_la1[18] = this.jj_gen;
                break;
            }
            case 34: {
                Token type_t = this.jj_consume_token(34);
                type = new TypeSmi(this.makeNodeToken(type_t));
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NodeList RevisionPart(Recovery next) throws ParseException {
        NodeList revisions = new NodeList();
        next.push(49);
        block8: while (true) {
            Token time_t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 49: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block8;
                }
            }
            Token revision_t = this.jj_consume_token(49);
            next.push(48);
            try {
                time_t = this.jj_consume_token(123);
            }
            catch (ParseException e) {
                this.handleError(e, next, "<utc time>");
                time_t = new Token();
            }
            finally {
                next.pop();
            }
            DescriptionPart description = this.DescriptionPart(next);
            revisions.addNode(new Revision(this.makeNodeToken(time_t), description));
        }
        revisions.nodes.trimToSize();
        return revisions;
    }

    public final StatusPart StatusPart(Recovery next) throws ParseException {
        NodeToken status;
        try {
            Token value;
            Token key = this.jj_consume_token(73);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 74: {
                    value = this.jj_consume_token(74);
                    break;
                }
                case 75: {
                    value = this.jj_consume_token(75);
                    break;
                }
                case 76: {
                    value = this.jj_consume_token(76);
                    break;
                }
                case 77: {
                    value = this.jj_consume_token(77);
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            status = this.makeNodeToken(value);
        }
        catch (ParseException e) {
            if (e.currentToken.kind == 73) {
                this.handleError(e, next, "<status value>");
                status = this.makeNodeToken(-1);
            }
            if (e.currentToken.next.kind == 74 || e.currentToken.next.kind == 75 || e.currentToken.next.kind == 74 || e.currentToken.next.kind == 74) {
                Token tok = this.getNextToken();
                Message.error(tok.beginLine, "missing 'STATUS'-keyword");
                status = this.makeNodeToken(tok);
            }
            Message.error(this.getToken((int)1).beginLine, "STATUS-clause missing");
            status = this.makeNodeToken(-1);
            this.recovery(next);
        }
        return new StatusPart(status);
    }

    public final AccessPart AccessPart(int access_type, Recovery next) throws ParseException {
        AccessPart access = new AccessPart();
        Recovery next_values = new Recovery();
        next_values.push(81);
        next_values.push(82);
        next_values.push(83);
        next_values.push(84);
        next_values.push(85);
        next_values.push(86);
        next_values.push(87);
        try {
            Token key;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 78: {
                    key = this.jj_consume_token(78);
                    break;
                }
                case 80: {
                    key = this.jj_consume_token(80);
                    break;
                }
                case 79: {
                    key = this.jj_consume_token(79);
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            access.key = this.makeNodeToken(key);
        }
        catch (ParseException e) {
            access.key = this.makeNodeToken(access_type, tokenImage[access_type]);
            if (next_values.contains(e.currentToken.next.kind)) {
                this.handleError(e, next, tokenImage[access_type]);
            }
            StringBuffer str = new StringBuffer(tokenImage[access_type]);
            str.deleteCharAt(0);
            str.deleteCharAt(str.length() - 1);
            Message.error(this.getToken((int)1).beginLine, str + "-clause missing");
            access.value = this.makeNodeToken(-1);
            return access;
        }
        try {
            Token value;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 81: {
                    value = this.jj_consume_token(81);
                    break;
                }
                case 82: {
                    value = this.jj_consume_token(82);
                    break;
                }
                case 83: {
                    value = this.jj_consume_token(83);
                    break;
                }
                case 84: {
                    value = this.jj_consume_token(84);
                    break;
                }
                case 85: {
                    value = this.jj_consume_token(85);
                    break;
                }
                case 86: {
                    value = this.jj_consume_token(86);
                    break;
                }
                case 87: {
                    value = this.jj_consume_token(87);
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            access.value = this.makeNodeToken(value);
        }
        catch (ParseException e) {
            this.handleError(e, next, "<access value>");
            access.value = this.makeNodeToken(-1);
        }
        return access;
    }

    public final NodeList ModuleCompliancePart() throws ParseException {
        NodeList module_list = new NodeList();
        block3: while (true) {
            ModuleCompliance module_compliance = this.ModuleCompliance();
            module_list.addNode(module_compliance);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 51: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[24] = this.jj_gen;
        module_list.nodes.trimToSize();
        return module_list;
    }

    public final ModuleCompliance ModuleCompliance() throws ParseException {
        ModuleCompliance module_compliance = new ModuleCompliance();
        Recovery next = new Recovery();
        next.push(16);
        next.push(53);
        next.push(67);
        Token module_t = this.jj_consume_token(51);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 126: {
                ModuleIdentifier module_id = this.ModuleIdentifier();
                module_compliance.addModuleIdentifier(module_id);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 52: {
                NodeList mandatory = this.MandatoryPart(next);
                module_compliance.addMandatoryPart(mandatory);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 53: 
                case 67: {
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    break block11;
                }
            }
            try {
                CompliancePart compliance = this.CompliancePart(next);
                module_compliance.addCompliancePart(compliance);
            }
            catch (ParseException e) {
                this.handleError(e, next, "<compliance part>");
            }
        }
        return module_compliance;
    }

    public final NodeList MandatoryPart(Recovery next) throws ParseException {
        Token mandatory_groups_t = this.jj_consume_token(52);
        NodeList list = this.BracedValueList(next);
        return list;
    }

    public final CompliancePart CompliancePart(Recovery next) throws ParseException {
        CompliancePart compliance;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: {
                Token sort_t = this.jj_consume_token(53);
                Identifier identifier = this.ValueIdentifier();
                DescriptionPart description = this.DescriptionPart(next);
                compliance = new ComplianceGroup(identifier, description);
                break;
            }
            case 67: {
                boolean has_syntax = false;
                boolean has_write_syntax = false;
                boolean has_min_access = false;
                next.push(48);
                next.push(80);
                next.push(61);
                next.push(60);
                Token sort_t = this.jj_consume_token(67);
                Identifier identifier = this.ValueIdentifier();
                ComplianceObject compliance_object = new ComplianceObject(identifier);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 60: {
                        SyntaxPart syntax = this.SyntaxPart(next);
                        compliance_object.addNode(syntax);
                        has_syntax = true;
                        break;
                    }
                    default: {
                        this.jj_la1[28] = this.jj_gen;
                    }
                }
                next.pop();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 61: {
                        WriteSyntaxPart write_syntax = this.WriteSyntaxPart(next);
                        compliance_object.addNode(write_syntax);
                        has_write_syntax = true;
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                    }
                }
                next.pop();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 78: 
                    case 79: 
                    case 80: {
                        AccessPart min_access = this.AccessPart(80, next);
                        compliance_object.addNode(min_access);
                        has_min_access = true;
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                    }
                }
                next.pop();
                if (this.getToken((int)1).kind != 48) {
                    String str = "";
                    if (!has_min_access) {
                        str = str + "MIN-ACCESS-";
                        if (!has_write_syntax) {
                            str = str + ", WRITE-SYNTAX-";
                            if (!has_syntax) {
                                str = str + ", SYNTAX-";
                            }
                        }
                        str = str + " or ";
                    }
                    this.makeError(this.getToken(1), "expected " + str + "DESCRIPTION-clause");
                    this.recovery(next);
                }
                next.pop();
                DescriptionPart description = this.DescriptionPart(next);
                next.pop();
                compliance_object.addNode(description);
                compliance = compliance_object;
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return compliance;
    }

    public final NodeList ModuleCapabilitiesPart() throws ParseException {
        NodeList module_capabilities_list = new NodeList();
        Recovery next = new Recovery();
        next.push(16);
        next.push(54);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 54: {
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    break block3;
                }
            }
            ModuleCapability module_capability = this.ModuleCapability(next);
            module_capabilities_list.addNode(module_capability);
        }
        return module_capabilities_list;
    }

    public final ModuleCapability ModuleCapability(Recovery next) throws ParseException {
        ModuleIdentifier module_id;
        NodeList variation_list = new NodeList();
        Token support_t = this.jj_consume_token(54);
        try {
            module_id = this.ModuleIdentifier();
        }
        catch (ParseException e) {
            this.handleError(e, 70, "<module identifier>");
            module_id = new ModuleIdentifier(this.makeNodeToken(126));
        }
        try {
            Token includes_t = this.jj_consume_token(70);
        }
        catch (ParseException e) {
            this.handleError(e, 25, "'INCLUDES'");
        }
        NodeList list = this.BracedValueList(next);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 56: {
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                    break block7;
                }
            }
            VariationPart variation = this.VariationPart();
            variation_list.addNode(variation);
        }
        variation_list.nodes.trimToSize();
        return new ModuleCapability(module_id, list, variation_list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final VariationPart VariationPart() throws ParseException {
        Identifier identifier;
        NodeOptional syntax_option = new NodeOptional();
        NodeOptional write_syntax_option = new NodeOptional();
        NodeOptional access_option = new NodeOptional();
        NodeOptional creation_option = new NodeOptional();
        Recovery next = new Recovery();
        next.push(48);
        next.push(66);
        next.push(57);
        next.push(78);
        next.push(61);
        next.push(60);
        Token variation_t = this.jj_consume_token(56);
        try {
            identifier = this.ValueIdentifier();
        }
        catch (ParseException e) {
            this.handleError(e, next, "<value identifier>");
            identifier = Identifier.Value(this.makeNodeToken(125));
        }
        finally {
            next.pop();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                SyntaxPart syntax = this.SyntaxPart(next);
                syntax_option.addNode(syntax);
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
            }
        }
        next.pop();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 61: {
                WriteSyntaxPart write_syntax = this.WriteSyntaxPart(next);
                write_syntax_option.addNode(write_syntax);
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
            }
        }
        next.pop();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 78: 
            case 79: 
            case 80: {
                AccessPart access = this.AccessPart(78, next);
                access_option.addNode(access);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        next.pop();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                Token creation_t = this.jj_consume_token(57);
                NodeList list = this.BracedValueList(next);
                creation_option.addNode(list);
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        next.pop();
        DefValPart defval = this.DefValPart(next);
        next.pop();
        DescriptionPart description = this.DescriptionPart(next);
        return new VariationPart(identifier, syntax_option, write_syntax_option, access_option, creation_option, defval, description);
    }

    public final SyntaxPart SyntaxPart(Recovery next) throws ParseException {
        Type type;
        try {
            Token key = this.jj_consume_token(60);
            type = this.Types();
        }
        catch (ParseException e) {
            if (e.currentToken.kind == 60) {
                this.handleError(e, next, "<type>");
            } else {
                Message.error(this.getToken((int)1).beginLine, "SYNTAX-clause missing");
                this.recovery(next);
            }
            type = new TypeIdentifier();
        }
        return new SyntaxPart(type);
    }

    public final WriteSyntaxPart WriteSyntaxPart(Recovery next) throws ParseException {
        Token key = this.jj_consume_token(61);
        Type type = this.Types();
        return new WriteSyntaxPart(type);
    }

    public final Type Types() throws ParseException {
        Type type;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 92: {
                Token type_t = this.jj_consume_token(92);
                Identifier identifier = this.TypeIdentifier();
                type = new TypeSequenceOf(identifier);
                break;
            }
            case 88: 
            case 104: 
            case 105: 
            case 106: {
                Token type_t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 88: {
                        type_t = this.jj_consume_token(88);
                        break;
                    }
                    case 106: {
                        type_t = this.jj_consume_token(106);
                        break;
                    }
                    case 105: {
                        type_t = this.jj_consume_token(105);
                        break;
                    }
                    case 104: {
                        type_t = this.jj_consume_token(104);
                        break;
                    }
                    default: {
                        this.jj_la1[38] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                type = new TypeSmi(this.makeNodeToken(type_t));
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 25: 
                    case 27: {
                        Restriction restriction;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 25: {
                                restriction = this.RestrictionNamedNumberList();
                                break;
                            }
                            case 27: {
                                restriction = this.RestrictionRange();
                                break;
                            }
                            default: {
                                this.jj_la1[39] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        type.addRestriction(restriction);
                        break block0;
                    }
                }
                this.jj_la1[40] = this.jj_gen;
                break;
            }
            case 96: 
            case 97: {
                Token type_t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 97: {
                        type_t = this.jj_consume_token(97);
                        break;
                    }
                    case 96: {
                        type_t = this.jj_consume_token(96);
                        break;
                    }
                    default: {
                        this.jj_la1[41] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                type = new TypeSmi(this.makeNodeToken(type_t));
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        RestrictionRange restriction = this.RestrictionRange();
                        type.addRestriction(restriction);
                        break block0;
                    }
                }
                this.jj_la1[42] = this.jj_gen;
                break;
            }
            case 89: 
            case 90: {
                Token type_t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 89: {
                        type_t = this.jj_consume_token(89);
                        break;
                    }
                    case 90: {
                        type_t = this.jj_consume_token(90);
                        break;
                    }
                    default: {
                        this.jj_la1[43] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                type = new TypeSmi(this.makeNodeToken(type_t));
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 25: {
                        RestrictionNamedNumberList restriction = this.RestrictionNamedNumberList();
                        type.addRestriction(restriction);
                        break block0;
                    }
                }
                this.jj_la1[44] = this.jj_gen;
                break;
            }
            case 91: 
            case 99: {
                Token type_t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 91: {
                        type_t = this.jj_consume_token(91);
                        break;
                    }
                    case 99: {
                        type_t = this.jj_consume_token(99);
                        break;
                    }
                    default: {
                        this.jj_la1[45] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                type = new TypeSmi(this.makeNodeToken(type_t));
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        RestrictionSize restriction = this.RestrictionSize(new Recovery(new int[0]));
                        type.addRestriction(restriction);
                        break block0;
                    }
                }
                this.jj_la1[46] = this.jj_gen;
                break;
            }
            case 34: {
                Token type_t = this.jj_consume_token(34);
                type = new TypeSmi(this.makeNodeToken(type_t));
                break;
            }
            case 95: {
                Token type_t = this.jj_consume_token(95);
                type = new TypeSmi(this.makeNodeToken(type_t));
                break;
            }
            case 94: {
                Token type_t = this.jj_consume_token(94);
                type = new TypeSmi(this.makeNodeToken(type_t));
                break;
            }
            case 103: {
                Token type_t = this.jj_consume_token(103);
                type = new TypeSmi(this.makeNodeToken(type_t));
                break;
            }
            case 98: {
                Token type_t = this.jj_consume_token(98);
                type = new TypeSmi(this.makeNodeToken(type_t));
                break;
            }
            case 102: {
                Token type_t = this.jj_consume_token(102);
                type = new TypeSmi(this.makeNodeToken(type_t));
                break;
            }
            case 100: {
                Token type_t = this.jj_consume_token(100);
                type = new TypeSmi(this.makeNodeToken(type_t));
                break;
            }
            case 101: {
                Token type_t = this.jj_consume_token(101);
                type = new TypeSmi(this.makeNodeToken(type_t));
                break;
            }
            case 126: {
                Identifier identifier = this.TypeIdentifier();
                type = new TypeIdentifier(identifier);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 25: 
                    case 27: {
                        Restriction restriction;
                        if (this.jj_2_8(2)) {
                            restriction = this.RestrictionRange();
                        } else {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 25: {
                                    restriction = this.RestrictionNamedNumberList();
                                    break;
                                }
                                default: {
                                    this.jj_la1[47] = this.jj_gen;
                                    if (this.jj_2_9(2)) {
                                        restriction = this.RestrictionSize(new Recovery(new int[0]));
                                        break;
                                    }
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                        }
                        type.addRestriction(restriction);
                        break block0;
                    }
                }
                this.jj_la1[48] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return type;
    }

    public final RestrictionRange RestrictionRange() throws ParseException {
        Recovery next = new Recovery();
        this.LParenSymbol(next);
        RangeList var2 = this.RangeList();
        this.RParenSymbol(next);
        return new RestrictionRange(var2);
    }

    public final RestrictionSize RestrictionSize(Recovery next) throws ParseException {
        next.push(111);
        this.LParenSymbol(next);
        next.pop();
        Token var3 = this.jj_consume_token(111);
        next.push(28);
        next.push(122);
        this.LParenSymbol(next);
        next.pop();
        RangeList range = this.RangeList();
        next.pop();
        this.RParenSymbol(next);
        this.RParenSymbol(next);
        return new RestrictionSize(range);
    }

    public final RestrictionNamedNumberList RestrictionNamedNumberList() throws ParseException {
        NodeList list = new NodeList();
        Recovery next = new Recovery();
        next.push(125);
        this.LBraceSymbol(next);
        next.pop();
        next.push(26);
        next.push(24);
        NamedNumber item = this.NamedNumber_Rule(next);
        list.addNode(item);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                    break block3;
                }
            }
            Token comma_t = this.jj_consume_token(24);
            item = this.NamedNumber_Rule(next);
            list.addNode(item);
        }
        list.nodes.trimToSize();
        next.pop();
        next.pop();
        this.RBraceSymbol(next);
        return new RestrictionNamedNumberList(list);
    }

    public final RangeList RangeList() throws ParseException {
        RangeItem range = this.RangeItem();
        RangeList list = new RangeList(range);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 31: {
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                    break block3;
                }
            }
            Token sort_t = this.jj_consume_token(31);
            range = this.RangeItem();
            list.addNode(range);
        }
        return list;
    }

    public final RangeItem RangeItem() throws ParseException {
        NumericValue number = this.NumericValue();
        RangeItem range_item = new RangeItem(number);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 112: {
                Token sort_t = this.jj_consume_token(112);
                number = this.NumericValue();
                range_item.addEndNumber(number);
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
            }
        }
        return range_item;
    }

    public final NamedNumber NamedNumber_Rule(Recovery next) throws ParseException {
        Identifier identifier = null;
        NumericValue number = null;
        try {
            if (this.jj_2_10(3)) {
                identifier = this.ValueIdentifier();
            } else if (this.jj_2_11(3)) {
                identifier = this.TypeIdentifier();
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jj_consume_token(27);
            try {
                Token number_t = this.jj_consume_token(122);
                number = new NumericValue(this.makeNodeToken(number_t));
            }
            catch (ParseException e) {
                this.handleError(e, next, "<number>");
            }
            this.jj_consume_token(28);
        }
        catch (ParseException e) {
            if (e.currentToken.kind == 122) {
                this.handleError(e, next, "')' for <named number :" + identifier + ">");
            }
            if (e.currentToken.kind == 27) {
                this.handleError(e, next, "<number> for <named number :" + identifier + ">");
            }
            if (e.currentToken.kind == 125) {
                this.handleError(e, next, "'(' for <named number :" + identifier + ">");
            }
            this.handleError(e, next, "<named number>");
        }
        return new NamedNumber(identifier, number);
    }

    public final Identifier ValueIdentifier() throws ParseException {
        Identifier identifier;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 126: {
                ModuleIdentifier module = this.ModuleIdentifier();
                Token dot_t = this.jj_consume_token(23);
                NodeToken value = this.ValueExpansion();
                identifier = Identifier.Value(module, value);
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 87: 
            case 125: {
                NodeToken value = this.ValueExpansion();
                identifier = Identifier.Value(value);
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return identifier;
    }

    public final NodeToken ValueExpansion() throws ParseException {
        Token value;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 125: {
                value = this.jj_consume_token(125);
                break;
            }
            case 87: {
                value = this.jj_consume_token(87);
                break;
            }
            case 74: {
                value = this.jj_consume_token(74);
                break;
            }
            case 75: {
                value = this.jj_consume_token(75);
                break;
            }
            case 76: {
                value = this.jj_consume_token(76);
                break;
            }
            case 77: {
                value = this.jj_consume_token(77);
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.makeNodeToken(value);
    }

    public final ModuleIdentifier ModuleIdentifier() throws ParseException {
        Token module_id = this.jj_consume_token(126);
        return new ModuleIdentifier(this.makeNodeToken(module_id));
    }

    public final Identifier TypeIdentifier() throws ParseException {
        Identifier identifier;
        if (this.jj_2_12(2)) {
            ModuleIdentifier module_id = this.ModuleIdentifier();
            Token dot_t = this.jj_consume_token(23);
            Token type = this.jj_consume_token(126);
            identifier = Identifier.Type(module_id, this.makeNodeToken(type));
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 126: {
                    Token type = this.jj_consume_token(126);
                    identifier = Identifier.Type(this.makeNodeToken(type));
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return identifier;
    }

    public final IndexPart IndexPart(Recovery next) throws ParseException {
        IndexPart index_part = new IndexList();
        block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: 
            case 65: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 63: {
                        Token sort = this.jj_consume_token(63);
                        next.push(26);
                        next.push(64);
                        next.push(125);
                        this.LBraceSymbol(next);
                        try {
                            index_part = this.IndexList();
                            next.pop();
                            next.pop();
                        }
                        catch (ParseException e) {
                            this.makeError(e.currentToken, "error in INDEX-clause");
                            this.recovery(next);
                        }
                        next.pop();
                        this.RBraceSymbol(next);
                        break block2;
                    }
                    case 65: {
                        Token sort = this.jj_consume_token(65);
                        next.push(26);
                        next.push(125);
                        this.LBraceSymbol(next);
                        try {
                            Identifier identifier = this.ValueIdentifier();
                            index_part = new IndexAugments(identifier);
                        }
                        catch (ParseException e) {
                            this.makeError(e.currentToken, "error in AUGMENTS-clause");
                            this.recovery(next);
                        }
                        next.pop();
                        this.RBraceSymbol(next);
                        break block2;
                    }
                }
                this.jj_la1[56] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
            }
        }
        return index_part;
    }

    public final IndexList IndexList() throws ParseException {
        Token implied_t;
        NodeList list = new NodeList();
        boolean implied = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                implied_t = this.jj_consume_token(64);
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
            }
        }
        Identifier identifier = this.ValueIdentifier();
        list.addNode(new Index(identifier, implied));
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    break block9;
                }
            }
            Token comma_t = this.jj_consume_token(24);
            implied = false;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 64: {
                    implied_t = this.jj_consume_token(64);
                    implied = true;
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                }
            }
            identifier = this.ValueIdentifier();
            list.addNode(new Index(identifier, implied));
        }
        list.nodes.trimToSize();
        return new IndexList(list);
    }

    public final AssignedValue AssignedValue() throws ParseException {
        Recovery next = new Recovery();
        next.push(26);
        next.push(122);
        next.push(125);
        NodeList list = new NodeList();
        this.LBraceSymbol(next);
        block3: while (true) {
            OidValue item = this.OidValue();
            list.addNode(item);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 87: 
                case 120: 
                case 121: 
                case 122: 
                case 125: 
                case 126: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[61] = this.jj_gen;
        list.nodes.trimToSize();
        next.pop(3);
        this.RBraceSymbol(next);
        return new AssignedValue(list);
    }

    public final OidValue OidValue() throws ParseException {
        OidValue oidval;
        Recovery next = new Recovery();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 87: 
            case 125: 
            case 126: {
                Identifier name = this.ValueIdentifier();
                oidval = new OidValue(name);
                if (this.getToken((int)1).kind != 27) break;
                this.LParenSymbol(next);
                oidval.setNumber(this.NumericValue());
                this.RParenSymbol(next);
                break;
            }
            case 120: 
            case 121: 
            case 122: {
                NumericValue numval = this.NumericValue();
                oidval = new OidValue(numval);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return oidval;
    }

    public final NumericValue NumericValue() throws ParseException {
        Token number;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 122: {
                number = this.jj_consume_token(122);
                break;
            }
            case 120: {
                number = this.jj_consume_token(120);
                break;
            }
            case 121: {
                number = this.jj_consume_token(121);
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new NumericValue(this.makeNodeToken(number));
    }

    DescriptionPart DescriptionPart(Recovery next) throws ParseException {
        return new DescriptionPart(this.Item_and_Text_Rule(next, 48));
    }

    ReferencePart ReferencePart(Recovery next) throws ParseException {
        return new ReferencePart(this.Item_and_Text_Option_Rule(next, 59));
    }

    ContactInfoPart ContactInfoPart(Recovery next) throws ParseException {
        return new ContactInfoPart(this.Item_and_Text_Rule(next, 47));
    }

    OrganizationPart OrganizationPart(Recovery next) throws ParseException {
        return new OrganizationPart(this.Item_and_Text_Rule(next, 46));
    }

    public final DefValPart DefValPart(Recovery next) throws ParseException {
        NodeOptional value = new NodeOptional();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 66: {
                Token defval_t = this.jj_consume_token(66);
                next.push(26);
                next.push(122);
                next.push(125);
                next.push(124);
                this.LBraceSymbol(next);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 120: 
                    case 121: 
                    case 122: {
                        NumericValue number = this.NumericValue();
                        value.addNode(number);
                        break;
                    }
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 87: 
                    case 125: 
                    case 126: {
                        Identifier identifier = this.ValueIdentifier();
                        value.addNode(identifier);
                        break;
                    }
                    case 124: {
                        Token text_t = this.jj_consume_token(124);
                        value.addNode(this.makeNodeToken(text_t));
                        break;
                    }
                    default: {
                        this.jj_la1[64] = this.jj_gen;
                        if (this.jj_2_13(2)) {
                            NodeList list = this.BitValueList(next);
                            value.addNode(new BitValueList(list));
                            break;
                        }
                        if (this.jj_2_14(2)) {
                            AssignedValue oidValue = this.AssignedValue();
                            value.addNode(oidValue);
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                next.pop(4);
                this.RBraceSymbol(next);
                break;
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
            }
        }
        return new DefValPart(value);
    }

    public final NodeList BitValueList(Recovery next) throws ParseException {
        next.push(125);
        NodeList list = new NodeList();
        this.LBraceSymbol(next);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 87: 
            case 125: 
            case 126: {
                list = this.ValueList(next);
                break;
            }
            default: {
                this.jj_la1[66] = this.jj_gen;
            }
        }
        next.pop();
        this.RBraceSymbol(next);
        return list;
    }

    DisplayHintPart DisplayHintPart(Recovery next) throws ParseException {
        return new DisplayHintPart(this.Item_and_Text_Option_Rule(next, 69));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LastUpdatedPart LastUpdatedPart(Recovery next) throws ParseException {
        Token utc_time;
        next.push(123);
        try {
            Token key = this.jj_consume_token(45);
        }
        catch (ParseException e) {
            this.handleError(e, next, "LAST-UPDATED");
        }
        finally {
            next.pop();
        }
        try {
            utc_time = this.jj_consume_token(123);
        }
        catch (ParseException e) {
            this.handleError(e, next, "LAST-UPDATED", "<utc-time>");
            utc_time = Token.newToken(123);
            utc_time.image = "";
        }
        return new LastUpdatedPart(this.makeNodeToken(utc_time));
    }

    UnitsPart UnitsPart(Recovery next) throws ParseException {
        return new UnitsPart(this.Item_and_Text_Option_Rule(next, 62));
    }

    ProductReleasePart ProductReleasePart(Recovery next) throws ParseException {
        return new ProductReleasePart(this.Item_and_Text_Rule(next, 50));
    }

    public final NodeList ObjectsPart(boolean isOption, Recovery next) throws ParseException {
        try {
            Token objects_t = this.jj_consume_token(68);
        }
        catch (ParseException e) {
            if (isOption) {
                return new NodeList();
            }
            this.handleError(e, 25, "'OBJECTS'");
        }
        NodeList list = this.BracedValueList(next);
        return list;
    }

    public final NodeList NotificationPart(Recovery next) throws ParseException {
        try {
            Token key = this.jj_consume_token(58);
        }
        catch (ParseException e) {
            if (next.contains(e.currentToken.kind)) {
                return new NodeList();
            }
            this.handleError(e, 25, "'NOTIFICATIONS'");
        }
        NodeList list = this.BracedValueList(next);
        return list;
    }

    public final EnterprisePart EnterprisePart(Recovery next) throws ParseException {
        Identifier var;
        Token key = this.jj_consume_token(71);
        try {
            var = this.ValueIdentifier();
        }
        catch (ParseException e) {
            this.handleError(e, next, "<value identifier>");
            var = Identifier.Keyword(this.makeNodeToken(125));
        }
        return new EnterprisePart(var);
    }

    public final NodeList VariablesPart(Recovery next) throws ParseException {
        NodeList list = new NodeList();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: {
                Token var = this.jj_consume_token(72);
                list = this.BracedValueList(next);
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
            }
        }
        return list;
    }

    public final NodeList BracedValueList(Recovery next) throws ParseException {
        next.push(125);
        this.LBraceSymbol(next);
        NodeList list = this.ValueList(next);
        next.pop();
        this.RBraceSymbol(next);
        return list;
    }

    public final NodeList ValueList(Recovery next) throws ParseException {
        Identifier identifier;
        NodeList list = new NodeList();
        next.push(24);
        next.push(26);
        try {
            identifier = this.ValueIdentifier();
            list.addNode(identifier);
        }
        catch (ParseException e) {
            this.handleError(e, next, "<value identifier>");
        }
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[68] = this.jj_gen;
                    break block7;
                }
            }
            try {
                Token comma_t = this.jj_consume_token(24);
                identifier = this.ValueIdentifier();
                list.addNode(identifier);
            }
            catch (ParseException e) {
                this.handleError(e, next, "<value identifier>");
            }
        }
        list.nodes.trimToSize();
        return list;
    }

    public final NodeList BracedValueTypeList() throws ParseException {
        NodeList list = new NodeList();
        Recovery next = new Recovery();
        next.push(125);
        this.LBraceSymbol(next);
        next.pop();
        next.push(24);
        next.push(26);
        ValueType value_type = this.ValueType(next);
        list.addNode(value_type);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[69] = this.jj_gen;
                    break block3;
                }
            }
            Token comma_t = this.jj_consume_token(24);
            value_type = this.ValueType(next);
            list.addNode(value_type);
        }
        next.pop();
        this.RBraceSymbol(next);
        return list;
    }

    public final ValueType ValueType(Recovery next) throws ParseException {
        Type type;
        Identifier identifier;
        try {
            identifier = this.ValueIdentifier();
        }
        catch (ParseException e) {
            this.handleError(e, next, "<value identifier>");
            return null;
        }
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 34: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 126: {
                    type = this.Types();
                    break;
                }
                case 107: 
                case 108: 
                case 109: 
                case 110: {
                    Identifier type_exception = this.TypeIdentifierException();
                    type = new TypeIdentifier(type_exception);
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException e) {
            this.handleError(e, next, "<type>");
            return null;
        }
        return new ValueType(identifier, type);
    }

    public final Identifier TypeIdentifierException() throws ParseException {
        Identifier identifier;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 107: {
                Token syntax_t = this.jj_consume_token(107);
                identifier = Identifier.Keyword(this.makeNodeToken(syntax_t));
                break;
            }
            case 108: {
                Token syntax_t = this.jj_consume_token(108);
                identifier = Identifier.Keyword(this.makeNodeToken(syntax_t));
                break;
            }
            case 109: {
                Token syntax_t = this.jj_consume_token(109);
                identifier = Identifier.Keyword(this.makeNodeToken(syntax_t));
                break;
            }
            case 110: {
                Token syntax_t = this.jj_consume_token(110);
                identifier = Identifier.Keyword(this.makeNodeToken(syntax_t));
                break;
            }
            default: {
                this.jj_la1[71] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return identifier;
    }

    public final void AssignSymbol(Recovery next) throws ParseException {
        try {
            Token assign_t = this.jj_consume_token(16);
        }
        catch (ParseException e) {
            this.handleError(e, next, "'::='");
        }
    }

    public final void LBraceSymbol(Recovery next) throws ParseException {
        try {
            this.jj_consume_token(25);
        }
        catch (ParseException e) {
            this.handleError(e, next, "'{'");
        }
    }

    public final void RBraceSymbol(Recovery next) throws ParseException {
        try {
            this.jj_consume_token(26);
        }
        catch (ParseException e) {
            this.handleError(e, next, "'}'");
        }
    }

    public final void LParenSymbol(Recovery next) throws ParseException {
        try {
            this.jj_consume_token(27);
        }
        catch (ParseException e) {
            this.handleError(e, next, "'('");
        }
    }

    public final void RParenSymbol(Recovery next) throws ParseException {
        try {
            this.jj_consume_token(28);
        }
        catch (ParseException e) {
            this.handleError(e, next, "')'");
        }
    }

    NodeToken Item_and_Text_Rule(Recovery next, int item) throws ParseException {
        NodeToken text;
        if (this.getToken((int)1).kind == item) {
            Token key = this.getNextToken();
            if (this.getToken((int)1).kind == 124) {
                text = this.makeNodeToken(this.getNextToken());
            } else {
                Message.error(key.beginLine, key + " missing <quoted string>");
                text = this.makeNodeToken(124, "<quoted string>");
            }
        } else if (this.getToken((int)1).kind == 124) {
            String str = tokenImage[item].replace('\"', '\'');
            Message.error(this.getToken((int)1).beginLine, str + " keyword missing");
            text = this.makeNodeToken(this.getNextToken());
        } else {
            StringBuffer str = new StringBuffer(tokenImage[item]);
            str.deleteCharAt(0);
            str.deleteCharAt(str.length() - 1);
            Message.error(this.getToken((int)1).beginLine, str + "-clause missing");
            this.recovery(next);
            text = this.makeNodeToken(124, "<quoted string>");
        }
        return text;
    }

    NodeOptional Item_and_Text_Option_Rule(Recovery next, int item) throws ParseException {
        NodeOptional text = new NodeOptional();
        if (this.getToken((int)1).kind == item) {
            text.addNode(this.Item_and_Text_Rule(next, item));
        }
        return text;
    }

    void ErrorRule(Recovery next, String msg) throws ParseException {
        this.makeError(this.getToken(0), msg);
        this.recovery(next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    private boolean jj_3R_54() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(125)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(87)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(74)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(75)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(76)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(77)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_16();
    }

    private boolean jj_3R_28() {
        if (this.jj_3R_50()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_51()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_52();
    }

    private boolean jj_3R_38() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_52() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_62() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(122)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(120)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(121)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_32() {
        return this.jj_3R_54();
    }

    private boolean jj_3R_64() {
        return this.jj_3R_62();
    }

    private boolean jj_3R_31() {
        if (this.jj_3R_27()) {
            return true;
        }
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_54();
    }

    private boolean jj_3R_50() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3_14() {
        return this.jj_3R_29();
    }

    private boolean jj_3R_41() {
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_32()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_24() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_23() {
        return this.jj_3R_20();
    }

    private boolean jj_3R_63() {
        return this.jj_3R_17();
    }

    private boolean jj_3R_42() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3_13() {
        return this.jj_3R_28();
    }

    private boolean jj_3R_18() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3R_37() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_23()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_24()) {
                return true;
            }
        }
        if (this.jj_3R_18()) {
            return true;
        }
        return this.jj_scan_token(114);
    }

    private boolean jj_3R_61() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_63()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_64()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_42()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_58() {
        return this.jj_scan_token(110);
    }

    private boolean jj_3R_57() {
        return this.jj_scan_token(109);
    }

    private boolean jj_3R_34() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_56() {
        return this.jj_scan_token(108);
    }

    private boolean jj_3R_55() {
        return this.jj_scan_token(107);
    }

    private boolean jj_3R_33() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_40() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_53() {
        return this.jj_3R_61();
    }

    private boolean jj_3R_60() {
        return this.jj_3R_17();
    }

    private boolean jj_3R_47() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_55()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_56()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_57()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_58()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_19() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_33()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_34()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_35()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_36()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_37()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_38()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_39()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_40()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_41()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_36() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3_11() {
        return this.jj_3R_16();
    }

    private boolean jj_3R_30() {
        return this.jj_scan_token(126);
    }

    private boolean jj_3R_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(100)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(101)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(102)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(95)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(94)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(103)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(97)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(96)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(98)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(99)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(106)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(105)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(104)) {
                                                            return true;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_10() {
        return this.jj_3R_17();
    }

    private boolean jj_3R_29() {
        Token xsp;
        if (this.jj_3R_50()) {
            return true;
        }
        if (this.jj_3R_53()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_53());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_46() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3_5() {
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_3R_18()) {
            return true;
        }
        if (this.jj_3R_21()) {
            return true;
        }
        return this.jj_3R_22();
    }

    private boolean jj_3_12() {
        if (this.jj_3R_27()) {
            return true;
        }
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(126);
    }

    private boolean jj_3R_26() {
        if (this.jj_3R_48()) {
            return true;
        }
        return this.jj_scan_token(111);
    }

    private boolean jj_3R_45() {
        return this.jj_scan_token(91);
    }

    private boolean jj_3R_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_12()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_30()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(90);
    }

    private boolean jj_3R_25() {
        if (this.jj_3R_48()) {
            return true;
        }
        return this.jj_3R_49();
    }

    private boolean jj_3R_39() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_43() {
        return this.jj_scan_token(88);
    }

    private boolean jj_3_9() {
        return this.jj_3R_26();
    }

    private boolean jj_3R_27() {
        return this.jj_scan_token(126);
    }

    private boolean jj_3R_59() {
        return this.jj_3R_62();
    }

    private boolean jj_3_8() {
        return this.jj_3R_25();
    }

    private boolean jj_3R_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_44()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_45()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_46()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_4() {
        if (this.jj_3R_17()) {
            return true;
        }
        return this.jj_3R_19();
    }

    private boolean jj_3R_35() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3_7() {
        if (this.jj_3R_17()) {
            return true;
        }
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_49() {
        return this.jj_3R_59();
    }

    private boolean jj_3R_51() {
        return this.jj_3R_60();
    }

    private boolean jj_3_2() {
        return this.jj_3R_17();
    }

    private boolean jj_3_3() {
        if (this.jj_3R_16()) {
            return true;
        }
        return this.jj_3R_18();
    }

    private boolean jj_3R_48() {
        return this.jj_scan_token(27);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0x100000, 0, 0x200000, 0, 0x1000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0x8000000, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0xA000000, 0xA000000, 0, 0x8000000, 0, 0x2000000, 0, 0x8000000, 0x2000000, 0xA000000, 0, 0x1000000, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0x1000000, 0, 0, 0, 0, 0, 0, 0, 0, 0x1000000, 0x1000000, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 8184, 0, 8184, 0, 8184, 8184, 0, 0, 8184, 68, 4028, 0, 0, 0, 0, 0, 0, 4, 131072, 0, 0, 0, 524288, 0, 0x100000, 0x200000, 0x10000000, 0x20000000, 0, 0x200000, 0x400000, 0x1000000, 0x10000000, 0x20000000, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, -1065337856, 0, -1065337856, 0, -1073741824, 0, -1073741824, -1073741824, 0, -16777216, 0, 0, 0, 0, 0, 0, 0, 0xD000000, 0, 15360, 114688, 0xFE0000, 0, 0, 0, 8, 0, 0, 114688, 8, 0, 0, 0, 0, 114688, 0, 0x1000000, 0, 0, 0, 0, 0x6000000, 0, 0x8000000, 0, 0, 0, -553648128, 0, 0, 0, 8403968, 8403968, 0, 2, 2, 1, 0, 1, 8403968, 8403968, 0, 8403968, 4, 8403968, 256, 0, 0, -553648128, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0x40000000, 0, 1610645503, 0, 1610645503, 0, Short.MAX_VALUE, 0, 2047, Short.MAX_VALUE, 0, 1073743871, 0, 0x380000, 0xC00000, 0xC00000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1792, 0, 0, 3, 0, 0, 0, 8, 0, 0, 0, 1073743871, 0, 0, 65536, 0x60000000, 0x20000000, 0x40000000, 0, 0, 0, 0, 0, 0x67000000, 0x67000000, 0x7000000, 0x77000000, 0, 0x60000000, 0, 0, 0, 1073774591, 30720};
    }

    public SmiGrammar(InputStream stream) {
        this(stream, null);
    }

    public SmiGrammar(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SmiGrammarTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SmiGrammar(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SmiGrammarTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SmiGrammar(SmiGrammarTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SmiGrammarTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[127];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 72; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 127; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 14; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SmiGrammar.jj_la1_init_0();
        SmiGrammar.jj_la1_init_1();
        SmiGrammar.jj_la1_init_2();
        SmiGrammar.jj_la1_init_3();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

