/*
 * Decompiled with CFR 0.152.
 */
package com.mod_snmp.SmiParser.MibTree;

import com.mod_snmp.SmiParser.ErrorHandler.Message;
import com.mod_snmp.SmiParser.MibTree.MibTreeException;
import com.mod_snmp.SmiParser.MibTree.MibTreeModel;
import com.mod_snmp.SmiParser.MibTree.MibTreeNode;
import com.mod_snmp.SmiParser.MibTree.MibTreeSymbolTable;
import com.mod_snmp.SmiParser.SyntaxTree.AssignedValue;
import com.mod_snmp.SmiParser.SyntaxTree.AssignmentObject;
import com.mod_snmp.SmiParser.SyntaxTree.NodeList;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoObjectIdentifier;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoTrapType;
import com.mod_snmp.SmiParser.SyntaxTree.OidValue;
import com.mod_snmp.SmiParser.Visitor.DepthFirstVisitor;
import com.mod_snmp.SmiParser.Visitor.Visitor;

public class MibTree
extends DepthFirstVisitor
implements Visitor {
    private static boolean debug = false;
    public static MibTreeModel model;
    public static MibTreeSymbolTable symbolTable;
    public static MibTreeNode root_ccitt;
    public static MibTreeNode root_iso;
    public static MibTreeNode root_iso_ccitt;

    @Override
    public void visit(AssignmentObject n) {
        try {
            if (n.info instanceof ObjectInfoTrapType) {
                return;
            }
            MibTreeNode mtn = MibTree.buildMibTreeHierarchy(n.assignedValue);
            mtn.setUserObject(n.info);
            model.reload();
        }
        catch (MibTreeException exception) {
            System.out.println(n.identifier + ":" + exception.getMessage());
            Message.error(n.identifier, exception.getMessage());
        }
    }

    private static MibTreeNode buildMibTreeHierarchy(AssignedValue val) throws MibTreeException {
        int i;
        NodeList oid_list = val.oidValue;
        for (i = 0; i < oid_list.size() - 2; ++i) {
            if (debug) {
                System.out.println("WHILE: " + i);
            }
            MibTree.makeMibTreeNode((OidValue)oid_list.elementAt(i), (OidValue)oid_list.elementAt(i + 1));
        }
        if (debug) {
            System.out.println("LAST: " + i);
        }
        return MibTree.makeMibTreeNode((OidValue)oid_list.elementAt(i), (OidValue)oid_list.elementAt(i + 1));
    }

    private static MibTreeNode makeMibTreeNode(OidValue parent, OidValue obj) throws MibTreeException {
        if (!obj.hasName()) {
            throw new MibTreeException("Cannot create MIB tree node; has no name");
        }
        if (debug) {
            System.out.println("CHILD: " + obj.getName());
        }
        MibTreeNode obj_mtn = symbolTable.retrieve(obj.getName().toString());
        if (debug) {
            System.out.println("CHILD: " + obj_mtn.toString());
        }
        obj_mtn.setNumber(obj.getNumber().getValue());
        if (!parent.hasName()) {
            throw new MibTreeException("MIB tree node under node; parent has no name");
        }
        if (debug) {
            System.out.println("PARENT: " + parent.getName());
        }
        MibTreeNode parent_mtn = symbolTable.retrieve(parent.getName().toString());
        if (debug) {
            System.out.println("PARENT: " + parent_mtn.toString());
        }
        parent_mtn.setNumber(parent.getNumber().getValue());
        parent_mtn.add(obj_mtn);
        return obj_mtn;
    }

    static {
        symbolTable = new MibTreeSymbolTable();
        try {
            root_ccitt = new MibTreeNode("ccitt", 0L);
            root_ccitt.setUserObject(new ObjectInfoObjectIdentifier());
            symbolTable.insert(root_ccitt);
        }
        catch (MibTreeException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        try {
            root_iso = new MibTreeNode("iso", 1L);
            root_iso.setUserObject(new ObjectInfoObjectIdentifier());
            symbolTable.insert(root_iso);
        }
        catch (MibTreeException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        try {
            root_iso_ccitt = new MibTreeNode("joint-iso-ccitt", 2L);
            root_iso_ccitt.setUserObject(new ObjectInfoObjectIdentifier());
            symbolTable.insert(root_iso_ccitt);
        }
        catch (MibTreeException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        model = new MibTreeModel(root_iso);
    }
}

