/*
 * Decompiled with CFR 0.152.
 */
package com.mod_snmp.SmiParser.MibTree;

import com.mod_snmp.SmiParser.MibTree.MibTreeException;
import com.mod_snmp.SmiParser.MibTree.MibTreeObjectVisitor;
import com.mod_snmp.SmiParser.MibTree.MibTreeVisitor;
import com.mod_snmp.SmiParser.SyntaxTree.Identifier;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfo;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoObjectType;
import javax.swing.tree.DefaultMutableTreeNode;

public class MibTreeNode
extends DefaultMutableTreeNode {
    private String name;
    private long number;

    public MibTreeNode(String n) {
        this.name = n;
        this.number = -1L;
    }

    public MibTreeNode(String n, long nr) {
        this.name = n;
        this.number = nr;
    }

    public void add(MibTreeNode child) throws MibTreeException {
        int child_index;
        long child_number = child.getNumber();
        for (child_index = 0; child_index < this.getChildCount(); ++child_index) {
            MibTreeNode current = (MibTreeNode)this.getChildAt(child_index);
            if (child_number == current.getNumber()) {
                if (!current.getName().equals(child.getName())) {
                    throw new MibTreeException("oid number value for " + current.getName() + " and " + child.getName() + " are equal");
                }
                return;
            }
            if (child_number >= current.getNumber()) continue;
            this.insert(child, child_index);
            return;
        }
        this.insert(child, child_index);
    }

    public void setNumber(long nr) throws MibTreeException {
        if (this.number == -1L) {
            this.number = nr;
        } else if (nr > -1L && this.number != nr) {
            throw new MibTreeException("cannot assign a number " + nr);
        }
    }

    public long getNumber() {
        return this.number;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setName(Identifier id) {
        this.name = id.toString();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name + "(" + this.number + ")";
    }

    public boolean isManagedInstance() {
        return this.userObject instanceof ObjectInfoObjectType && this.isLeaf();
    }

    public boolean managesInstances() {
        for (int child_index = 0; child_index < this.getChildCount(); ++child_index) {
            MibTreeNode mtn = (MibTreeNode)this.getChildAt(child_index);
            if (!mtn.isManagedInstance()) continue;
            return true;
        }
        return false;
    }

    public boolean isConceptualRow() {
        return ((ObjectInfo)this.userObject).isConceptualRow();
    }

    public boolean isScalar() {
        if (this.isInstance() && this.isLeaf() && this.parent != null) {
            return !((MibTreeNode)this.parent).isInstance();
        }
        return false;
    }

    public boolean isColumnar() {
        if (this.isInstance() && this.isLeaf() && this.parent != null) {
            return ((MibTreeNode)this.parent).isInstance();
        }
        return false;
    }

    public boolean isTable() {
        if (this.isInstance() && this.parent != null && !((MibTreeNode)this.parent).isInstance()) {
            return this.getChildCount() == 1;
        }
        return false;
    }

    public boolean isInstance() {
        return this.userObject instanceof ObjectInfoObjectType;
    }

    public void accept(MibTreeVisitor v) {
        v.visit(this);
    }

    public Object accept(MibTreeObjectVisitor v, Object argu) {
        return v.visit(this, argu);
    }
}

