/*
 * Decompiled with CFR 0.152.
 */
package com.mod_snmp.SmiParser.MibTree;

import com.mod_snmp.SmiParser.MibTree.MibTreeException;
import com.mod_snmp.SmiParser.MibTree.MibTreeNode;
import com.mod_snmp.SmiParser.SyntaxTree.Identifier;
import java.util.Hashtable;

public class MibTreeSymbolTable
extends Hashtable<String, MibTreeNode> {
    private static boolean debug = false;

    public void insert(MibTreeNode node) throws MibTreeException {
        try {
            if (debug) {
                this.dump("insert(MibTreeNode node)" + node.getName());
            }
            this.insert(node.getName(), node);
        }
        catch (NullPointerException exception) {
            throw new MibTreeException("invalid key \"null\"");
        }
    }

    public void insert(String key, MibTreeNode node) throws MibTreeException {
        try {
            if (debug) {
                this.dump("insert(String key, MibTreeNode node)" + key);
            }
            if (this.containsKey(key)) {
                throw new MibTreeException("existing key \"" + key + "\"");
            }
            this.put(key, node);
        }
        catch (NullPointerException exception) {
            throw new MibTreeException("invalid key \"null\"");
        }
    }

    public MibTreeNode lookup(String key) throws MibTreeException {
        try {
            if (debug) {
                this.dump("lookup(String key)" + key);
            }
            if (this.containsKey(key)) {
                return (MibTreeNode)this.get(key);
            }
            throw new MibTreeException("key \"" + key + "\" does not exist");
        }
        catch (NullPointerException exception) {
            throw new MibTreeException("invalid key \"null\"");
        }
    }

    public MibTreeNode lookup(Identifier key) throws MibTreeException {
        return this.lookup(key.toString());
    }

    public MibTreeNode retrieve(String key) throws MibTreeException {
        try {
            if (debug) {
                this.dump("retrieve(String key)" + key);
            }
            if (this.containsKey(key)) {
                return (MibTreeNode)this.get(key);
            }
            MibTreeNode node = new MibTreeNode(key);
            this.put(key, node);
            return node;
        }
        catch (NullPointerException exception) {
            throw new MibTreeException("invalid key \"null\"");
        }
    }

    public boolean exists(String key) {
        try {
            if (debug) {
                this.dump("exists(String key)" + key);
            }
            return this.containsKey(key);
        }
        catch (NullPointerException exception) {
            return false;
        }
    }

    public boolean exists(Identifier key) {
        return this.exists(key.toString());
    }

    private void dump(String s) {
        System.out.println("MTS:" + s);
    }
}

