/*
 * Decompiled with CFR 0.152.
 */
package com.mod_snmp.SmiParser;

import com.mod_snmp.SmiParser.ErrorHandler.MessageList;
import com.mod_snmp.SmiParser.ErrorHandler.SmiException;
import com.mod_snmp.SmiParser.Grammar.ParseException;
import com.mod_snmp.SmiParser.Grammar.SmiGrammar;
import com.mod_snmp.SmiParser.MibTree.MibTree;
import com.mod_snmp.SmiParser.ParserInputArgs;
import com.mod_snmp.SmiParser.Semantics.SemanticsCheck;
import com.mod_snmp.SmiParser.Semantics.SemanticsSetup;
import com.mod_snmp.SmiParser.SyntaxTree.NodeList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import net.lisanza.CliArgs.ArgsException;

public class Parser {
    private static boolean debug = true;
    public NodeList moduleList;

    public static NodeList parseFiles(Enumeration<String> e) throws SmiException {
        try {
            NodeList result = new NodeList();
            while (e.hasMoreElements()) {
                String filename = e.nextElement();
                if (debug) {
                    Parser.dump("File: " + filename);
                }
                if (!new File(filename).exists()) {
                    filename = filename + ".txt";
                }
                result.addNode(Parser.parseFile(filename));
            }
            return result;
        }
        catch (FileNotFoundException exception) {
            throw new SmiException(exception.getMessage());
        }
        catch (NullPointerException exception) {
            throw new SmiException("input file: <>");
        }
    }

    public static NodeList parseFile(String name) throws FileNotFoundException, SmiException {
        if (debug) {
            Parser.dump("Parser: " + name);
        }
        return Parser.parseFile(new FileInputStream(new File(name)));
    }

    public static NodeList parseFile(FileInputStream file) throws SmiException {
        try {
            if (debug) {
                Parser.dump("Parser: starting");
            }
            SmiGrammar grammar = new SmiGrammar(file);
            NodeList grammarroot = grammar.ModuleDefinitionList();
            if (debug) {
                Parser.dump("Parser: parsing done");
            }
            if (MessageList.list.hasErrors()) {
                throw new SmiException("The SMI file; unrecoverable syntaxtical errors");
            }
            grammarroot.accept(new SemanticsSetup());
            grammarroot.accept(new SemanticsCheck());
            if (debug) {
                Parser.dump("Parser: semantics done");
            }
            if (MessageList.list.hasErrors()) {
                throw new SmiException("The SMI file; unrecoverable semantical errors");
            }
            grammarroot.accept(new MibTree());
            if (debug) {
                Parser.dump("Parser: mibtree done");
            }
            if (MessageList.list.hasErrors()) {
                throw new SmiException("The SMI file; unrecoverable mib tree errors");
            }
            if (debug) {
                Parser.dump("Parser: done");
            }
            return grammarroot;
        }
        catch (ParseException e) {
            throw new SmiException("The SMI file; unrecoverable error");
        }
    }

    private static void dump(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        try {
            ParserInputArgs input = new ParserInputArgs();
            input.parse(args);
            Parser.parseFiles(input.getFiles());
        }
        catch (ArgsException e) {
            System.out.println(e.getMessage());
        }
        catch (SmiException e) {
            System.out.println(e.getMessage());
            e.print();
        }
    }
}

