/*
 * Decompiled with CFR 0.152.
 */
package com.mod_snmp.SmiParser;

import com.mod_snmp.SmiParser.ParserInput;
import com.mod_snmp.SmiParser.ParserPreferences;
import java.util.Enumeration;
import net.lisanza.CliArgs.ArgsException;
import net.lisanza.CliArgs.ArgsHandlerInterface;
import net.lisanza.CliArgs.ArgsReader;

public class ParserInputArgs
extends ArgsReader {
    private ParserInput config;

    public ParserInputArgs() throws ArgsException {
        this.addHandler(new DirectoryLocation());
        this.addHandler(new MibModules());
        this.addHandler(new License());
        this.config = new ParserInput(ParserPreferences.getDefaults());
    }

    public String getMibDirectory() {
        return this.config.getMibDirectory();
    }

    public void setMibDirectory(String mibDirectory) {
        this.config.setMibDirectory(mibDirectory);
    }

    public Enumeration<String> getFiles() {
        return this.config.getFiles();
    }

    private class License
    implements ArgsHandlerInterface {
        @Override
        public int parse(String[] args, int idx) throws ArgsException {
            System.out.println("LICENSE can be found at http://www.lisanza.net/SnmpToolBox/LICENSE");
            System.out.println("or look in the COPYING file of this package");
            System.exit(0);
            return ++idx;
        }

        @Override
        public String argument() {
            return "-l";
        }

        @Override
        public String usage() {
            return "license";
        }
    }

    private class MibModules
    implements ArgsHandlerInterface {
        @Override
        public int parse(String[] args, int idx) throws ArgsException {
            ++idx;
            while (idx < args.length && args[idx].charAt(0) != '-') {
                ParserInputArgs.this.config.addMibModule(args[idx++]);
            }
            return idx;
        }

        @Override
        public String argument() {
            return "-m";
        }

        @Override
        public String usage() {
            return "location of MIB modules <string>";
        }
    }

    private class DirectoryLocation
    implements ArgsHandlerInterface {
        @Override
        public int parse(String[] args, int idx) throws ArgsException {
            int n = ++idx;
            ParserInputArgs.this.config.setMibDirectory(args[n]);
            return ++idx;
        }

        @Override
        public String argument() {
            return "-d";
        }

        @Override
        public String usage() {
            return "location of MIB modules <string>";
        }
    }
}

