/*
 * Decompiled with CFR 0.152.
 */
package com.mod_snmp.SmiParser.Semantics;

import com.mod_snmp.SmiParser.ErrorHandler.CriticalException;
import com.mod_snmp.SmiParser.ErrorHandler.ErrorException;
import com.mod_snmp.SmiParser.ErrorHandler.SmiException;
import com.mod_snmp.SmiParser.Semantics.SymbolHashTable;
import com.mod_snmp.SmiParser.SyntaxTree.ModuleIdentifier;
import java.util.Hashtable;

public class ModuleHashTable {
    public static Hashtable<String, SymbolHashTable> hash = new Hashtable();

    public static void insert(String key, SymbolHashTable table) throws SmiException {
        try {
            if (hash.containsKey(key)) {
                throw new ErrorException("existing key \"" + key + "\"");
            }
            hash.put(key, table);
        }
        catch (NullPointerException e) {
            throw new CriticalException("invalid key \"null\"");
        }
    }

    public static void insert(ModuleIdentifier key, SymbolHashTable table) throws SmiException {
        ModuleHashTable.insert(key.toString(), table);
    }

    public static SymbolHashTable lookup(String key) throws SmiException {
        try {
            if (hash.containsKey(key)) {
                return hash.get(key);
            }
            throw new ErrorException("key \"" + key + "\" does not exist");
        }
        catch (NullPointerException e) {
            throw new CriticalException("invalid key \"null\"");
        }
    }

    public static SymbolHashTable lookup(ModuleIdentifier key) throws SmiException {
        return ModuleHashTable.lookup(key.toString());
    }

    public static boolean exists(String key) {
        try {
            return hash.containsKey(key);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static boolean exists(ModuleIdentifier key) {
        return ModuleHashTable.exists(key.toString());
    }
}

