/*
 * Decompiled with CFR 0.152.
 */
package com.mod_snmp.SmiParser.Semantics;

import com.mod_snmp.SmiParser.ErrorHandler.ErrorException;
import com.mod_snmp.SmiParser.ErrorHandler.Message;
import com.mod_snmp.SmiParser.ErrorHandler.SmiException;
import com.mod_snmp.SmiParser.Semantics.ModuleHashTable;
import com.mod_snmp.SmiParser.Semantics.SemanticsException;
import com.mod_snmp.SmiParser.Semantics.SymbolHashTable;
import com.mod_snmp.SmiParser.SyntaxTree.AccessPart;
import com.mod_snmp.SmiParser.SyntaxTree.AssignedValue;
import com.mod_snmp.SmiParser.SyntaxTree.AssignmentMacro;
import com.mod_snmp.SmiParser.SyntaxTree.AssignmentObject;
import com.mod_snmp.SmiParser.SyntaxTree.AssignmentType;
import com.mod_snmp.SmiParser.SyntaxTree.BitValueList;
import com.mod_snmp.SmiParser.SyntaxTree.ComplianceGroup;
import com.mod_snmp.SmiParser.SyntaxTree.ComplianceObject;
import com.mod_snmp.SmiParser.SyntaxTree.CompliancePart;
import com.mod_snmp.SmiParser.SyntaxTree.ContactInfoPart;
import com.mod_snmp.SmiParser.SyntaxTree.DefValPart;
import com.mod_snmp.SmiParser.SyntaxTree.DescriptionPart;
import com.mod_snmp.SmiParser.SyntaxTree.DisplayHintPart;
import com.mod_snmp.SmiParser.SyntaxTree.EnterprisePart;
import com.mod_snmp.SmiParser.SyntaxTree.Identifier;
import com.mod_snmp.SmiParser.SyntaxTree.Index;
import com.mod_snmp.SmiParser.SyntaxTree.IndexAugments;
import com.mod_snmp.SmiParser.SyntaxTree.IndexList;
import com.mod_snmp.SmiParser.SyntaxTree.LastUpdatedPart;
import com.mod_snmp.SmiParser.SyntaxTree.MacroBody;
import com.mod_snmp.SmiParser.SyntaxTree.ModuleCapability;
import com.mod_snmp.SmiParser.SyntaxTree.ModuleCompliance;
import com.mod_snmp.SmiParser.SyntaxTree.ModuleDefinition;
import com.mod_snmp.SmiParser.SyntaxTree.ModuleIdentifier;
import com.mod_snmp.SmiParser.SyntaxTree.ModuleImport;
import com.mod_snmp.SmiParser.SyntaxTree.NamedNumber;
import com.mod_snmp.SmiParser.SyntaxTree.NodeList;
import com.mod_snmp.SmiParser.SyntaxTree.NumericValue;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoAgentCapabilities;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoModuleCompliance;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoModuleIdentity;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoNotificationGroup;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoNotificationType;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoObjectGroup;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoObjectIdentifier;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoObjectIdentity;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoObjectType;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoTrapType;
import com.mod_snmp.SmiParser.SyntaxTree.OidValue;
import com.mod_snmp.SmiParser.SyntaxTree.OrganizationPart;
import com.mod_snmp.SmiParser.SyntaxTree.ProductReleasePart;
import com.mod_snmp.SmiParser.SyntaxTree.RangeItem;
import com.mod_snmp.SmiParser.SyntaxTree.RangeList;
import com.mod_snmp.SmiParser.SyntaxTree.ReferencePart;
import com.mod_snmp.SmiParser.SyntaxTree.RestrictionNamedNumberList;
import com.mod_snmp.SmiParser.SyntaxTree.RestrictionRange;
import com.mod_snmp.SmiParser.SyntaxTree.RestrictionSize;
import com.mod_snmp.SmiParser.SyntaxTree.Revision;
import com.mod_snmp.SmiParser.SyntaxTree.StatusPart;
import com.mod_snmp.SmiParser.SyntaxTree.SyntaxPart;
import com.mod_snmp.SmiParser.SyntaxTree.Type;
import com.mod_snmp.SmiParser.SyntaxTree.TypeChoice;
import com.mod_snmp.SmiParser.SyntaxTree.TypeIdentifier;
import com.mod_snmp.SmiParser.SyntaxTree.TypeSequence;
import com.mod_snmp.SmiParser.SyntaxTree.TypeSequenceOf;
import com.mod_snmp.SmiParser.SyntaxTree.TypeSmi;
import com.mod_snmp.SmiParser.SyntaxTree.TypeTag;
import com.mod_snmp.SmiParser.SyntaxTree.TypeTextualConvention;
import com.mod_snmp.SmiParser.SyntaxTree.UnitsPart;
import com.mod_snmp.SmiParser.SyntaxTree.ValueType;
import com.mod_snmp.SmiParser.SyntaxTree.VariationPart;
import com.mod_snmp.SmiParser.SyntaxTree.WriteSyntaxPart;
import com.mod_snmp.SmiParser.Visitor.DepthFirstVisitor;
import com.mod_snmp.SmiParser.Visitor.Visitor;
import java.util.Enumeration;

public class SemanticsCheck
extends DepthFirstVisitor
implements Visitor {
    private static SymbolHashTable current;

    @Override
    public void visit(ModuleDefinition n) {
        try {
            current = ModuleHashTable.lookup(n.moduleIdentifier);
        }
        catch (SmiException exception) {
            Message.notice(n.moduleIdentifier, "module is not loaded");
        }
        this.checkVariablesDefined(n.exports_list, current, "exported, but not defined in this module, " + n.moduleIdentifier);
        n.import_module_list.accept(this);
        n.assignmentList.accept(this);
    }

    @Override
    public void visit(ModuleImport n) {
        try {
            SymbolHashTable table = ModuleHashTable.lookup(n.moduleIdentifier);
            Enumeration implist = n.symbolList.elements();
            while (implist.hasMoreElements()) {
                Identifier id = (Identifier)implist.nextElement();
                if (!table.exists(id)) {
                    Message.warning(id, "imported, but not defined in module, " + n.moduleIdentifier);
                }
                if (id.getKind() != -2) continue;
                try {
                    Type type = (Type)table.lookup(id);
                    current.replace(id, type.getGenericType());
                }
                catch (ErrorException exception) {
                    Message.error(id, exception.getMessage() + " in symbol table");
                }
                catch (ClassCastException exception) {
                    System.err.println("Class casting error ");
                }
            }
        }
        catch (SmiException exception) {
            Message.notice(n.moduleIdentifier, "module is not loaded");
            Enumeration implist = n.symbolList.elements();
            while (implist.hasMoreElements()) {
                Identifier id = (Identifier)implist.nextElement();
                if (id.getKind() != -2) continue;
                try {
                    TypeIdentifier dummy_type = new TypeIdentifier(id);
                    dummy_type.setGenericType(dummy_type);
                    current.replace(id, dummy_type);
                }
                catch (ErrorException utils_exception) {}
            }
        }
    }

    @Override
    public void visit(AssignmentType n) {
        n.type.accept(this);
    }

    @Override
    public void visit(TypeSequence n) {
        n.vtList.accept(this);
    }

    @Override
    public void visit(TypeTextualConvention n) {
        n.syntax.accept(this);
    }

    @Override
    public void visit(TypeChoice n) {
    }

    @Override
    public void visit(TypeTag n) {
    }

    @Override
    public void visit(TypeIdentifier n) {
        try {
            Type tp = (Type)current.lookup(n.identifier);
            n.setGenericType(tp.getGenericType());
        }
        catch (ErrorException exception) {
            Message.warning(n.identifier, "not defined or imported in this module");
        }
        catch (ClassCastException exception) {
            Message.alert(n.identifier, "Internal error");
        }
    }

    @Override
    public void visit(TypeSequenceOf n) {
        if (!current.exists(n.identifier.identifier)) {
            Message.warning(n.identifier, "not defined or imported in this module");
        }
    }

    @Override
    public void visit(AssignmentMacro n) {
    }

    @Override
    public void visit(AssignmentObject n) {
        try {
            this.checkAssignedValue(n.identifier, n.assignedValue);
        }
        catch (SemanticsException exception) {
            Message.error(n.identifier, exception.getMessage());
        }
        n.info.accept(this);
    }

    @Override
    public void visit(ObjectInfoObjectIdentifier n) {
    }

    @Override
    public void visit(MacroBody n) {
    }

    @Override
    public void visit(ObjectInfoObjectType n) {
        Type tp;
        if (!current.exists("OBJECT-TYPE")) {
            Message.warning(n.line(), "'OBJECT-TYPE' not imported");
            try {
                current.insert("OBJECT-TYPE", n);
            }
            catch (ErrorException exception) {
                // empty catch block
            }
        }
        n.syntaxPart.accept(this);
        int accesstype = n.max_access.getAccessType();
        int accessvalue = n.max_access.getAccessValue();
        if (accesstype != 79) {
            Message.error(n.max_access.key, "must be 'MAX-ACCESS'");
        }
        if (accessvalue == 87 || accessvalue == 86) {
            Message.error(n.max_access.value, "is not allowed for MAX-ACCESS-clause");
        }
        if ((tp = n.syntaxPart.getGenericType()) instanceof TypeSmi) {
            int kind = ((TypeSmi)tp).getKind();
            if (n.defValPart.present() && (kind == 95 || kind == 94 || kind == 103)) {
                Message.error(n.defValPart.line(), "DEF-VAL not allowed with '" + tp + "' type");
            }
            if (accessvalue != 83 && accessvalue != 82 && (kind == 95 || kind == 94 || kind == 103)) {
                Message.error(n.max_access, "access not allowed with syntax '" + tp + "' type" + "\n\tmay only be 'read-only' or 'accessible-for-notify'");
            }
        }
    }

    @Override
    public void visit(ObjectInfoModuleIdentity n) {
        if (!current.exists("MODULE-IDENTITY")) {
            Message.warning(n.line(), "'MODULE-IDENTITY' not imported");
            try {
                current.insert("MODULE-IDENTITY", n);
            }
            catch (ErrorException errorException) {
                // empty catch block
            }
        }
        if (this.checkRevisions(n.revisions, n.lastUpdatedPart)) {
            Message.warning(n.lastUpdatedPart, "update time is not added to revision list");
        }
    }

    public boolean checkRevisions(NodeList revisions, LastUpdatedPart last_update) {
        String updated = last_update.toString();
        for (int i = 0; i < revisions.size(); ++i) {
            Revision revision = (Revision)revisions.elementAt(i);
            if (!updated.equals(revision.time.toString())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visit(ObjectInfoObjectIdentity n) {
        if (!current.exists("OBJECT-IDENTITY")) {
            Message.warning(n.line(), "'OBJECT-IDENTITY' not imported");
            try {
                current.insert("OBJECT-IDENTITY", n);
            }
            catch (ErrorException errorException) {
                // empty catch block
            }
        }
    }

    @Override
    public void visit(ObjectInfoObjectGroup n) {
        if (!current.exists("OBJECT-GROUP")) {
            Message.warning(n.line(), "'OBJECT-GROUP' not imported");
            try {
                current.insert("OBJECT-GROUP", n);
            }
            catch (ErrorException errorException) {
                // empty catch block
            }
        }
        this.checkVariablesDefined(n.objectsPart);
    }

    @Override
    public void visit(ObjectInfoNotificationType n) {
        if (!current.exists("NOTIFICATION-TYPE")) {
            Message.warning(n.line(), "'NOTIFICATION-TYPE' not imported");
            try {
                current.insert("NOTIFICATION-TYPE", n);
            }
            catch (ErrorException errorException) {
                // empty catch block
            }
        }
        this.checkVariablesDefined(n.objectsPart);
    }

    @Override
    public void visit(ObjectInfoNotificationGroup n) {
        if (!current.exists("NOTIFICATION-GROUP")) {
            Message.warning(n.line(), "'NOTIFICATION-GROUP' not imported");
            try {
                current.insert("NOTIFICATION-GROUP", n);
            }
            catch (ErrorException errorException) {
                // empty catch block
            }
        }
        this.checkVariablesDefined(n.notifications);
    }

    @Override
    public void visit(ObjectInfoModuleCompliance n) {
        if (!current.exists("MODULE-COMPLIANCE")) {
            Message.warning(n.line(), "'MODULE-COMPLIANCE' not imported");
            try {
                current.insert("MODULE-COMPLIANCE", n);
            }
            catch (ErrorException errorException) {
                // empty catch block
            }
        }
        n.moduleCompliancePart.accept(this);
    }

    @Override
    public void visit(ObjectInfoAgentCapabilities n) {
        if (!current.exists("AGENT-CAPABILITIES")) {
            Message.warning(n.line(), "'AGENT-CAPABILITIES' not imported");
            try {
                current.insert("AGENT-CAPABILITIES", n);
            }
            catch (ErrorException errorException) {
                // empty catch block
            }
        }
        n.moduleCapabilitiesPart.accept(this);
    }

    @Override
    public void visit(ObjectInfoTrapType n) {
        if (!current.exists("TRAP-TYPE")) {
            Message.warning(n.line(), "'TRAP-TYPE' not imported");
            try {
                current.insert("TRAP-TYPE", n);
            }
            catch (ErrorException errorException) {
                // empty catch block
            }
        }
        this.checkVariablesDefined(n.variablesPart);
    }

    @Override
    public void visit(StatusPart n) {
        n.value.accept(this);
    }

    @Override
    public void visit(ModuleCompliance n) {
        try {
            SymbolHashTable table;
            String msg;
            if (n.module_id.present()) {
                msg = "not defined in this module '" + n.module_id + "'";
                table = ModuleHashTable.lookup(n.module_id.toString());
                this.checkVariablesDefined((NodeList)n.mandatory_part.node, ModuleHashTable.lookup(n.module_id.toString()), msg);
            } else {
                msg = "not defined in this module";
                table = current;
                if (n.mandatory_part.node != null) {
                    this.checkVariablesDefined((NodeList)n.mandatory_part.node);
                }
            }
            if (n.compliance_part.present()) {
                Enumeration e = n.compliance_part.elements();
                while (e.hasMoreElements()) {
                    CompliancePart compliance = (CompliancePart)e.nextElement();
                    if (table.exists(compliance.getIdentifier())) continue;
                    Message.warning(compliance, msg);
                }
            }
        }
        catch (SmiException exception) {
            Message.error(n.module_id, "module is not loaded");
        }
    }

    @Override
    public void visit(ModuleCapability n) {
        try {
            this.checkVariablesDefined(n.object_list, ModuleHashTable.lookup(n.module_id.toString()), "not defined in this module '" + n.module_id + "'");
        }
        catch (SmiException exception) {
            Message.error(n.module_id, "module is not loaded");
        }
    }

    @Override
    public void visit(VariationPart n) {
        try {
            AssignmentObject obj = (AssignmentObject)current.lookup(n.identifier);
            if (!(obj.info instanceof ObjectInfoObjectType)) {
                if (obj.info instanceof ObjectInfoNotificationType) {
                    if (n.syntaxPart.present()) {
                        Message.error(n.syntaxPart, "not allowed for VARIATION of NOTIFICATION-TYPE" + n.identifier);
                    }
                    if (n.write_syntax.present()) {
                        Message.error(n.write_syntax, "not allowed for VARIATION of NOTIFICATION-TYPE" + n.identifier);
                    }
                    if (n.access.present()) {
                        int accesstype = ((AccessPart)n.access.node).getAccessType();
                        int accessvalue = ((AccessPart)n.access.node).getAccessValue();
                        if (accesstype != 78) {
                            Message.error(((AccessPart)n.access.node).key, "must be 'ACCESS'");
                        }
                        if (accessvalue == 87 || accessvalue == 86) {
                            Message.error(((AccessPart)n.access.node).value, "is not allowed for ACCESS-clause");
                        }
                    }
                    if (n.creation_requires.present()) {
                        Message.error(n.creation_requires, "not allowed for VARIATION of NOTIFICATION-TYPE" + n.identifier);
                    }
                    if (n.defValPart.present()) {
                        Message.error(n.defValPart, "not allowed for VARIATION of NOTIFICATION-TYPE" + n.identifier);
                    }
                    n.descriptionPart.accept(this);
                } else {
                    Message.error(n.identifier, "identifier is not allowed in a VARIATION-clause");
                }
            }
        }
        catch (SmiException smiException) {
            // empty catch block
        }
    }

    @Override
    public void visit(SyntaxPart n) {
        n.type.accept(this);
    }

    @Override
    public void visit(WriteSyntaxPart n) {
        n.type.accept(this);
    }

    @Override
    public void visit(ComplianceGroup n) {
        n.identifier.accept(this);
        n.description.accept(this);
    }

    @Override
    public void visit(ComplianceObject n) {
        n.identifier.accept(this);
        n.syntax.accept(this);
        n.write_syntax.accept(this);
        if (n.min_access.present()) {
            int accesstype = ((AccessPart)n.min_access.node).getAccessType();
            int accessvalue = ((AccessPart)n.min_access.node).getAccessValue();
            if (accesstype != 80) {
                Message.error(((AccessPart)n.min_access.node).key, "must be 'MIN-ACCESS'");
            }
            if (accessvalue == 81) {
                Message.error(((AccessPart)n.min_access.node).value, "is not allowed for MIN-ACCESS-clause");
            }
        }
        n.description.accept(this);
    }

    @Override
    public void visit(TypeSmi n) {
        n.base.accept(this);
        n.restriction.accept(this);
    }

    @Override
    public void visit(RestrictionRange n) {
        n.range.accept(this);
    }

    @Override
    public void visit(RestrictionSize n) {
        n.range.accept(this);
    }

    @Override
    public void visit(RestrictionNamedNumberList n) {
        n.list.accept(this);
        if (n.list.present()) {
            long first = ((NamedNumber)n.list.firstElement()).getValue();
            if (first != 1L) {
                Message.warning((NamedNumber)n.list.firstElement(), "named number list does not start with 1");
            }
            for (int i = 1; i < n.list.size(); ++i) {
                long current = ((NamedNumber)n.list.elementAt(i)).getValue();
                if (++first == current) continue;
                first = current;
                Message.warning((NamedNumber)n.list.elementAt(i), "named number list is not monotonically increasing");
            }
        }
    }

    @Override
    public void visit(RangeList n) {
        n.list.accept(this);
        for (int i = 1; i < n.list.size(); ++i) {
            this.checkRangeOrder((RangeItem)n.list.elementAt(i - 1), (RangeItem)n.list.elementAt(i));
        }
    }

    private void checkRangeOrder(RangeItem first, RangeItem last) {
        if (first.getLastValue() > last.getFirstValue()) {
            Message.warning(last, "range order not increasing or overlapping");
        }
    }

    @Override
    public void visit(RangeItem n) {
        if (n.end.present() && n.getFirstValue() > n.getLastValue()) {
            Message.warning(n.begin, "range start higher then it ends");
        }
    }

    @Override
    public void visit(NamedNumber n) {
        String name = n.name.toString();
        if (name.indexOf(45) >= 0) {
            Message.warning(n.name, "contains a not allowed hyphen, '-'");
        }
    }

    @Override
    public void visit(Identifier n) {
        if (n.module_identifier != null) {
            n.module_identifier.accept(this);
        }
        n.identifier.accept(this);
    }

    @Override
    public void visit(ModuleIdentifier n) {
        n.nodeToken.accept(this);
    }

    @Override
    public void visit(IndexAugments n) {
        n.identifier.accept(this);
    }

    @Override
    public void visit(Index n) {
    }

    @Override
    public void visit(IndexList n) {
        if (n.list.present()) {
            int i = 1;
            Enumeration e = n.list.elements();
            while (e.hasMoreElements()) {
                Index item = (Index)e.nextElement();
                try {
                    AssignmentObject obj = (AssignmentObject)current.lookup(item.identifier);
                    obj.info.setIndexLevel(i++);
                }
                catch (SmiException exception) {
                    Message.error(item.identifier, "not defined or imported in this module");
                }
            }
        }
    }

    @Override
    public void visit(AssignedValue n) {
        n.oidValue.accept(this);
    }

    @Override
    public void visit(OidValue n) {
        if (n.hasName()) {
            n.name.accept(this);
            if (n.hasNumber()) {
                n.numval.accept(this);
            }
        } else if (n.hasNumber()) {
            n.numval.accept(this);
        }
    }

    @Override
    public void visit(NumericValue n) {
        n.value.accept(this);
    }

    @Override
    public void visit(DescriptionPart n) {
        n.descr.accept(this);
    }

    @Override
    public void visit(ReferencePart n) {
        n.nodeOptional.accept(this);
    }

    @Override
    public void visit(ContactInfoPart n) {
        n.nodeToken.accept(this);
    }

    @Override
    public void visit(OrganizationPart n) {
        n.nodeToken.accept(this);
    }

    @Override
    public void visit(DefValPart n) {
        n.nodeOptional.accept(this);
    }

    @Override
    public void visit(BitValueList n) {
        n.list.accept(this);
    }

    @Override
    public void visit(DisplayHintPart n) {
        if (n.present()) {
            n.display_hint.accept(this);
        }
    }

    @Override
    public void visit(LastUpdatedPart n) {
        n.nodeToken.accept(this);
    }

    @Override
    public void visit(UnitsPart n) {
        n.nodeOptional.accept(this);
    }

    @Override
    public void visit(ProductReleasePart n) {
        n.nodeToken.accept(this);
    }

    @Override
    public void visit(EnterprisePart n) {
        if (!current.exists(n.identifier)) {
            Message.warning(n.identifier, "not defined or imported in this module");
        }
    }

    @Override
    public void visit(ValueType n) {
        if (!current.exists(n.identifier)) {
            Message.error(n.identifier, "not defined or imported in this module");
        }
        if (n.type.restrictionPresent()) {
            Message.error(n.type, "sub typing is not allowed in a SEQUENCE definition");
        }
    }

    private void checkAssignedValue(Identifier id, AssignedValue val) throws SemanticsException {
        OidValue child;
        int val_size = val.oidValue.size();
        if (val_size < 2) {
            Message.error(id, "has no parent defined (need 2 oids at least)");
            return;
        }
        OidValue parent = (OidValue)val.oidValue.firstElement();
        if (3L <= parent.getNumber().getValue()) {
            Message.error(id, "parent number " + parent.getNumber() + " not accepted");
        }
        if ((child = (OidValue)val.oidValue.lastElement()).hasName()) {
            if (!id.equals(child.getName())) {
                throw new SemanticsException("different name as the last Oid");
            }
        } else {
            child.setName(id);
        }
        if (parent.hasName()) {
            for (int i = 0; i < val_size - 2; ++i) {
                parent = (OidValue)val.oidValue.elementAt(i);
                child = (OidValue)val.oidValue.elementAt(i + 1);
                if (child.hasName() && !child.hasNumber()) {
                    throw new SemanticsException("name only is not allowed");
                }
                if (child.hasName()) continue;
                String newname = new String(parent.getName() + "." + child.getNumber().getValue());
                ((OidValue)val.oidValue.elementAt(i + 1)).setName(newname);
            }
        }
    }

    private void checkVariablesDefined(NodeList list) {
        this.checkVariablesDefined(list, current, "not defined or imported in this module");
    }

    private void checkVariablesDefined(NodeList list, ModuleIdentifier mod_id) {
        try {
            SymbolHashTable table = ModuleHashTable.lookup(mod_id);
            this.checkVariablesDefined(list, table, "not defined in module '" + mod_id + "'");
        }
        catch (SmiException exception) {
            Message.error(mod_id, "module is not loaded");
        }
    }

    private void checkVariablesDefined(NodeList list, SymbolHashTable table, String msg) {
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Identifier) {
                Identifier id = (Identifier)o;
                if (table.exists(id)) continue;
                Message.warning(id, msg);
                continue;
            }
            System.out.println("Not an identifier " + o.toString());
        }
    }
}

