/*
 * Decompiled with CFR 0.152.
 */
package com.mod_snmp.SmiParser.Semantics;

import com.mod_snmp.SmiParser.ErrorHandler.ErrorException;
import com.mod_snmp.SmiParser.ErrorHandler.Message;
import com.mod_snmp.SmiParser.ErrorHandler.SmiException;
import com.mod_snmp.SmiParser.Semantics.ModuleHashTable;
import com.mod_snmp.SmiParser.Semantics.SymbolHashTable;
import com.mod_snmp.SmiParser.SyntaxTree.AssignmentMacro;
import com.mod_snmp.SmiParser.SyntaxTree.AssignmentObject;
import com.mod_snmp.SmiParser.SyntaxTree.AssignmentType;
import com.mod_snmp.SmiParser.SyntaxTree.Identifier;
import com.mod_snmp.SmiParser.SyntaxTree.MacroBody;
import com.mod_snmp.SmiParser.SyntaxTree.ModuleDefinition;
import com.mod_snmp.SmiParser.SyntaxTree.ModuleImport;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoAgentCapabilities;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoModuleCompliance;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoModuleIdentity;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoNotificationGroup;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoNotificationType;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoObjectGroup;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoObjectIdentifier;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoObjectIdentity;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoObjectType;
import com.mod_snmp.SmiParser.SyntaxTree.ObjectInfoTrapType;
import com.mod_snmp.SmiParser.SyntaxTree.TypeChoice;
import com.mod_snmp.SmiParser.SyntaxTree.TypeSequence;
import com.mod_snmp.SmiParser.SyntaxTree.TypeTag;
import com.mod_snmp.SmiParser.SyntaxTree.TypeTextualConvention;
import com.mod_snmp.SmiParser.Visitor.DepthFirstVisitor;
import com.mod_snmp.SmiParser.Visitor.Visitor;
import java.util.Enumeration;

public class SemanticsSetup
extends DepthFirstVisitor
implements Visitor {
    private static SymbolHashTable current;

    @Override
    public void visit(ModuleDefinition n) {
        try {
            current = new SymbolHashTable();
            current.insert(n.moduleIdentifier, n);
            ModuleHashTable.insert(n.moduleIdentifier, current);
        }
        catch (SmiException exception) {
            Message.error(n.moduleIdentifier, exception.getMessage());
        }
        n.import_module_list.accept(this);
        n.assignmentList.accept(this);
    }

    @Override
    public void visit(ModuleImport n) {
        Enumeration e = n.symbolList.elements();
        while (e.hasMoreElements()) {
            Identifier id = (Identifier)e.nextElement();
            try {
                current.insert(id, n.moduleIdentifier);
            }
            catch (ErrorException exception) {
                Message.error(id, "imported twice");
            }
        }
    }

    @Override
    public void visit(AssignmentType n) {
        try {
            current.insert(n.identifier, n.type);
        }
        catch (ErrorException exception) {
            Message.error(n.identifier, "type assigned a type twice");
        }
    }

    @Override
    public void visit(TypeSequence n) {
    }

    @Override
    public void visit(TypeTextualConvention n) {
    }

    @Override
    public void visit(TypeChoice n) {
    }

    @Override
    public void visit(TypeTag n) {
        if (n.present()) {
            // empty if block
        }
    }

    @Override
    public void visit(AssignmentMacro n) {
        try {
            current.insert(n.identifier, n);
        }
        catch (ErrorException exception) {
            Message.error(n.identifier, "MACRO assigned a type twice");
        }
    }

    @Override
    public void visit(AssignmentObject n) {
        try {
            current.insert(n.identifier, n);
        }
        catch (ErrorException exception) {
            Message.error(n.identifier, "object assigned a value twice");
        }
    }

    @Override
    public void visit(ObjectInfoObjectIdentifier n) {
    }

    @Override
    public void visit(MacroBody n) {
    }

    @Override
    public void visit(ObjectInfoObjectType n) {
    }

    @Override
    public void visit(ObjectInfoModuleIdentity n) {
    }

    @Override
    public void visit(ObjectInfoObjectIdentity n) {
    }

    @Override
    public void visit(ObjectInfoObjectGroup n) {
    }

    @Override
    public void visit(ObjectInfoNotificationType n) {
    }

    @Override
    public void visit(ObjectInfoNotificationGroup n) {
    }

    @Override
    public void visit(ObjectInfoModuleCompliance n) {
    }

    @Override
    public void visit(ObjectInfoAgentCapabilities n) {
    }

    @Override
    public void visit(ObjectInfoTrapType n) {
    }
}

