/*
 * Decompiled with CFR 0.152.
 */
package com.mod_snmp.SmiParser.Semantics;

import com.mod_snmp.SmiParser.ErrorHandler.ErrorException;
import com.mod_snmp.SmiParser.SyntaxTree.Assignment;
import com.mod_snmp.SmiParser.SyntaxTree.Identifier;
import com.mod_snmp.SmiParser.SyntaxTree.ModuleDefinition;
import com.mod_snmp.SmiParser.SyntaxTree.ModuleIdentifier;
import com.mod_snmp.SmiParser.SyntaxTree.Node;
import com.mod_snmp.SmiParser.SyntaxTree.Type;
import java.util.Hashtable;

public class SymbolHashTable
extends Hashtable<String, Node> {
    public void insert(String key, Node obj) throws ErrorException {
        try {
            if (this.containsKey(key)) {
                throw new ErrorException("exists");
            }
            this.put(key, obj);
        }
        catch (NullPointerException e) {
            throw new ErrorException("invalid key \"null\"");
        }
    }

    public void insert(Identifier key, Type type) throws ErrorException {
        this.insert(key.toString(), (Node)type);
    }

    public void insert(Identifier key, Assignment assignment) throws ErrorException {
        this.insert(key.toString(), (Node)assignment);
    }

    public void insert(Identifier key, ModuleIdentifier moduleName) throws ErrorException {
        this.insert(key.toString(), (Node)moduleName);
    }

    public void insert(ModuleIdentifier key, ModuleDefinition module) throws ErrorException {
        this.insert(key.toString(), (Node)module);
    }

    @Override
    public void replace(String key, Node obj) throws ErrorException {
        try {
            this.remove(key);
            this.put(key, obj);
        }
        catch (NullPointerException e) {
            throw new ErrorException("invalid key \"null\"");
        }
    }

    @Override
    public void replace(Identifier key, Type type) throws ErrorException {
        this.replace(key.toString(), (Node)type);
    }

    public Node lookup(String key) throws ErrorException {
        try {
            if (this.containsKey(key)) {
                return (Node)this.get(key);
            }
            throw new ErrorException("does not exist");
        }
        catch (NullPointerException e) {
            throw new ErrorException("invalid key \"null\"");
        }
    }

    public Node lookup(Identifier key) throws ErrorException {
        return this.lookup(key.toString());
    }

    public ModuleDefinition lookup(ModuleIdentifier key) throws ErrorException {
        return (ModuleDefinition)this.lookup(key.toString());
    }

    public boolean exists(String key) {
        try {
            return this.containsKey(key);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public boolean exists(Identifier key) {
        return this.exists(key.toString());
    }

    public boolean exists(ModuleIdentifier key) {
        return this.exists(key.toString());
    }
}

