/*
 * Decompiled with CFR 0.152.
 */
package com.mod_snmp.SmiParser.SyntaxTree;

import com.mod_snmp.SmiParser.SyntaxTree.Node;
import com.mod_snmp.SmiParser.SyntaxTree.NodeToken;
import com.mod_snmp.SmiParser.Visitor.ObjectVisitor;
import com.mod_snmp.SmiParser.Visitor.Visitor;

public class NumericValue
implements Node {
    private Node parent;
    public NodeToken value;
    private long nval;

    public NumericValue(NodeToken n0) {
        this.value = n0;
        if (this.value != null) {
            this.value.setParent(this);
        }
        this.parseValue(this.value.toString());
    }

    public NumericValue(long nr) {
        this.parent = null;
        this.value = new NodeToken(nr + "");
        this.nval = nr;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public int line() {
        return this.value.line();
    }

    public long getValue() {
        return this.nval;
    }

    public void parseValue(String str_value) {
        try {
            if (-1 != str_value.indexOf(98) || -1 != str_value.indexOf(66)) {
                str_value = str_value.replace('B', ' ');
                str_value = str_value.replace('b', ' ');
                str_value = str_value.replace('\'', ' ');
                str_value = str_value.trim();
                this.nval = Long.parseLong(str_value, 2);
            } else if (-1 != str_value.indexOf(104) || -1 != str_value.indexOf(72)) {
                str_value = str_value.replace('H', ' ');
                str_value = str_value.replace('h', ' ');
                str_value = str_value.replace('\'', ' ');
                str_value = str_value.trim();
                this.nval = Long.parseLong(str_value, 16);
            } else {
                this.nval = Long.parseLong(str_value, 10);
            }
        }
        catch (Exception e) {
            this.nval = -1L;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public Object accept(ObjectVisitor v, Object argu) {
        return v.visit(this, argu);
    }

    @Override
    public void setParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }
}

