/*
 * Decompiled with CFR 0.152.
 */
package com.mod_snmp.SmiParser.SyntaxTree;

import com.mod_snmp.SmiParser.SyntaxTree.Identifier;
import com.mod_snmp.SmiParser.SyntaxTree.Node;
import com.mod_snmp.SmiParser.SyntaxTree.NodeToken;
import com.mod_snmp.SmiParser.SyntaxTree.NumericValue;
import com.mod_snmp.SmiParser.Visitor.ObjectVisitor;
import com.mod_snmp.SmiParser.Visitor.Visitor;

public class OidValue
implements Node {
    private Node parent;
    public Identifier name;
    private boolean grammarSet;
    public NumericValue numval;

    public OidValue() {
        this.grammarSet = false;
        this.name = null;
        this.numval = new NumericValue(-1L);
    }

    public OidValue(Identifier id) {
        this.grammarSet = true;
        this.name = id;
        if (this.name != null) {
            this.name.setParent(this);
        }
        this.numval = new NumericValue(-1L);
    }

    public OidValue(Identifier id, NumericValue nr) {
        this.grammarSet = true;
        this.name = id;
        if (this.name != null) {
            this.name.setParent(this);
        }
        this.numval = nr;
        if (this.numval != null) {
            this.numval.setParent(this);
        }
    }

    public OidValue(NumericValue nr) {
        this.grammarSet = false;
        this.name = null;
        this.numval = nr;
        if (this.numval != null) {
            this.numval.setParent(this);
        }
    }

    public String toString() {
        if (this.name != null) {
            return this.name.toString();
        }
        return this.numval.toString();
    }

    @Override
    public int line() {
        if (this.name != null) {
            return this.name.line();
        }
        return this.numval.line();
    }

    public void setName(Identifier id) {
        this.name = id;
        if (this.name != null) {
            this.name.setParent(this);
        }
    }

    public void setName(String idStr) {
        this.name = Identifier.Value(new NodeToken(idStr));
        if (this.name != null) {
            this.name.setParent(this);
        }
    }

    public void setNumber(NumericValue nr) {
        this.numval = nr;
        if (this.numval != null) {
            this.numval.setParent(this);
        }
    }

    public Identifier getName() {
        return this.name;
    }

    public NumericValue getNumber() {
        return this.numval;
    }

    public boolean isGrammarSet() {
        return this.grammarSet;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasNumber() {
        return this.numval != null && this.numval.getValue() > -1L;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public Object accept(ObjectVisitor v, Object argu) {
        return v.visit(this, argu);
    }

    @Override
    public void setParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }
}

