/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.IdentityHashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIdentityHashSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Object VALUE = new Object();
    private transient IdentityHashMap<E, Object> identityHashMap = new IdentityHashMap();

    @Override
    public Iterator<E> iterator() {
        return this.identityHashMap.keySet().iterator();
    }

    @Override
    public int size() {
        return this.identityHashMap.size();
    }

    @Override
    public boolean add(E e) {
        return this.identityHashMap.put(e, VALUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.identityHashMap.remove(o) == VALUE;
    }

    @Override
    public boolean contains(Object o) {
        return this.identityHashMap.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.identityHashMap.isEmpty();
    }

    @Override
    public void clear() {
        this.identityHashMap.clear();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.write(this.identityHashMap.size());
        for (E e : this.identityHashMap.keySet()) {
            s.writeObject(e);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.identityHashMap = new IdentityHashMap(size);
        for (int i = 0; i < size; ++i) {
            this.identityHashMap.put(s.readObject(), VALUE);
        }
    }
}

