/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.common.collection.OMVRBTree;
import com.orientechnologies.common.collection.OMVRBTreeMemory;
import com.orientechnologies.common.collection.ONavigableMap;
import com.orientechnologies.common.collection.ONavigableSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBTreeSet<E>
extends AbstractSet<E>
implements ONavigableSet<E>,
Cloneable,
Serializable {
    private transient ONavigableMap<E, Object> m;
    private static final Object PRESENT = new Object();
    private static final long serialVersionUID = -2479143000061671589L;

    OMVRBTreeSet(ONavigableMap<E, Object> m) {
        this.m = m;
    }

    public OMVRBTreeSet() {
        this(new OMVRBTreeMemory());
    }

    public OMVRBTreeSet(Comparator<? super E> comparator) {
        this(new OMVRBTreeMemory(comparator));
    }

    public OMVRBTreeSet(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    public OMVRBTreeSet(SortedSet<E> s) {
        this(s.comparator());
        this.addAll(s);
    }

    @Override
    public OLazyIterator<E> iterator() {
        return this.m.navigableKeySet().iterator();
    }

    @Override
    public OLazyIterator<E> descendingIterator() {
        return this.m.descendingKeySet().iterator();
    }

    @Override
    public ONavigableSet<E> descendingSet() {
        return new OMVRBTreeSet<E>(this.m.descendingMap());
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.m.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.m.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.m.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.m.size() == 0 && c.size() > 0 && c instanceof SortedSet && this.m instanceof OMVRBTree) {
            Comparator mc;
            SortedSet set = (SortedSet)c;
            OMVRBTree map = (OMVRBTree)this.m;
            Comparator cc = set.comparator();
            if (cc == (mc = map.comparator()) || cc != null && cc.equals(mc)) {
                map.addAllForOTreeSet(set, PRESENT);
                return true;
            }
        }
        return super.addAll(c);
    }

    @Override
    public ONavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new OMVRBTreeSet<E>(this.m.subMap(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public ONavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new OMVRBTreeSet<E>(this.m.headMap(toElement, inclusive));
    }

    @Override
    public ONavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new OMVRBTreeSet<E>(this.m.tailMap(fromElement, inclusive));
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.m.comparator();
    }

    @Override
    public E first() {
        return (E)this.m.firstKey();
    }

    @Override
    public E last() {
        return (E)this.m.lastKey();
    }

    @Override
    public E lower(E e) {
        return this.m.lowerKey(e);
    }

    @Override
    public E floor(E e) {
        return this.m.floorKey(e);
    }

    @Override
    public E ceiling(E e) {
        return this.m.ceilingKey(e);
    }

    @Override
    public E higher(E e) {
        return this.m.higherKey(e);
    }

    @Override
    public E pollFirst() {
        Map.Entry<E, Object> e = this.m.pollFirstEntry();
        return e == null ? null : (E)e.getKey();
    }

    @Override
    public E pollLast() {
        Map.Entry<E, Object> e = this.m.pollLastEntry();
        return e == null ? null : (E)e.getKey();
    }

    public Object clone() {
        OMVRBTreeSet clone = null;
        try {
            clone = (OMVRBTreeSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.m = new OMVRBTreeMemory<E, Object>(this.m);
        return clone;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.m.comparator());
        s.writeInt(this.m.size());
        Iterator i = this.m.keySet().iterator();
        while (i.hasNext()) {
            s.writeObject(i.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Comparator c = (Comparator)s.readObject();
        OMVRBTreeMemory<Object, Object> tm = c == null ? new OMVRBTreeMemory<E, Object>() : new OMVRBTreeMemory(c);
        this.m = tm;
        int size = s.readInt();
        tm.readOTreeSet(size, s, PRESENT);
    }
}

