/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.parser;

import com.orientechnologies.common.io.OIOException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class OStringForwardReader
implements CharSequence {
    private final BufferedReader input;
    private char[] buffer = new char[1000];
    private long start = -1L;
    private long end = -1L;
    private long current = 0L;
    private long size = 0L;
    private static final int DEFAULT_SIZE = 1000;

    public OStringForwardReader(InputStream iInput) {
        this.input = new BufferedReader(new InputStreamReader(iInput));
    }

    public OStringForwardReader(Reader iReader) {
        this.input = new BufferedReader(iReader);
    }

    public OStringForwardReader(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
        this.size = file.length();
    }

    public char charAt(int iIndex) {
        if ((long)iIndex < this.start) {
            throw new IllegalStateException("Cannot read backward");
        }
        if ((long)iIndex >= this.end) {
            this.read(iIndex);
        }
        if ((long)iIndex > this.current) {
            this.current = iIndex;
        }
        return this.buffer[(int)((long)iIndex - this.start)];
    }

    private void read(int iIndex) {
        try {
            for (long i = this.end; i < (long)(iIndex - 1); ++i) {
                this.input.read();
            }
            this.start = iIndex;
            int byteRead = this.input.read(this.buffer);
            this.end = this.start + (long)byteRead;
            this.current = this.start;
        }
        catch (IOException e) {
            throw new OIOException("Error in read", e);
        }
    }

    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
        }
        this.end = -1L;
        this.start = -1L;
        this.size = 0L;
        this.current = 0L;
    }

    public boolean ready() {
        try {
            return this.current < this.end || this.input.ready();
        }
        catch (IOException e) {
            throw new OIOException("Error in ready", e);
        }
    }

    public int length() {
        return (int)this.size;
    }

    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public long getPosition() {
        return this.current;
    }

    public String toString() {
        return (this.start > 0L ? "..." : "") + new String(this.buffer) + (this.ready() ? "..." : "");
    }

    public int indexOf(char iToFind) {
        int i = (int)this.current;
        while ((long)i < this.size) {
            if (this.charAt(i) == iToFind) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String subString(int iOffset, char iToFind, boolean iIncluded) {
        StringBuilder buffer = new StringBuilder();
        int i = iOffset;
        while ((long)i < this.size) {
            char c = this.charAt(i);
            if (c == iToFind) {
                if (iIncluded) {
                    buffer.append(c);
                }
                return buffer.toString();
            }
            buffer.append(c);
            ++i;
        }
        buffer.setLength(0);
        return null;
    }
}

