/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.orient.core.cache.OAbstractRecordCache;
import com.orientechnologies.orient.core.cache.OCacheLocator;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.OStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OLevel2RecordCache
extends OAbstractRecordCache {
    private STRATEGY strategy;

    public OLevel2RecordCache(OStorage iStorage) {
        super(new OCacheLocator().secondaryCache());
        this.profilerPrefix = "storage." + iStorage.getName();
        this.strategy = STRATEGY.values()[OGlobalConfiguration.CACHE_LEVEL2_STRATEGY.getValueAsInteger()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(ORecordInternal<?> fresh) {
        if (!this.isEnabled() || fresh == null || fresh.isDirty() || fresh.getIdentity().isNew() || !fresh.getIdentity().isValid() || fresh.getIdentity().getClusterId() == this.excludedCluster) {
            return;
        }
        if (fresh.isPinned() == null || fresh.isPinned().booleanValue()) {
            this.underlying.lock(fresh.getIdentity());
            try {
                ORecordInternal<?> current = this.underlying.get(fresh.getIdentity());
                if (current != null && current.getVersion() >= fresh.getVersion()) {
                    return;
                }
                if (ODatabaseRecordThreadLocal.INSTANCE.isDefined() && !ODatabaseRecordThreadLocal.INSTANCE.get().isClosed()) {
                    this.underlying.put((ORecordInternal)fresh.flatCopy());
                }
                fresh.detach();
                this.underlying.put(fresh);
            }
            finally {
                this.underlying.unlock(fresh.getIdentity());
            }
        } else {
            this.underlying.remove(fresh.getIdentity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ORecordInternal<?> retrieveRecord(ORID iRID) {
        ORecordInternal<?> record;
        if (!this.isEnabled() || iRID.getClusterId() == this.excludedCluster) {
            return null;
        }
        this.underlying.lock(iRID);
        try {
            record = this.underlying.remove(iRID);
            if (record == null || record.isDirty()) {
                ORecordInternal<?> oRecordInternal = null;
                return oRecordInternal;
            }
            if (this.strategy == STRATEGY.COPY_RECORD) {
                this.underlying.put((ORecordInternal)record.flatCopy());
            }
        }
        finally {
            this.underlying.unlock(iRID);
        }
        return record;
    }

    public void setStrategy(STRATEGY newStrategy) {
        this.strategy = newStrategy;
    }

    public String toString() {
        return "STORAGE level2 cache records = " + this.getSize() + ", maxSize = " + this.getMaxSize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STRATEGY {
        POP_RECORD,
        COPY_RECORD;

    }
}

