/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.config;

import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterHoleConfiguration;
import com.orientechnologies.orient.core.config.OStorageDataConfiguration;
import com.orientechnologies.orient.core.config.OStorageDataHoleConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.config.OStorageMemoryClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePhysicalClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageSegmentConfiguration;
import com.orientechnologies.orient.core.config.OStorageTxConfiguration;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class OStorageConfiguration
implements OSerializableStream {
    public static final ORecordId CONFIG_RID = new ORecordId(0, 0L);
    public static final int CURRENT_VERSION = 3;
    public int version = -1;
    public String name;
    public String schemaRecordId;
    public String dictionaryRecordId;
    public String indexMgrRecordId;
    public String localeLanguage = Locale.getDefault().getLanguage();
    public String localeCountry = Locale.getDefault().getCountry();
    public String dateFormat = "yyyy-MM-dd";
    public String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    public final OStorageSegmentConfiguration fileTemplate;
    public List<OStorageClusterConfiguration> clusters = new ArrayList<OStorageClusterConfiguration>();
    public List<OStorageDataConfiguration> dataSegments = new ArrayList<OStorageDataConfiguration>();
    public OStorageTxConfiguration txSegment = new OStorageTxConfiguration();
    public List<OStorageEntryConfiguration> properties = new ArrayList<OStorageEntryConfiguration>();
    private transient Locale localeInstance;
    private transient DecimalFormatSymbols unusualSymbols;
    protected transient OStorage storage;

    public OStorageConfiguration(OStorage iStorage) {
        this.storage = iStorage;
        this.fileTemplate = new OStorageSegmentConfiguration();
    }

    public OStorageConfiguration load() throws OSerializationException {
        byte[] record = this.storage.readRecord((ORecordId)OStorageConfiguration.CONFIG_RID, null, (boolean)false, null).buffer;
        if (record == null) {
            throw new OStorageException("Cannot load database's configuration. The database seems to be corrupted.");
        }
        this.fromStream(record);
        return this;
    }

    public void update() throws OSerializationException {
        byte[] record = this.toStream();
        this.storage.updateRecord(CONFIG_RID, record, -1, (byte)98, 0, null);
    }

    public boolean isEmpty() {
        return this.clusters.isEmpty();
    }

    public String getDirectory() {
        return this.fileTemplate.location != null ? this.fileTemplate.getLocation() : ((OStorageLocal)this.storage).getStoragePath();
    }

    public Locale getLocaleInstance() {
        if (this.localeInstance == null) {
            this.localeInstance = new Locale(this.localeLanguage, this.localeCountry);
        }
        return this.localeInstance;
    }

    public SimpleDateFormat getDateFormatInstance() {
        SimpleDateFormat dateFormatInstance = new SimpleDateFormat(this.dateFormat);
        dateFormatInstance.setLenient(false);
        return dateFormatInstance;
    }

    public SimpleDateFormat getDateTimeFormatInstance() {
        SimpleDateFormat dateTimeFormatInstance = new SimpleDateFormat(this.dateTimeFormat);
        dateTimeFormatInstance.setLenient(false);
        return dateTimeFormatInstance;
    }

    public DecimalFormatSymbols getUnusualSymbols() {
        if (this.unusualSymbols == null) {
            this.unusualSymbols = new DecimalFormatSymbols(this.getLocaleInstance());
        }
        return this.unusualSymbols;
    }

    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        int i;
        int i2;
        String[] values = new String(iStream).split("\\|");
        int index = 0;
        this.version = Integer.parseInt(this.read(values[index++]));
        this.name = this.read(values[index++]);
        this.schemaRecordId = this.read(values[index++]);
        this.dictionaryRecordId = this.read(values[index++]);
        this.indexMgrRecordId = this.version > 0 ? this.read(values[index++]) : null;
        this.localeLanguage = this.read(values[index++]);
        this.localeCountry = this.read(values[index++]);
        this.dateFormat = this.read(values[index++]);
        this.dateTimeFormat = this.read(values[index++]);
        if (this.version > 1) {
            index = this.phySegmentFromStream(values, index, this.fileTemplate);
        }
        int size = Integer.parseInt(this.read(values[index++]));
        this.clusters = new ArrayList<OStorageClusterConfiguration>(size);
        for (i2 = 0; i2 < size; ++i2) {
            OStorageClusterConfiguration currentCluster;
            String clusterType;
            int clusterId;
            if ((clusterId = Integer.parseInt(this.read(values[index++]))) == -1) continue;
            String clusterName = this.read(values[index++]);
            int targetDataSegmentId = this.version >= 3 ? Integer.parseInt(this.read(values[index++])) : 0;
            if ((clusterType = this.read(values[index++])).equals("p")) {
                OStoragePhysicalClusterConfiguration phyCluster = new OStoragePhysicalClusterConfiguration(this, clusterId, targetDataSegmentId);
                phyCluster.name = clusterName;
                index = this.phySegmentFromStream(values, index, phyCluster);
                phyCluster.setHoleFile(new OStorageClusterHoleConfiguration(phyCluster, this.read(values[index++]), this.read(values[index++]), this.read(values[index++])));
                currentCluster = phyCluster;
            } else if (clusterType.equals("m")) {
                currentCluster = new OStorageMemoryClusterConfiguration(clusterName, clusterId, targetDataSegmentId);
            } else {
                throw new IllegalArgumentException("Unsupported cluster type: " + clusterType);
            }
            for (int c = this.clusters.size(); c <= clusterId; ++c) {
                this.clusters.add(null);
            }
            this.clusters.set(clusterId, currentCluster);
        }
        size = Integer.parseInt(this.read(values[index++]));
        this.dataSegments = new ArrayList<OStorageDataConfiguration>(size);
        for (i2 = 0; i2 < size; ++i2) {
            this.dataSegments.add(null);
        }
        for (i = 0; i < size; ++i) {
            int dataId = Integer.parseInt(this.read(values[index++]));
            String dataName = this.read(values[index++]);
            OStorageDataConfiguration data = new OStorageDataConfiguration(this, dataName, dataId);
            index = this.phySegmentFromStream(values, index, data);
            data.holeFile = new OStorageDataHoleConfiguration(data, this.read(values[index++]), this.read(values[index++]), this.read(values[index++]));
            this.dataSegments.set(dataId, data);
        }
        this.txSegment = new OStorageTxConfiguration(this.read(values[index++]), this.read(values[index++]), this.read(values[index++]), this.read(values[index++]), this.read(values[index++]));
        size = Integer.parseInt(this.read(values[index++]));
        this.properties = new ArrayList<OStorageEntryConfiguration>(size);
        for (i = 0; i < size; ++i) {
            this.properties.add(new OStorageEntryConfiguration(this.read(values[index++]), this.read(values[index++])));
        }
        return this;
    }

    public byte[] toStream() throws OSerializationException {
        StringBuilder buffer = new StringBuilder();
        this.write(buffer, 3);
        this.write(buffer, this.name);
        this.write(buffer, this.schemaRecordId);
        this.write(buffer, this.dictionaryRecordId);
        this.write(buffer, this.indexMgrRecordId);
        this.write(buffer, this.localeLanguage);
        this.write(buffer, this.localeCountry);
        this.write(buffer, this.dateFormat);
        this.write(buffer, this.dateTimeFormat);
        this.phySegmentToStream(buffer, this.fileTemplate);
        this.write(buffer, this.clusters.size());
        for (OStorageClusterConfiguration c : this.clusters) {
            if (c == null) {
                this.write(buffer, -1);
                continue;
            }
            this.write(buffer, c.getId());
            this.write(buffer, c.getName());
            this.write(buffer, c.getDataSegmentId());
            if (c instanceof OStoragePhysicalClusterConfiguration) {
                this.write(buffer, "p");
                this.phySegmentToStream(buffer, (OStoragePhysicalClusterConfiguration)c);
                this.fileToStream(buffer, ((OStoragePhysicalClusterConfiguration)c).getHoleFile());
                continue;
            }
            if (!(c instanceof OStorageMemoryClusterConfiguration)) continue;
            this.write(buffer, "m");
        }
        this.write(buffer, this.dataSegments.size());
        for (OStorageDataConfiguration d : this.dataSegments) {
            if (d == null) continue;
            this.write(buffer, d.id);
            this.write(buffer, d.name);
            this.phySegmentToStream(buffer, d);
            this.fileToStream(buffer, d.holeFile);
        }
        this.fileToStream(buffer, this.txSegment);
        this.write(buffer, this.txSegment.isSynchRecord());
        this.write(buffer, this.txSegment.isSynchTx());
        this.write(buffer, this.properties.size());
        for (OStorageEntryConfiguration e : this.properties) {
            this.entryToStream(buffer, e);
        }
        buffer.append("|");
        return buffer.toString().getBytes();
    }

    private int phySegmentFromStream(String[] values, int index, OStorageSegmentConfiguration iSegment) {
        iSegment.location = this.version > 2 ? this.read(values[index++]) : null;
        iSegment.maxSize = this.read(values[index++]);
        iSegment.fileType = this.read(values[index++]);
        iSegment.fileStartSize = this.read(values[index++]);
        iSegment.fileMaxSize = this.read(values[index++]);
        iSegment.fileIncrementSize = this.read(values[index++]);
        iSegment.defrag = this.read(values[index++]);
        int size = Integer.parseInt(this.read(values[index++]));
        iSegment.infoFiles = new OStorageFileConfiguration[size];
        for (int i = 0; i < size; ++i) {
            int pos;
            String fileName;
            if (!(fileName = this.read(values[index++])).contains("$") && (pos = fileName.indexOf("/databases")) > -1) {
                fileName = "${ORIENTDB_HOME}" + fileName.substring(pos);
            }
            iSegment.infoFiles[i] = new OStorageFileConfiguration(iSegment, fileName, this.read(values[index++]), this.read(values[index++]), iSegment.fileIncrementSize);
        }
        return index;
    }

    private void phySegmentToStream(StringBuilder iBuffer, OStorageSegmentConfiguration iSegment) {
        this.write(iBuffer, iSegment.location);
        this.write(iBuffer, iSegment.maxSize);
        this.write(iBuffer, iSegment.fileType);
        this.write(iBuffer, iSegment.fileStartSize);
        this.write(iBuffer, iSegment.fileMaxSize);
        this.write(iBuffer, iSegment.fileIncrementSize);
        this.write(iBuffer, iSegment.defrag);
        this.write(iBuffer, iSegment.infoFiles.length);
        for (OStorageFileConfiguration f : iSegment.infoFiles) {
            this.fileToStream(iBuffer, f);
        }
    }

    private void fileToStream(StringBuilder iBuffer, OStorageFileConfiguration iFile) {
        this.write(iBuffer, iFile.path);
        this.write(iBuffer, iFile.type);
        this.write(iBuffer, iFile.maxSize);
    }

    private void entryToStream(StringBuilder iBuffer, OStorageEntryConfiguration iEntry) {
        this.write(iBuffer, iEntry.name);
        this.write(iBuffer, iEntry.value);
    }

    private String read(String iValue) {
        if (iValue.equals(" ")) {
            return null;
        }
        return iValue;
    }

    private void write(StringBuilder iBuffer, Object iValue) {
        if (iBuffer.length() > 0) {
            iBuffer.append('|');
        }
        iBuffer.append(iValue != null ? iValue.toString() : Character.valueOf(' '));
    }

    public void create() throws IOException {
        this.storage.createRecord(0, CONFIG_RID, new byte[]{0, 0, 0, 0}, 0, (byte)98, 0, null);
    }

    public void synch() throws IOException {
    }

    public void close() throws IOException {
    }

    public void setCluster(OStorageClusterConfiguration config) {
        while (config.getId() >= this.clusters.size()) {
            this.clusters.add(null);
        }
        this.clusters.set(config.getId(), config);
    }

    public void dropCluster(int iClusterId) {
        if (iClusterId < this.clusters.size()) {
            this.clusters.set(iClusterId, null);
            this.update();
        }
    }

    public void dropDataSegment(int iId) {
        if (iId < this.dataSegments.size()) {
            this.dataSegments.set(iId, null);
            this.update();
        }
    }
}

