/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLevel1RecordCache;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ODatabaseWrapperAbstract<DB extends ODatabase>
implements ODatabase {
    protected DB underlying;
    protected ODatabaseComplex<?> databaseOwner;

    public ODatabaseWrapperAbstract(DB iDatabase) {
        this.underlying = iDatabase;
        this.databaseOwner = (ODatabaseComplex)((Object)this);
    }

    public void finalize() {
    }

    public <THISDB extends ODatabase> THISDB open(String iUserName, String iUserPassword) {
        this.underlying.open(iUserName, iUserPassword);
        Orient.instance().getDatabaseFactory().register(this.databaseOwner);
        return (THISDB)this;
    }

    public <THISDB extends ODatabase> THISDB create() {
        this.underlying.create();
        Orient.instance().getDatabaseFactory().register(this.databaseOwner);
        return (THISDB)this;
    }

    @Override
    public boolean exists() {
        return this.underlying.exists();
    }

    @Override
    public void reload() {
        this.underlying.reload();
    }

    @Override
    public void close() {
        this.underlying.close();
        Orient.instance().getDatabaseFactory().unregister(this.databaseOwner);
    }

    @Override
    @Deprecated
    public void delete() {
        this.drop();
    }

    @Override
    public void drop() {
        this.underlying.drop();
        Orient.instance().getDatabaseFactory().unregister(this.databaseOwner);
    }

    @Override
    public ODatabase.STATUS getStatus() {
        return this.underlying.getStatus();
    }

    public <THISDB extends ODatabase> THISDB setStatus(ODatabase.STATUS iStatus) {
        this.underlying.setStatus(iStatus);
        return (THISDB)this;
    }

    @Override
    public String getName() {
        return this.underlying.getName();
    }

    @Override
    public String getURL() {
        return this.underlying.getURL();
    }

    @Override
    public OStorage getStorage() {
        return this.underlying.getStorage();
    }

    @Override
    public OLevel1RecordCache getLevel1Cache() {
        this.checkOpeness();
        return this.underlying.getLevel1Cache();
    }

    @Override
    public OLevel2RecordCache getLevel2Cache() {
        this.checkOpeness();
        return this.getStorage().getLevel2Cache();
    }

    @Override
    public boolean isClosed() {
        return this.underlying.isClosed();
    }

    @Override
    public long countClusterElements(int iClusterId) {
        this.checkOpeness();
        return this.underlying.countClusterElements(iClusterId);
    }

    @Override
    public long countClusterElements(int[] iClusterIds) {
        this.checkOpeness();
        return this.underlying.countClusterElements(iClusterIds);
    }

    @Override
    public long countClusterElements(String iClusterName) {
        this.checkOpeness();
        return this.underlying.countClusterElements(iClusterName);
    }

    @Override
    public int getClusters() {
        this.checkOpeness();
        return this.underlying.getClusters();
    }

    @Override
    public Collection<String> getClusterNames() {
        this.checkOpeness();
        return this.underlying.getClusterNames();
    }

    @Override
    public String getClusterType(String iClusterName) {
        this.checkOpeness();
        return this.underlying.getClusterType(iClusterName);
    }

    @Override
    public int getDataSegmentIdByName(String iDataSegmentName) {
        this.checkOpeness();
        return this.underlying.getDataSegmentIdByName(iDataSegmentName);
    }

    @Override
    public String getDataSegmentNameById(int iDataSegmentId) {
        this.checkOpeness();
        return this.underlying.getDataSegmentNameById(iDataSegmentId);
    }

    @Override
    public int getClusterIdByName(String iClusterName) {
        this.checkOpeness();
        return this.underlying.getClusterIdByName(iClusterName);
    }

    @Override
    public String getClusterNameById(int iClusterId) {
        this.checkOpeness();
        return this.underlying.getClusterNameById(iClusterId);
    }

    @Override
    public long getClusterRecordSizeById(int iClusterId) {
        return this.underlying.getClusterRecordSizeById(iClusterId);
    }

    @Override
    public long getClusterRecordSizeByName(String iClusterName) {
        return this.underlying.getClusterRecordSizeByName(iClusterName);
    }

    @Override
    public int addCluster(String iType, String iClusterName, String iLocation, String iDataSegmentName, Object ... iParameters) {
        this.checkOpeness();
        return this.underlying.addCluster(iType, iClusterName, iLocation, iDataSegmentName, iParameters);
    }

    @Override
    @Deprecated
    public int addPhysicalCluster(String iClusterName, String iLocation, int iSize) {
        this.checkOpeness();
        return this.underlying.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), iClusterName, iLocation, null, new Object[0]);
    }

    @Deprecated
    public int addPhysicalCluster(String iClusterName) {
        this.checkOpeness();
        return this.underlying.addPhysicalCluster(iClusterName, null, -1);
    }

    @Override
    public int addCluster(String iClusterName, OStorage.CLUSTER_TYPE iType, Object ... iParameters) {
        this.checkOpeness();
        return this.underlying.addCluster(iType.toString(), iClusterName, null, null, iParameters);
    }

    public int addCluster(String iClusterName, OStorage.CLUSTER_TYPE iType) {
        this.checkOpeness();
        return this.underlying.addCluster(iType.toString(), iClusterName, null, null, new Object[0]);
    }

    @Override
    public boolean dropDataSegment(String name) {
        return this.underlying.dropDataSegment(name);
    }

    @Override
    public boolean dropCluster(String iClusterName) {
        this.getLevel1Cache().freeCluster(this.getClusterIdByName(iClusterName));
        return this.underlying.dropCluster(iClusterName);
    }

    @Override
    public boolean dropCluster(int iClusterId) {
        this.getLevel1Cache().freeCluster(iClusterId);
        return this.underlying.dropCluster(iClusterId);
    }

    @Override
    public int addDataSegment(String iSegmentName, String iLocation) {
        this.checkOpeness();
        return this.underlying.addDataSegment(iSegmentName, iLocation);
    }

    @Override
    public int getDefaultClusterId() {
        this.checkOpeness();
        return this.underlying.getDefaultClusterId();
    }

    @Override
    public boolean declareIntent(OIntent iIntent) {
        this.checkOpeness();
        return this.underlying.declareIntent(iIntent);
    }

    public <DBTYPE extends ODatabase> DBTYPE getUnderlying() {
        return (DBTYPE)this.underlying;
    }

    public ODatabaseComplex<?> getDatabaseOwner() {
        return this.databaseOwner;
    }

    public ODatabaseComplex<?> setDatabaseOwner(ODatabaseComplex<?> iOwner) {
        this.databaseOwner = iOwner;
        return (ODatabaseComplex)((Object)this);
    }

    public boolean equals(Object iOther) {
        if (!(iOther instanceof ODatabase)) {
            return false;
        }
        ODatabase other = (ODatabase)iOther;
        return other.getName().equals(this.getName());
    }

    public String toString() {
        return this.underlying.toString();
    }

    @Override
    public Object setProperty(String iName, Object iValue) {
        return this.underlying.setProperty(iName, iValue);
    }

    @Override
    public Object getProperty(String iName) {
        return this.underlying.getProperty(iName);
    }

    @Override
    public Iterator<Map.Entry<String, Object>> getProperties() {
        return this.underlying.getProperties();
    }

    @Override
    public Object get(ODatabase.ATTRIBUTES iAttribute) {
        return this.underlying.get(iAttribute);
    }

    public <THISDB extends ODatabase> THISDB set(ODatabase.ATTRIBUTES attribute, Object iValue) {
        return (THISDB)this.underlying.set(attribute, iValue);
    }

    @Override
    public void registerListener(ODatabaseListener iListener) {
        this.underlying.registerListener(iListener);
    }

    @Override
    public void unregisterListener(ODatabaseListener iListener) {
        this.underlying.unregisterListener(iListener);
    }

    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return this.getStorage().callInLock(iCallable, iExclusiveLock);
    }

    @Override
    public long getSize() {
        return this.underlying.getSize();
    }

    protected void checkOpeness() {
        if (this.isClosed()) {
            throw new ODatabaseException("Database '" + this.getURL() + "' is closed");
        }
    }
}

