/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTrackedMap<T>
extends LinkedHashMap<Object, T>
implements ORecordElement,
OTrackedMultiValue<Object, T>,
Serializable {
    protected final ORecord<?> sourceRecord;
    private ORecordElement.STATUS status = ORecordElement.STATUS.NOT_LOADED;
    private Set<OMultiValueChangeListener<Object, T>> changeListeners = Collections.newSetFromMap(new WeakHashMap());
    protected Class<?> genericClass;

    public OTrackedMap(ORecord<?> iRecord, Map<Object, T> iOrigin, Class<?> cls) {
        this(iRecord);
        this.genericClass = cls;
        if (iOrigin != null && !iOrigin.isEmpty()) {
            this.putAll(iOrigin);
        }
    }

    public OTrackedMap(ORecord<?> iSourceRecord) {
        this.sourceRecord = iSourceRecord;
    }

    @Override
    public T put(Object iKey, T iValue) {
        boolean containsKey = this.containsKey(iKey);
        T oldValue = super.put(iKey, iValue);
        if (containsKey && oldValue == iValue) {
            return oldValue;
        }
        if (containsKey) {
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<Object, T>(OMultiValueChangeEvent.OChangeType.UPDATE, iKey, iValue, oldValue));
        } else {
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<Object, T>(OMultiValueChangeEvent.OChangeType.ADD, iKey, iValue));
        }
        return oldValue;
    }

    @Override
    public T remove(Object iKey) {
        boolean containsKey = this.containsKey(iKey);
        Object oldValue = super.remove(iKey);
        if (containsKey) {
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<Object, Object>(OMultiValueChangeEvent.OChangeType.REMOVE, iKey, null, oldValue));
        }
        return (T)oldValue;
    }

    @Override
    public void clear() {
        HashMap origValues = this.changeListeners.isEmpty() ? null : new HashMap(this);
        super.clear();
        if (origValues != null) {
            for (Map.Entry entry : origValues.entrySet()) {
                this.fireCollectionChangedEvent(new OMultiValueChangeEvent(OMultiValueChangeEvent.OChangeType.REMOVE, entry.getKey(), null, entry.getValue()));
            }
        } else {
            this.setDirty();
        }
    }

    @Override
    public void putAll(Map<? extends Object, ? extends T> m) {
        super.putAll(m);
    }

    public OTrackedMap<T> setDirty() {
        if (this.status != ORecordElement.STATUS.UNMARSHALLING && this.sourceRecord != null && !this.sourceRecord.isDirty()) {
            this.sourceRecord.setDirty();
        }
        return this;
    }

    @Override
    public void onBeforeIdentityChanged(ORID iRID) {
        this.remove(iRID);
    }

    @Override
    public void onAfterIdentityChanged(ORecord<?> iRecord) {
        super.put(iRecord.getIdentity(), iRecord);
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this.status;
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this.status = iStatus;
    }

    @Override
    public void addChangeListener(OMultiValueChangeListener<Object, T> changeListener) {
        this.changeListeners.add(changeListener);
    }

    @Override
    public void removeRecordChangeListener(OMultiValueChangeListener<Object, T> changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public Map<Object, T> returnOriginalState(List<OMultiValueChangeEvent<Object, T>> multiValueChangeEvents) {
        HashMap<Object, T> reverted = new HashMap<Object, T>(this);
        ListIterator<OMultiValueChangeEvent<Object, T>> listIterator = multiValueChangeEvents.listIterator(multiValueChangeEvents.size());
        block5: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<Object, T> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block5;
                }
                case REMOVE: {
                    reverted.put(event.getKey(), event.getOldValue());
                    continue block5;
                }
                case UPDATE: {
                    reverted.put(event.getKey(), event.getOldValue());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    protected void fireCollectionChangedEvent(OMultiValueChangeEvent<Object, T> event) {
        if (this.status == ORecordElement.STATUS.UNMARSHALLING) {
            return;
        }
        this.setDirty();
        for (OMultiValueChangeListener<Object, T> changeListener : this.changeListeners) {
            if (changeListener == null) continue;
            changeListener.onAfterRecordChanged(event);
        }
    }

    @Override
    public Class<?> getGenericClass() {
        return this.genericClass;
    }

    public void setGenericClass(Class<?> genericClass) {
        this.genericClass = genericClass;
    }

    private Object writeReplace() {
        return new LinkedHashMap(this);
    }
}

